/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.io.grpc;

import java.util.List;
import org.sparkproject.io.grpc.Configurator;
import org.sparkproject.io.grpc.ConfiguratorRegistry;
import org.sparkproject.io.grpc.Internal;
import org.sparkproject.io.grpc.InternalConfigurator;
import org.sparkproject.io.grpc.ManagedChannelBuilder;
import org.sparkproject.io.grpc.ServerBuilder;

@Internal
public final class InternalConfiguratorRegistry {
    private InternalConfiguratorRegistry() {
    }

    public static void setConfigurators(List<InternalConfigurator> configurators) {
        ConfiguratorRegistry.getDefaultRegistry().setConfigurators(configurators);
    }

    public static List<?> getConfigurators() {
        return ConfiguratorRegistry.getDefaultRegistry().getConfigurators();
    }

    public static void configureChannelBuilder(ManagedChannelBuilder<?> channelBuilder) {
        for (Configurator configurator : ConfiguratorRegistry.getDefaultRegistry().getConfigurators()) {
            configurator.configureChannelBuilder(channelBuilder);
        }
    }

    public static void configureServerBuilder(ServerBuilder<?> serverBuilder) {
        for (Configurator configurator : ConfiguratorRegistry.getDefaultRegistry().getConfigurators()) {
            configurator.configureServerBuilder(serverBuilder);
        }
    }

    public static boolean wasSetConfiguratorsCalled() {
        return ConfiguratorRegistry.getDefaultRegistry().wasSetConfiguratorsCalled();
    }

    public static int getConfiguratorsCallCountBeforeSet() {
        return ConfiguratorRegistry.getDefaultRegistry().getConfiguratorsCallCountBeforeSet();
    }
}

