/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.org.apache.arrow.vector.ipc.message;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sparkproject.com.google.flatbuffers.FlatBufferBuilder;
import org.sparkproject.org.apache.arrow.flatbuf.Block;
import org.sparkproject.org.apache.arrow.flatbuf.Footer;
import org.sparkproject.org.apache.arrow.flatbuf.KeyValue;
import org.sparkproject.org.apache.arrow.vector.ipc.message.ArrowBlock;
import org.sparkproject.org.apache.arrow.vector.ipc.message.FBSerializable;
import org.sparkproject.org.apache.arrow.vector.ipc.message.FBSerializables;
import org.sparkproject.org.apache.arrow.vector.types.MetadataVersion;
import org.sparkproject.org.apache.arrow.vector.types.pojo.Schema;

public class ArrowFooter
implements FBSerializable {
    private final Schema schema;
    private final List<ArrowBlock> dictionaries;
    private final List<ArrowBlock> recordBatches;
    private final Map<String, String> metaData;
    private final MetadataVersion metadataVersion;

    public ArrowFooter(Schema schema, List<ArrowBlock> dictionaries, List<ArrowBlock> recordBatches) {
        this(schema, dictionaries, recordBatches, null);
    }

    public ArrowFooter(Schema schema, List<ArrowBlock> dictionaries, List<ArrowBlock> recordBatches, Map<String, String> metaData) {
        this(schema, dictionaries, recordBatches, metaData, MetadataVersion.DEFAULT);
    }

    public ArrowFooter(Schema schema, List<ArrowBlock> dictionaries, List<ArrowBlock> recordBatches, Map<String, String> metaData, MetadataVersion metadataVersion) {
        this.schema = schema;
        this.dictionaries = dictionaries;
        this.recordBatches = recordBatches;
        this.metaData = metaData;
        this.metadataVersion = metadataVersion;
    }

    public ArrowFooter(Footer footer) {
        this(Schema.convertSchema(footer.schema()), ArrowFooter.dictionaries(footer), ArrowFooter.recordBatches(footer), ArrowFooter.metaData(footer), MetadataVersion.fromFlatbufID(footer.version()));
    }

    private static List<ArrowBlock> recordBatches(Footer footer) {
        ArrayList<ArrowBlock> recordBatches = new ArrayList<ArrowBlock>();
        Block tempBlock = new Block();
        int recordBatchesLength = footer.recordBatchesLength();
        for (int i = 0; i < recordBatchesLength; ++i) {
            Block block = footer.recordBatches(tempBlock, i);
            recordBatches.add(new ArrowBlock(block.offset(), block.metaDataLength(), block.bodyLength()));
        }
        return recordBatches;
    }

    private static List<ArrowBlock> dictionaries(Footer footer) {
        ArrayList<ArrowBlock> dictionaries = new ArrayList<ArrowBlock>();
        Block tempBlock = new Block();
        int dictionariesLength = footer.dictionariesLength();
        for (int i = 0; i < dictionariesLength; ++i) {
            Block block = footer.dictionaries(tempBlock, i);
            dictionaries.add(new ArrowBlock(block.offset(), block.metaDataLength(), block.bodyLength()));
        }
        return dictionaries;
    }

    private static Map<String, String> metaData(Footer footer) {
        HashMap<String, String> metaData = new HashMap<String, String>();
        int metaDataLength = footer.customMetadataLength();
        for (int i = 0; i < metaDataLength; ++i) {
            KeyValue kv = footer.customMetadata(i);
            metaData.put(kv.key(), kv.value());
        }
        return metaData;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public List<ArrowBlock> getDictionaries() {
        return this.dictionaries;
    }

    public List<ArrowBlock> getRecordBatches() {
        return this.recordBatches;
    }

    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public MetadataVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    @Override
    public int writeTo(FlatBufferBuilder builder) {
        int schemaIndex = this.schema.getSchema(builder);
        Footer.startDictionariesVector(builder, this.dictionaries.size());
        int dicsOffset = FBSerializables.writeAllStructsToVector(builder, this.dictionaries);
        Footer.startRecordBatchesVector(builder, this.recordBatches.size());
        int rbsOffset = FBSerializables.writeAllStructsToVector(builder, this.recordBatches);
        int metaDataOffset = 0;
        if (this.metaData != null) {
            metaDataOffset = FBSerializables.writeKeyValues(builder, this.metaData);
        }
        Footer.startFooter(builder);
        Footer.addSchema(builder, schemaIndex);
        Footer.addDictionaries(builder, dicsOffset);
        Footer.addRecordBatches(builder, rbsOffset);
        Footer.addCustomMetadata(builder, metaDataOffset);
        Footer.addVersion(builder, this.metadataVersion.toFlatbufID());
        return Footer.endFooter(builder);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dictionaries == null ? 0 : this.dictionaries.hashCode());
        result = 31 * result + (this.recordBatches == null ? 0 : this.recordBatches.hashCode());
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrowFooter other = (ArrowFooter)obj;
        if (this.dictionaries == null ? other.dictionaries != null : !this.dictionaries.equals(other.dictionaries)) {
            return false;
        }
        if (this.recordBatches == null ? other.recordBatches != null : !this.recordBatches.equals(other.recordBatches)) {
            return false;
        }
        return !(this.schema == null ? other.schema != null : !this.schema.equals(other.schema));
    }
}

