/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.reflect.Array;
import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfBooleansSerDe;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllItemsSketch;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;

final class KllDirectCompactItemsSketch<T>
extends KllItemsSketch<T> {
    private Memory mem;

    KllDirectCompactItemsSketch(KllMemoryValidate memVal, Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        super(memVal.sketchStructure, comparator, serDe);
        this.mem = memVal.srcMem;
        this.readOnly = true;
        this.levelsArr = memVal.levelsArr;
    }

    @Override
    String getItemAsString(int index) {
        if (this.isEmpty()) {
            return "Null";
        }
        return this.serDe.toString(this.getTotalItemsArray()[index]);
    }

    @Override
    public int getK() {
        return KllPreambleUtil.getMemoryK(this.mem);
    }

    @Override
    public T getMaxItem() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.serDe.deserializeFromMemory(this.mem, 8L, 1)[0];
        }
        int baseOffset = 20 + this.getNumLevels() * 4;
        int offset = baseOffset + this.serDe.sizeOf(this.mem, baseOffset, 1);
        return this.serDe.deserializeFromMemory(this.mem, offset, 1)[0];
    }

    @Override
    String getMaxItemAsString() {
        if (this.isEmpty()) {
            return "Null";
        }
        return this.serDe.toString(this.getMaxItem());
    }

    @Override
    public T getMinItem() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.serDe.deserializeFromMemory(this.mem, 8L, 1)[0];
        }
        int offset = 20 + this.getNumLevels() * 4;
        return this.serDe.deserializeFromMemory(this.mem, offset, 1)[0];
    }

    @Override
    String getMinItemAsString() {
        if (this.isEmpty()) {
            return "Null";
        }
        return this.serDe.toString(this.getMinItem());
    }

    @Override
    public long getN() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            return 0L;
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return 1L;
        }
        return KllPreambleUtil.getMemoryN(this.mem);
    }

    private int getCompactDataOffset() {
        return this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE ? 8 : 20 + this.getNumLevels() * 4 + this.getMinMaxSizeBytes();
    }

    @Override
    int getM() {
        return KllPreambleUtil.getMemoryM(this.mem);
    }

    @Override
    int getMinK() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return KllPreambleUtil.getMemoryK(this.mem);
        }
        return KllPreambleUtil.getMemoryMinK(this.mem);
    }

    @Override
    byte[] getMinMaxByteArr() {
        int offset = 20 + this.getNumLevels() * 4;
        int bytesMinMax = this.serDe.sizeOf(this.mem, offset, 2);
        byte[] byteArr = new byte[bytesMinMax];
        this.mem.getByteArray((long)offset, byteArr, 0, bytesMinMax);
        return byteArr;
    }

    @Override
    int getMinMaxSizeBytes() {
        int offset = 20 + this.getNumLevels() * 4;
        if (this.serDe instanceof ArrayOfBooleansSerDe) {
            return 2;
        }
        return this.serDe.sizeOf(this.mem, offset, 2);
    }

    @Override
    T[] getRetainedItemsArray() {
        int numRet = this.getNumRetained();
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.getN() == 0L) {
            return (Object[])Array.newInstance(this.serDe.getClassOfT(), numRet);
        }
        int offset = this.getCompactDataOffset();
        return this.serDe.deserializeFromMemory(this.mem, offset, numRet);
    }

    @Override
    byte[] getRetainedItemsByteArr() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.getN() == 0L) {
            return new byte[0];
        }
        int offset = this.getCompactDataOffset();
        int bytes = this.serDe.sizeOf(this.mem, offset, this.getNumRetained());
        byte[] byteArr = new byte[bytes];
        this.mem.getByteArray((long)offset, byteArr, 0, bytes);
        return byteArr;
    }

    @Override
    int getRetainedItemsSizeBytes() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.getN() == 0L) {
            return 0;
        }
        int offset = this.getCompactDataOffset();
        return this.serDe.sizeOf(this.mem, offset, this.getNumRetained());
    }

    @Override
    T getSingleItem() {
        if (this.getN() != 1L) {
            throw new SketchesArgumentException("Sketch does not have just one item. ");
        }
        int offset = this.getCompactDataOffset();
        return this.serDe.deserializeFromMemory(this.mem, offset, 1)[0];
    }

    @Override
    byte[] getSingleItemByteArr() {
        if (this.getN() != 1L) {
            throw new SketchesArgumentException("Sketch does not have just one item. ");
        }
        int offset = this.getCompactDataOffset();
        int bytes = this.serDe.sizeOf(this.mem, offset, 1);
        byte[] byteArr = new byte[bytes];
        this.mem.getByteArray((long)offset, byteArr, 0, bytes);
        return byteArr;
    }

    @Override
    int getSingleItemSizeBytes() {
        if (this.getN() != 1L) {
            throw new SketchesArgumentException("Sketch does not have just one item. ");
        }
        int offset = this.getCompactDataOffset();
        int bytes = this.serDe.sizeOf(this.mem, offset, 1);
        return bytes;
    }

    @Override
    T[] getTotalItemsArray() {
        int k = this.getK();
        if (this.getN() == 0L) {
            return (Object[])Array.newInstance(this.serDe.getClassOfT(), k);
        }
        if (this.getN() == 1L) {
            Object[] itemsArr = (Object[])Array.newInstance(this.serDe.getClassOfT(), k);
            itemsArr[k - 1] = this.getSingleItem();
            return itemsArr;
        }
        int offset = this.getCompactDataOffset();
        int numRetItems = this.getNumRetained();
        int numCapItems = this.levelsArr[this.getNumLevels()];
        T[] retItems = this.serDe.deserializeFromMemory(this.mem, offset, numRetItems);
        Object[] capItems = (Object[])Array.newInstance(this.serDe.getClassOfT(), numCapItems);
        System.arraycopy(retItems, 0, capItems, this.levelsArr[0], numRetItems);
        return capItems;
    }

    @Override
    WritableMemory getWritableMemory() {
        return (WritableMemory)this.mem;
    }

    @Override
    void incN(int increment) {
        throw new SketchesArgumentException("Unsupported operation for this Sketch Type. ");
    }

    @Override
    boolean isLevelZeroSorted() {
        return KllPreambleUtil.getMemoryLevelZeroSortedFlag(this.mem);
    }

    @Override
    void setItemsArray(Object[] ItemsArr) {
        throw new SketchesArgumentException("Unsupported operation for this Sketch Type. ");
    }

    @Override
    void setItemsArrayAt(int index, Object item) {
        throw new SketchesArgumentException("Unsupported operation for this Sketch Type. ");
    }

    @Override
    void setLevelZeroSorted(boolean sorted) {
        throw new SketchesArgumentException("Unsupported operation for this Sketch Type. ");
    }

    @Override
    void setMaxItem(Object item) {
        throw new SketchesArgumentException("Unsupported operation for this Sketch Type. ");
    }

    @Override
    void setMinItem(Object item) {
        throw new SketchesArgumentException("Unsupported operation for this Sketch Type. ");
    }

    @Override
    void setMinK(int minK) {
        throw new SketchesArgumentException("Unsupported operation for this Sketch Type. ");
    }

    @Override
    void setN(long n) {
        throw new SketchesArgumentException("Unsupported operation for this Sketch Type. ");
    }
}

