/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;
import org.apache.spark.network.protocol.ChunkFetchFailure;
import org.apache.spark.network.protocol.ChunkFetchRequest;
import org.apache.spark.network.protocol.ChunkFetchSuccess;
import org.apache.spark.network.protocol.MergedBlockMetaRequest;
import org.apache.spark.network.protocol.MergedBlockMetaSuccess;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.OneWayMessage;
import org.apache.spark.network.protocol.RpcFailure;
import org.apache.spark.network.protocol.RpcRequest;
import org.apache.spark.network.protocol.RpcResponse;
import org.apache.spark.network.protocol.StreamFailure;
import org.apache.spark.network.protocol.StreamRequest;
import org.apache.spark.network.protocol.StreamResponse;
import org.apache.spark.network.protocol.UploadStream;

@ChannelHandler.Sharable
public final class MessageDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private static final SparkLogger logger = SparkLoggerFactory.getLogger(MessageDecoder.class);
    public static final MessageDecoder INSTANCE = new MessageDecoder();

    private MessageDecoder() {
    }

    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        Message.Type msgType = Message.Type.decode(in);
        Message decoded = this.decode(msgType, in);
        assert (decoded.type() == msgType);
        logger.trace("Received message {}: {}", (Object)msgType, (Object)decoded);
        out.add(decoded);
    }

    private Message decode(Message.Type msgType, ByteBuf in) {
        return switch (msgType) {
            case Message.Type.ChunkFetchRequest -> ChunkFetchRequest.decode(in);
            case Message.Type.ChunkFetchSuccess -> ChunkFetchSuccess.decode(in);
            case Message.Type.ChunkFetchFailure -> ChunkFetchFailure.decode(in);
            case Message.Type.RpcRequest -> RpcRequest.decode(in);
            case Message.Type.RpcResponse -> RpcResponse.decode(in);
            case Message.Type.RpcFailure -> RpcFailure.decode(in);
            case Message.Type.OneWayMessage -> OneWayMessage.decode(in);
            case Message.Type.StreamRequest -> StreamRequest.decode(in);
            case Message.Type.StreamResponse -> StreamResponse.decode(in);
            case Message.Type.StreamFailure -> StreamFailure.decode(in);
            case Message.Type.UploadStream -> UploadStream.decode(in);
            case Message.Type.MergedBlockMetaRequest -> MergedBlockMetaRequest.decode(in);
            case Message.Type.MergedBlockMetaSuccess -> MergedBlockMetaSuccess.decode(in);
            default -> throw new IllegalArgumentException("Unexpected message type: " + String.valueOf(msgType));
        };
    }
}

