/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NormalizableKey;

@Internal
public class LongValueComparator
extends TypeComparator<LongValue> {
    private static final long serialVersionUID = 1L;
    private final boolean ascendingComparison;
    private final LongValue reference = new LongValue();
    private final LongValue tempReference = new LongValue();
    private final TypeComparator<?>[] comparators = new TypeComparator[]{this};

    public LongValueComparator(boolean ascending) {
        this.ascendingComparison = ascending;
    }

    @Override
    public int hash(LongValue record) {
        return record.hashCode();
    }

    @Override
    public void setReference(LongValue toCompare) {
        toCompare.copyTo(this.reference);
    }

    @Override
    public boolean equalToReference(LongValue candidate) {
        return candidate.equals(this.reference);
    }

    @Override
    public int compareToReference(TypeComparator<LongValue> referencedComparator) {
        LongValue otherRef = ((LongValueComparator)referencedComparator).reference;
        int comp = otherRef.compareTo(this.reference);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public int compare(LongValue first, LongValue second) {
        int comp = first.compareTo(second);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        this.reference.read(firstSource);
        this.tempReference.read(secondSource);
        int comp = this.reference.compareTo(this.tempReference);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return NormalizableKey.class.isAssignableFrom(LongValue.class);
    }

    @Override
    public int getNormalizeKeyLen() {
        return this.reference.getMaxNormalizedKeyLen();
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < this.getNormalizeKeyLen();
    }

    @Override
    public void putNormalizedKey(LongValue record, MemorySegment target, int offset, int numBytes) {
        record.copyNormalizedKey(target, offset, numBytes);
    }

    @Override
    public boolean invertNormalizedKey() {
        return !this.ascendingComparison;
    }

    @Override
    public TypeComparator<LongValue> duplicate() {
        return new LongValueComparator(this.ascendingComparison);
    }

    @Override
    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    @Override
    public TypeComparator<?>[] getFlatComparators() {
        return this.comparators;
    }

    @Override
    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    @Override
    public void writeWithKeyNormalization(LongValue record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public LongValue readWithKeyDenormalization(LongValue reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }
}

