/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.java.typeutils.TypeExtractionException;

@Internal
public class TypeExtractionUtils {
    private TypeExtractionUtils() {
    }

    public static LambdaExecutable checkAndExtractLambda(Function function) throws TypeExtractionException {
        try {
            SerializedLambda serializedLambda = null;
            for (Class<?> clazz = function.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    Method replaceMethod = clazz.getDeclaredMethod("writeReplace", new Class[0]);
                    replaceMethod.setAccessible(true);
                    Object serialVersion = replaceMethod.invoke((Object)function, new Object[0]);
                    if (serialVersion == null || serialVersion.getClass() != SerializedLambda.class) continue;
                    serializedLambda = (SerializedLambda)serialVersion;
                    break;
                }
                catch (NoSuchMethodException replaceMethod) {
                    // empty catch block
                }
            }
            if (serializedLambda == null) {
                return null;
            }
            String className = serializedLambda.getImplClass();
            String methodName = serializedLambda.getImplMethodName();
            String methodSig = serializedLambda.getImplMethodSignature();
            Class<?> implClass = Class.forName(className.replace('/', '.'), true, Thread.currentThread().getContextClassLoader());
            if (methodName.equals("<init>")) {
                Constructor<?>[] constructors;
                for (Constructor<?> constructor : constructors = implClass.getDeclaredConstructors()) {
                    if (!org.apache.flink.shaded.asm7.org.objectweb.asm.Type.getConstructorDescriptor(constructor).equals(methodSig)) continue;
                    return new LambdaExecutable(constructor);
                }
            } else {
                List<Method> methods = TypeExtractionUtils.getAllDeclaredMethods(implClass);
                for (Method method : methods) {
                    if (!method.getName().equals(methodName) || !org.apache.flink.shaded.asm7.org.objectweb.asm.Type.getMethodDescriptor((Method)method).equals(methodSig)) continue;
                    return new LambdaExecutable(method);
                }
            }
            throw new TypeExtractionException("No lambda method found.");
        }
        catch (Exception e) {
            throw new TypeExtractionException("Could not extract lambda method out of function: " + e.getClass().getSimpleName() + " - " + e.getMessage(), e);
        }
    }

    public static Type extractTypeFromLambda(Class<?> baseClass, LambdaExecutable exec, int[] lambdaTypeArgumentIndices, int paramLen, int baseParametersLen) {
        Type output = exec.getParameterTypes()[paramLen - baseParametersLen + lambdaTypeArgumentIndices[0]];
        for (int i = 1; i < lambdaTypeArgumentIndices.length; ++i) {
            TypeExtractionUtils.validateLambdaType(baseClass, output);
            output = TypeExtractionUtils.extractTypeArgument(output, lambdaTypeArgumentIndices[i]);
        }
        TypeExtractionUtils.validateLambdaType(baseClass, output);
        return output;
    }

    public static Type extractTypeArgument(Type t, int index) throws InvalidTypesException {
        if (t instanceof ParameterizedType) {
            Type[] actualTypeArguments = ((ParameterizedType)t).getActualTypeArguments();
            if (index < 0 || index >= actualTypeArguments.length) {
                throw new InvalidTypesException("Cannot extract the type argument with index " + index + " because the type has only " + actualTypeArguments.length + " type arguments.");
            }
            return actualTypeArguments[index];
        }
        throw new InvalidTypesException("The given type " + t + " is not a parameterized type.");
    }

    public static Method getSingleAbstractMethod(Class<?> baseClass) {
        if (!baseClass.isInterface()) {
            throw new InvalidTypesException("Given class: " + baseClass + "is not a FunctionalInterface.");
        }
        Method sam = null;
        for (Method method : baseClass.getMethods()) {
            if (!Modifier.isAbstract(method.getModifiers())) continue;
            if (sam == null) {
                sam = method;
                continue;
            }
            throw new InvalidTypesException("Given class: " + baseClass + " is not a FunctionalInterface. It has more than one abstract method.");
        }
        if (sam == null) {
            throw new InvalidTypesException("Given class: " + baseClass + " is not a FunctionalInterface. It does not have any abstract methods.");
        }
        return sam;
    }

    public static List<Method> getAllDeclaredMethods(Class<?> clazz) {
        ArrayList<Method> result = new ArrayList<Method>();
        while (clazz != null) {
            Method[] methods = clazz.getDeclaredMethods();
            Collections.addAll(result, methods);
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public static <T> Class<T> typeToClass(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getRawType();
        }
        throw new IllegalArgumentException("Cannot convert type to class");
    }

    public static boolean isClassType(Type t) {
        return t instanceof Class || t instanceof ParameterizedType;
    }

    public static boolean sameTypeVars(Type t1, Type t2) {
        return t1 instanceof TypeVariable && t2 instanceof TypeVariable && ((TypeVariable)t1).getName().equals(((TypeVariable)t2).getName()) && ((TypeVariable)t1).getGenericDeclaration().equals(((TypeVariable)t2).getGenericDeclaration());
    }

    public static Type getTypeHierarchy(List<Type> typeHierarchy, Type t, Class<?> stopAtClass) {
        while (!TypeExtractionUtils.isClassType(t) || !TypeExtractionUtils.typeToClass(t).equals(stopAtClass)) {
            typeHierarchy.add(t);
            if ((t = TypeExtractionUtils.typeToClass(t).getGenericSuperclass()) != null) continue;
            break;
        }
        return t;
    }

    public static boolean hasSuperclass(Class<?> clazz, String superClassName) {
        ArrayList<Type> hierarchy = new ArrayList<Type>();
        TypeExtractionUtils.getTypeHierarchy(hierarchy, clazz, Object.class);
        for (Type t : hierarchy) {
            if (!TypeExtractionUtils.isClassType(t) || !TypeExtractionUtils.typeToClass(t).getName().equals(superClassName)) continue;
            return true;
        }
        return false;
    }

    public static Class<?> getRawClass(Type t) {
        if (TypeExtractionUtils.isClassType(t)) {
            return TypeExtractionUtils.typeToClass(t);
        }
        if (t instanceof GenericArrayType) {
            Type component = ((GenericArrayType)t).getGenericComponentType();
            return Array.newInstance(TypeExtractionUtils.getRawClass(component), 0).getClass();
        }
        return Object.class;
    }

    public static void validateLambdaType(Class<?> baseClass, Type t) {
        if (!(t instanceof Class)) {
            return;
        }
        Class clazz = (Class)t;
        if (clazz.getTypeParameters().length > 0) {
            throw new InvalidTypesException("The generic type parameters of '" + clazz.getSimpleName() + "' are missing. In many cases lambda methods don't provide enough information for automatic type extraction when Java generics are involved. An easy workaround is to use an (anonymous) class instead that implements the '" + baseClass.getName() + "' interface. Otherwise the type has to be specified explicitly using type information.");
        }
    }

    public static class LambdaExecutable {
        private Type[] parameterTypes;
        private Type returnType;
        private String name;
        private Object executable;

        public LambdaExecutable(Constructor<?> constructor) {
            this.parameterTypes = constructor.getGenericParameterTypes();
            this.returnType = constructor.getDeclaringClass();
            this.name = constructor.getName();
            this.executable = constructor;
        }

        public LambdaExecutable(Method method) {
            this.parameterTypes = method.getGenericParameterTypes();
            this.returnType = method.getGenericReturnType();
            this.name = method.getName();
            this.executable = method;
        }

        public Type[] getParameterTypes() {
            return this.parameterTypes;
        }

        public Type getReturnType() {
            return this.returnType;
        }

        public String getName() {
            return this.name;
        }

        public boolean executablesEquals(Method m) {
            return this.executable.equals(m);
        }

        public boolean executablesEquals(Constructor<?> c) {
            return this.executable.equals(c);
        }
    }
}

