/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.metrics.flink;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.streampark.console.core.enums.CheckPointStatus;
import org.apache.streampark.console.core.enums.CheckPointType;

public class CheckPoints
implements Serializable {
    private List<CheckPoint> history;
    private Latest latest;

    @JsonIgnore
    public List<CheckPoint> getLatestCheckpoint() {
        if (Objects.isNull(this.latest)) {
            return Collections.emptyList();
        }
        return this.latest.getLatestCheckpoint();
    }

    public List<CheckPoint> getHistory() {
        return this.history;
    }

    public Latest getLatest() {
        return this.latest;
    }

    public void setHistory(List<CheckPoint> history) {
        this.history = history;
    }

    public void setLatest(Latest latest) {
        this.latest = latest;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckPoints)) {
            return false;
        }
        CheckPoints other = (CheckPoints)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<CheckPoint> this$history = this.getHistory();
        List<CheckPoint> other$history = other.getHistory();
        if (this$history == null ? other$history != null : !((Object)this$history).equals(other$history)) {
            return false;
        }
        Latest this$latest = this.getLatest();
        Latest other$latest = other.getLatest();
        return !(this$latest == null ? other$latest != null : !((Object)this$latest).equals(other$latest));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CheckPoints;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<CheckPoint> $history = this.getHistory();
        result = result * 59 + ($history == null ? 43 : ((Object)$history).hashCode());
        Latest $latest = this.getLatest();
        result = result * 59 + ($latest == null ? 43 : ((Object)$latest).hashCode());
        return result;
    }

    public String toString() {
        return "CheckPoints(history=" + this.getHistory() + ", latest=" + this.getLatest() + ")";
    }

    public static class Latest
    implements Serializable {
        private CheckPoint completed;
        private CheckPoint savepoint;

        @JsonIgnore
        public List<CheckPoint> getLatestCheckpoint() {
            ArrayList<CheckPoint> checkPoints = new ArrayList<CheckPoint>();
            if (Objects.nonNull(this.completed)) {
                checkPoints.add(this.completed);
            }
            if (Objects.nonNull(this.savepoint)) {
                checkPoints.add(this.savepoint);
            }
            return checkPoints;
        }

        public CheckPoint getCompleted() {
            return this.completed;
        }

        public CheckPoint getSavepoint() {
            return this.savepoint;
        }

        public void setCompleted(CheckPoint completed) {
            this.completed = completed;
        }

        public void setSavepoint(CheckPoint savepoint) {
            this.savepoint = savepoint;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Latest)) {
                return false;
            }
            Latest other = (Latest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CheckPoint this$completed = this.getCompleted();
            CheckPoint other$completed = other.getCompleted();
            if (this$completed == null ? other$completed != null : !((Object)this$completed).equals(other$completed)) {
                return false;
            }
            CheckPoint this$savepoint = this.getSavepoint();
            CheckPoint other$savepoint = other.getSavepoint();
            return !(this$savepoint == null ? other$savepoint != null : !((Object)this$savepoint).equals(other$savepoint));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Latest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CheckPoint $completed = this.getCompleted();
            result = result * 59 + ($completed == null ? 43 : ((Object)$completed).hashCode());
            CheckPoint $savepoint = this.getSavepoint();
            result = result * 59 + ($savepoint == null ? 43 : ((Object)$savepoint).hashCode());
            return result;
        }

        public String toString() {
            return "CheckPoints.Latest(completed=" + this.getCompleted() + ", savepoint=" + this.getSavepoint() + ")";
        }
    }

    public static class CheckPoint
    implements Serializable {
        private Long id;
        private String status;
        @JsonProperty(value="external_path")
        private String externalPath;
        @JsonProperty(value="is_savepoint")
        private Boolean isSavepoint;
        @JsonProperty(value="latest_ack_timestamp")
        private Long latestAckTimestamp;
        @JsonProperty(value="checkpoint_type")
        private String checkpointType;
        @JsonProperty(value="trigger_timestamp")
        private Long triggerTimestamp;
        @JsonProperty(value="state_size")
        private Long stateSize;
        @JsonProperty(value="end_to_end_duration")
        private Long endToEndDuration;
        private Boolean discarded;

        public CheckPointStatus getCheckPointStatus() {
            return CheckPointStatus.valueOf(this.status);
        }

        public CheckPointType getCheckPointType() {
            if ("CHECKPOINT".equals(this.checkpointType)) {
                return CheckPointType.CHECKPOINT;
            }
            if ("SAVEPOINT".equals(this.checkpointType)) {
                return CheckPointType.SAVEPOINT;
            }
            return CheckPointType.SYNC_SAVEPOINT;
        }

        public String getPath() {
            return this.getExternalPath().replaceFirst("^hdfs:/[^/]", "hdfs:///");
        }

        public Long getId() {
            return this.id;
        }

        public String getStatus() {
            return this.status;
        }

        public String getExternalPath() {
            return this.externalPath;
        }

        public Boolean getIsSavepoint() {
            return this.isSavepoint;
        }

        public Long getLatestAckTimestamp() {
            return this.latestAckTimestamp;
        }

        public Long getTriggerTimestamp() {
            return this.triggerTimestamp;
        }

        public Long getStateSize() {
            return this.stateSize;
        }

        public Long getEndToEndDuration() {
            return this.endToEndDuration;
        }

        public Boolean getDiscarded() {
            return this.discarded;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="external_path")
        public void setExternalPath(String externalPath) {
            this.externalPath = externalPath;
        }

        @JsonProperty(value="is_savepoint")
        public void setIsSavepoint(Boolean isSavepoint) {
            this.isSavepoint = isSavepoint;
        }

        @JsonProperty(value="latest_ack_timestamp")
        public void setLatestAckTimestamp(Long latestAckTimestamp) {
            this.latestAckTimestamp = latestAckTimestamp;
        }

        @JsonProperty(value="checkpoint_type")
        public void setCheckpointType(String checkpointType) {
            this.checkpointType = checkpointType;
        }

        @JsonProperty(value="trigger_timestamp")
        public void setTriggerTimestamp(Long triggerTimestamp) {
            this.triggerTimestamp = triggerTimestamp;
        }

        @JsonProperty(value="state_size")
        public void setStateSize(Long stateSize) {
            this.stateSize = stateSize;
        }

        @JsonProperty(value="end_to_end_duration")
        public void setEndToEndDuration(Long endToEndDuration) {
            this.endToEndDuration = endToEndDuration;
        }

        public void setDiscarded(Boolean discarded) {
            this.discarded = discarded;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CheckPoint)) {
                return false;
            }
            CheckPoint other = (CheckPoint)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$id = this.getId();
            Long other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Boolean this$isSavepoint = this.getIsSavepoint();
            Boolean other$isSavepoint = other.getIsSavepoint();
            if (this$isSavepoint == null ? other$isSavepoint != null : !((Object)this$isSavepoint).equals(other$isSavepoint)) {
                return false;
            }
            Long this$latestAckTimestamp = this.getLatestAckTimestamp();
            Long other$latestAckTimestamp = other.getLatestAckTimestamp();
            if (this$latestAckTimestamp == null ? other$latestAckTimestamp != null : !((Object)this$latestAckTimestamp).equals(other$latestAckTimestamp)) {
                return false;
            }
            Long this$triggerTimestamp = this.getTriggerTimestamp();
            Long other$triggerTimestamp = other.getTriggerTimestamp();
            if (this$triggerTimestamp == null ? other$triggerTimestamp != null : !((Object)this$triggerTimestamp).equals(other$triggerTimestamp)) {
                return false;
            }
            Long this$stateSize = this.getStateSize();
            Long other$stateSize = other.getStateSize();
            if (this$stateSize == null ? other$stateSize != null : !((Object)this$stateSize).equals(other$stateSize)) {
                return false;
            }
            Long this$endToEndDuration = this.getEndToEndDuration();
            Long other$endToEndDuration = other.getEndToEndDuration();
            if (this$endToEndDuration == null ? other$endToEndDuration != null : !((Object)this$endToEndDuration).equals(other$endToEndDuration)) {
                return false;
            }
            Boolean this$discarded = this.getDiscarded();
            Boolean other$discarded = other.getDiscarded();
            if (this$discarded == null ? other$discarded != null : !((Object)this$discarded).equals(other$discarded)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$externalPath = this.getExternalPath();
            String other$externalPath = other.getExternalPath();
            if (this$externalPath == null ? other$externalPath != null : !this$externalPath.equals(other$externalPath)) {
                return false;
            }
            CheckPointType this$checkpointType = this.getCheckPointType();
            CheckPointType other$checkpointType = other.getCheckPointType();
            return !(this$checkpointType == null ? other$checkpointType != null : !this$checkpointType.equals(other$checkpointType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CheckPoint;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Boolean $isSavepoint = this.getIsSavepoint();
            result = result * 59 + ($isSavepoint == null ? 43 : ((Object)$isSavepoint).hashCode());
            Long $latestAckTimestamp = this.getLatestAckTimestamp();
            result = result * 59 + ($latestAckTimestamp == null ? 43 : ((Object)$latestAckTimestamp).hashCode());
            Long $triggerTimestamp = this.getTriggerTimestamp();
            result = result * 59 + ($triggerTimestamp == null ? 43 : ((Object)$triggerTimestamp).hashCode());
            Long $stateSize = this.getStateSize();
            result = result * 59 + ($stateSize == null ? 43 : ((Object)$stateSize).hashCode());
            Long $endToEndDuration = this.getEndToEndDuration();
            result = result * 59 + ($endToEndDuration == null ? 43 : ((Object)$endToEndDuration).hashCode());
            Boolean $discarded = this.getDiscarded();
            result = result * 59 + ($discarded == null ? 43 : ((Object)$discarded).hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $externalPath = this.getExternalPath();
            result = result * 59 + ($externalPath == null ? 43 : $externalPath.hashCode());
            CheckPointType $checkpointType = this.getCheckPointType();
            result = result * 59 + ($checkpointType == null ? 43 : $checkpointType.hashCode());
            return result;
        }

        public String toString() {
            return "CheckPoints.CheckPoint(id=" + this.getId() + ", status=" + this.getStatus() + ", externalPath=" + this.getExternalPath() + ", isSavepoint=" + this.getIsSavepoint() + ", latestAckTimestamp=" + this.getLatestAckTimestamp() + ", checkpointType=" + this.getCheckPointType() + ", triggerTimestamp=" + this.getTriggerTimestamp() + ", stateSize=" + this.getStateSize() + ", endToEndDuration=" + this.getEndToEndDuration() + ", discarded=" + this.getDiscarded() + ")";
        }
    }
}

