/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.client.trait;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.CustomCommandLine;
import org.apache.flink.client.cli.ExecutionConfigAccessor;
import org.apache.flink.client.cli.ProgramOptions;
import org.apache.flink.client.deployment.application.ApplicationConfiguration;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.PipelineOptionsInternal;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.SavepointConfigOptions;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.streampark.common.conf.ConfigConst$;
import org.apache.streampark.common.conf.Workspace$;
import org.apache.streampark.common.enums.ApplicationType;
import org.apache.streampark.common.enums.DevelopmentMode;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.util.DeflaterUtils$;
import org.apache.streampark.common.util.PropertiesUtils$;
import org.apache.streampark.common.util.Utils$;
import org.apache.streampark.flink.client.bean.CancelRequest;
import org.apache.streampark.flink.client.bean.CancelResponse;
import org.apache.streampark.flink.client.bean.SavepointRequestTrait;
import org.apache.streampark.flink.client.bean.SavepointResponse;
import org.apache.streampark.flink.client.bean.SubmitRequest;
import org.apache.streampark.flink.client.bean.SubmitResponse;
import org.apache.streampark.flink.client.bean.TriggerSavepointRequest;
import org.apache.streampark.flink.client.trait.FlinkClientTrait;
import org.apache.streampark.flink.core.FlinkClusterClient;
import org.apache.streampark.flink.core.conf.FlinkRunOption$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public abstract class FlinkClientTrait$class {
    public static String PARAM_KEY_FLINK_CONF(FlinkClientTrait $this) {
        return ConfigConst$.MODULE$.KEY_FLINK_CONF("--");
    }

    public static String PARAM_KEY_FLINK_SQL(FlinkClientTrait $this) {
        return ConfigConst$.MODULE$.KEY_FLINK_SQL("--");
    }

    public static String PARAM_KEY_APP_CONF(FlinkClientTrait $this) {
        return ConfigConst$.MODULE$.KEY_APP_CONF("--");
    }

    public static String PARAM_KEY_APP_NAME(FlinkClientTrait $this) {
        return ConfigConst$.MODULE$.KEY_APP_NAME("--");
    }

    public static String PARAM_KEY_FLINK_PARALLELISM(FlinkClientTrait $this) {
        return ConfigConst$.MODULE$.KEY_FLINK_PARALLELISM("--");
    }

    public static SubmitResponse submit(FlinkClientTrait $this, SubmitRequest submitRequest) throws Exception {
        $this.logInfo((Function0)new Serializable($this, submitRequest){
            public static final long serialVersionUID = 0L;
            private final SubmitRequest submitRequest$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |--------------------------------------- flink job start ---------------------------------------\n         |    userFlinkHome    : ", "\n         |    flinkVersion     : ", "\n         |    appName          : ", "\n         |    devMode          : ", "\n         |    execMode         : ", "\n         |    k8sNamespace     : ", "\n         |    flinkExposedType : ", "\n         |    clusterId        : ", "\n         |    applicationType  : ", "\n         |    savePoint        : ", "\n         |    properties       : ", "\n         |    args             : ", "\n         |    appConf          : ", "\n         |    flinkBuildResult : ", "\n         |-------------------------------------------------------------------------------------------\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.submitRequest$2.flinkVersion().flinkHome(), this.submitRequest$2.flinkVersion().version(), this.submitRequest$2.appName(), this.submitRequest$2.developmentMode().name(), this.submitRequest$2.executionMode().name(), this.submitRequest$2.k8sSubmitParam().kubernetesNamespace(), this.submitRequest$2.k8sSubmitParam().flinkRestExposedType(), this.submitRequest$2.k8sSubmitParam().clusterId(), this.submitRequest$2.applicationType().getName(), this.submitRequest$2.savePoint(), JavaConversions$.MODULE$.mapAsScalaMap(this.submitRequest$2.properties()).mkString(" "), this.submitRequest$2.args(), this.submitRequest$2.appConf(), this.submitRequest$2.buildResult()})))).stripMargin();
            }
            {
                this.submitRequest$2 = submitRequest$2;
            }
        });
        Tuple2 tuple2 = FlinkClientTrait$class.org$apache$streampark$flink$client$trait$FlinkClientTrait$$getCommandLineAndFlinkConfig($this, submitRequest);
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            Tuple2 tuple22;
            CommandLine commandLine = (CommandLine)tuple2._1();
            Configuration flinkConfig = (Configuration)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)commandLine, (Object)flinkConfig);
            CommandLine commandLine2 = (CommandLine)tuple23._1();
            Configuration flinkConfig2 = (Configuration)tuple23._2();
            if (submitRequest.userJarFile() == null) {
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                URI uri = PackagedProgramUtils.resolveURI((String)submitRequest.userJarFile().getAbsolutePath());
                ProgramOptions programOptions = ProgramOptions.create((CommandLine)commandLine2);
                ExecutionConfigAccessor executionParameters = ExecutionConfigAccessor.fromProgramOptions((ProgramOptions)programOptions, Collections.singletonList(uri.toString()));
                boxedUnit2 = executionParameters.applyToConfiguration(flinkConfig2);
            }
            $this.EnhanceFlinkConfiguration($this.EnhanceFlinkConfiguration($this.EnhanceFlinkConfiguration($this.EnhanceFlinkConfiguration($this.EnhanceFlinkConfiguration($this.EnhanceFlinkConfiguration(flinkConfig2).safeSet(PipelineOptions.NAME, submitRequest.effectiveAppName())).safeSet(DeploymentOptions.TARGET, submitRequest.executionMode().getName())).safeSet(SavepointConfigOptions.SAVEPOINT_PATH, submitRequest.savePoint())).safeSet(ApplicationConfiguration.APPLICATION_MAIN_CLASS, submitRequest.appMain())).safeSet(ApplicationConfiguration.APPLICATION_ARGS, FlinkClientTrait$class.org$apache$streampark$flink$client$trait$FlinkClientTrait$$extractProgramArgs($this, submitRequest))).safeSet(PipelineOptionsInternal.PIPELINE_FIXED_JOB_ID, submitRequest.jobId());
            if (submitRequest.properties().containsKey(CheckpointingOptions.MAX_RETAINED_CHECKPOINTS.key())) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Configuration flinkDefaultConfiguration = $this.getFlinkDefaultConfiguration(submitRequest.flinkVersion().flinkHome());
                ConfigOption retainedOption = CheckpointingOptions.MAX_RETAINED_CHECKPOINTS;
                boxedUnit = $this.EnhanceFlinkConfiguration(flinkConfig2).safeSet(retainedOption, flinkDefaultConfiguration.get(retainedOption));
            }
            if (submitRequest.savePoint() != null) {
                $this.EnhanceFlinkConfiguration(flinkConfig2).safeSet(SavepointConfigOptions.SAVEPOINT_PATH, submitRequest.savePoint());
                flinkConfig2.setBoolean(SavepointConfigOptions.SAVEPOINT_IGNORE_UNCLAIMED_STATE, submitRequest.allowNonRestoredState());
            }
            FlinkClientTrait$class.org$apache$streampark$flink$client$trait$FlinkClientTrait$$setJvmOptions($this, submitRequest, flinkConfig2);
            $this.setConfig(submitRequest, flinkConfig2);
            return $this.doSubmit(submitRequest, flinkConfig2);
        }
        throw new MatchError((Object)tuple2);
    }

    public static void org$apache$streampark$flink$client$trait$FlinkClientTrait$$setJvmOptions(FlinkClientTrait $this, SubmitRequest submitRequest, Configuration flinkConfig) {
        if (MapUtils.isNotEmpty((Map)submitRequest.properties())) {
            JavaConversions$.MODULE$.mapAsScalaMap(submitRequest.properties()).foreach((Function1)new Serializable($this, flinkConfig){
                public static final long serialVersionUID = 0L;
                private final Configuration flinkConfig$1;

                public final Object apply(Tuple2<String, Object> x) {
                    Object object;
                    String k = ((String)x._1()).trim();
                    String v = x._2().toString();
                    String string = k;
                    String string2 = CoreOptions.FLINK_JVM_OPTIONS.key();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        object = this.flinkConfig$1.set(CoreOptions.FLINK_JVM_OPTIONS, (Object)v);
                    } else {
                        String string3 = k;
                        String string4 = CoreOptions.FLINK_JM_JVM_OPTIONS.key();
                        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                            object = this.flinkConfig$1.set(CoreOptions.FLINK_JM_JVM_OPTIONS, (Object)v);
                        } else {
                            String string5 = k;
                            String string6 = CoreOptions.FLINK_HS_JVM_OPTIONS.key();
                            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                                object = this.flinkConfig$1.set(CoreOptions.FLINK_HS_JVM_OPTIONS, (Object)v);
                            } else {
                                String string7 = k;
                                String string8 = CoreOptions.FLINK_TM_JVM_OPTIONS.key();
                                if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                                    object = this.flinkConfig$1.set(CoreOptions.FLINK_TM_JVM_OPTIONS, (Object)v);
                                } else {
                                    String string9 = k;
                                    String string10 = CoreOptions.FLINK_CLI_JVM_OPTIONS.key();
                                    object = !(string9 != null ? !string9.equals(string10) : string10 != null) ? this.flinkConfig$1.set(CoreOptions.FLINK_CLI_JVM_OPTIONS, (Object)v) : BoxedUnit.UNIT;
                                }
                            }
                        }
                    }
                    return object;
                }
                {
                    this.flinkConfig$1 = flinkConfig$1;
                }
            });
        }
    }

    public static SavepointResponse triggerSavepoint(FlinkClientTrait $this, TriggerSavepointRequest savepointRequest) throws Exception {
        $this.logInfo((Function0)new Serializable($this, savepointRequest){
            public static final long serialVersionUID = 0L;
            private final TriggerSavepointRequest savepointRequest$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |----------------------------------------- flink job trigger savepoint ---------------------\n         |     userFlinkHome  : ", "\n         |     flinkVersion   : ", "\n         |     clusterId      : ", "\n         |     savePointPath  : ", "\n         |     k8sNamespace   : ", "\n         |     appId          : ", "\n         |     jobId          : ", "\n         |-------------------------------------------------------------------------------------------\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.savepointRequest$1.flinkVersion().flinkHome(), this.savepointRequest$1.flinkVersion().version(), this.savepointRequest$1.clusterId(), this.savepointRequest$1.savepointPath(), this.savepointRequest$1.kubernetesNamespace(), this.savepointRequest$1.clusterId(), this.savepointRequest$1.jobId()})))).stripMargin();
            }
            {
                this.savepointRequest$1 = savepointRequest$1;
            }
        });
        Configuration flinkConf = new Configuration();
        return $this.doTriggerSavepoint(savepointRequest, flinkConf);
    }

    public static CancelResponse cancel(FlinkClientTrait $this, CancelRequest cancelRequest) throws Exception {
        $this.logInfo((Function0)new Serializable($this, cancelRequest){
            public static final long serialVersionUID = 0L;
            private final CancelRequest cancelRequest$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |----------------------------------------- flink job cancel --------------------------------\n         |     userFlinkHome     : ", "\n         |     flinkVersion      : ", "\n         |     clusterId         : ", "\n         |     withSavePoint     : ", "\n         |     savePointPath     : ", "\n         |     withDrain         : ", "\n         |     k8sNamespace      : ", "\n         |     appId             : ", "\n         |     jobId             : ", "\n         |-------------------------------------------------------------------------------------------\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cancelRequest$1.flinkVersion().flinkHome(), this.cancelRequest$1.flinkVersion().version(), this.cancelRequest$1.clusterId(), BoxesRunTime.boxToBoolean((boolean)this.cancelRequest$1.withSavepoint()), this.cancelRequest$1.savepointPath(), BoxesRunTime.boxToBoolean((boolean)this.cancelRequest$1.withDrain()), this.cancelRequest$1.kubernetesNamespace(), this.cancelRequest$1.clusterId(), this.cancelRequest$1.jobId()})))).stripMargin();
            }
            {
                this.cancelRequest$1 = cancelRequest$1;
            }
        });
        Configuration flinkConf = new Configuration();
        return $this.doCancel(cancelRequest, flinkConf);
    }

    public static SubmitResponse trySubmit(FlinkClientTrait $this, SubmitRequest submitRequest, Configuration flinkConfig, File jarFile, Function3 jobGraphFunc, Function3 restApiFunc) {
        Try try_;
        block7: {
            SubmitResponse submitResponse;
            block6: {
                SubmitResponse v;
                block4: {
                    Try try_2;
                    Throwable e;
                    block5: {
                        SubmitResponse r;
                        SubmitResponse submitResponse2;
                        try_ = Try$.MODULE$.apply((Function0)new Serializable($this, submitRequest, flinkConfig, jarFile, jobGraphFunc){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ FlinkClientTrait $outer;
                            private final SubmitRequest submitRequest$3;
                            private final Configuration flinkConfig$2;
                            private final File jarFile$1;
                            private final Function3 jobGraphFunc$1;

                            public final SubmitResponse apply() {
                                this.$outer.logInfo((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[flink-submit] Submit job with JobGraph Plan."})).s((Seq)Nil$.MODULE$);
                                    }
                                });
                                return (SubmitResponse)this.jobGraphFunc$1.apply((Object)this.submitRequest$3, (Object)this.flinkConfig$2, (Object)this.jarFile$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.submitRequest$3 = submitRequest$3;
                                this.flinkConfig$2 = flinkConfig$2;
                                this.jarFile$1 = jarFile$1;
                                this.jobGraphFunc$1 = jobGraphFunc$1;
                            }
                        });
                        if (!(try_ instanceof Failure)) break block4;
                        Failure failure2 = (Failure)try_;
                        e = failure2.exception();
                        try_2 = Try$.MODULE$.apply((Function0)new Serializable($this, submitRequest, flinkConfig, jarFile, restApiFunc){
                            public static final long serialVersionUID = 0L;
                            private final SubmitRequest submitRequest$3;
                            private final Configuration flinkConfig$2;
                            private final File jarFile$1;
                            private final Function3 restApiFunc$1;

                            public final SubmitResponse apply() {
                                return (SubmitResponse)this.restApiFunc$1.apply((Object)this.submitRequest$3, (Object)this.flinkConfig$2, (Object)this.jarFile$1);
                            }
                            {
                                this.submitRequest$3 = submitRequest$3;
                                this.flinkConfig$2 = flinkConfig$2;
                                this.jarFile$1 = jarFile$1;
                                this.restApiFunc$1 = restApiFunc$1;
                            }
                        });
                        if (!(try_2 instanceof Success)) break block5;
                        Success success2 = (Success)try_2;
                        submitResponse = submitResponse2 = (r = (SubmitResponse)success2.value());
                        break block6;
                    }
                    if (try_2 instanceof Failure) {
                        Failure failure3 = (Failure)try_2;
                        Throwable e1 = failure3.exception();
                        throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n\n                 |[flink-submit] Both JobGraph submit plan and Rest API submit plan all failed!\n                 |JobGraph Submit plan failed detail:\n                 |------------------------------------------------------------------\n                 |", "\n                 |------------------------------------------------------------------\n                 |\n                 | RestAPI Submit plan failed detail:\n                 | ------------------------------------------------------------------\n                 |", "\n                 |------------------------------------------------------------------\n                 |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.stringifyException(e), Utils$.MODULE$.stringifyException(e1)})))).stripMargin());
                    }
                    throw new MatchError((Object)try_2);
                }
                if (!(try_ instanceof Success)) break block7;
                Success success3 = (Success)try_;
                submitResponse = v = (SubmitResponse)success3.value();
            }
            return submitResponse;
        }
        throw new MatchError((Object)try_);
    }

    public static Tuple2 getJobGraph(FlinkClientTrait $this, Configuration flinkConfig, SubmitRequest submitRequest, File jarFile) {
        PackagedProgram packageProgram = PackagedProgram.newBuilder().setJarFile(jarFile).setEntryPointClassName((String)flinkConfig.getOptional(ApplicationConfiguration.APPLICATION_MAIN_CLASS).get()).setSavepointRestoreSettings(submitRequest.savepointRestoreSettings()).setArguments((String[])JavaConversions$.MODULE$.asScalaBuffer((List)flinkConfig.getOptional(ApplicationConfiguration.APPLICATION_ARGS).orElse(Lists.newArrayList())).toArray(ClassTag$.MODULE$.apply(String.class))).build();
        JobGraph jobGraph = PackagedProgramUtils.createJobGraph((PackagedProgram)packageProgram, (Configuration)flinkConfig, (int)Predef$.MODULE$.Integer2int($this.getParallelism(submitRequest)), null, (boolean)false);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)packageProgram), (Object)jobGraph);
    }

    public static JobID getJobID(FlinkClientTrait $this, String jobId) {
        Try try_ = Try$.MODULE$.apply((Function0)new Serializable($this, jobId){
            public static final long serialVersionUID = 0L;
            private final String jobId$1;

            public final JobID apply() {
                return JobID.fromHexString((String)this.jobId$1);
            }
            {
                this.jobId$1 = jobId$1;
            }
        });
        if (try_ instanceof Success) {
            JobID id;
            Success success2 = (Success)try_;
            JobID jobID = id = (JobID)success2.value();
            return jobID;
        }
        if (try_ instanceof Failure) {
            Failure failure2 = (Failure)try_;
            Throwable e = failure2.exception();
            throw new CliArgsException(e.getMessage());
        }
        throw new MatchError((Object)try_);
    }

    public static CustomCommandLine validateAndGetActiveCommandLine(FlinkClientTrait $this, List customCommandLines, CommandLine commandLine) {
        Object object = new Object();
        try {
            CommandLine line = (CommandLine)Preconditions.checkNotNull((Object)commandLine);
            $this.logInfo((Function0)new Serializable($this, customCommandLines){
                public static final long serialVersionUID = 0L;
                private final List customCommandLines$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Custom commandline: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.customCommandLines$1}));
                }
                {
                    this.customCommandLines$1 = customCommandLines$1;
                }
            });
            JavaConversions$.MODULE$.asScalaBuffer(customCommandLines).foreach((Function1)new Serializable($this, line, object){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FlinkClientTrait $outer;
                private final CommandLine line$1;
                private final Object nonLocalReturnKey1$1;

                public final void apply(CustomCommandLine cli) {
                    boolean isActive = cli.isActive(this.line$1);
                    this.$outer.logInfo((Function0)new Serializable(this, isActive, cli){
                        public static final long serialVersionUID = 0L;
                        private final boolean isActive$1;
                        private final CustomCommandLine cli$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking custom commandline ", ", isActive: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cli$1, BoxesRunTime.boxToBoolean((boolean)this.isActive$1)}));
                        }
                        {
                            this.isActive$1 = isActive$1;
                            this.cli$1 = cli$1;
                        }
                    });
                    if (isActive) {
                        throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)cli);
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.line$1 = line$1;
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            });
            throw new IllegalStateException("No valid command-line found.");
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return (CustomCommandLine)nonLocalReturnControl.value();
            }
            throw nonLocalReturnControl;
        }
    }

    public static Configuration getFlinkDefaultConfiguration(FlinkClientTrait $this, String flinkHome) {
        return (Configuration)Try$.MODULE$.apply((Function0)new Serializable($this, flinkHome){
            public static final long serialVersionUID = 0L;
            private final String flinkHome$1;

            public final Configuration apply() {
                return GlobalConfiguration.loadConfiguration((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/conf"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.flinkHome$1})));
            }
            {
                this.flinkHome$1 = flinkHome$1;
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Configuration apply() {
                return new Configuration();
            }
        });
    }

    public static Object getOptionFromDefaultFlinkConfig(FlinkClientTrait $this, String flinkHome, ConfigOption option) {
        return $this.getFlinkDefaultConfiguration(flinkHome).get(option);
    }

    public static List org$apache$streampark$flink$client$trait$FlinkClientTrait$$getCustomCommandLines(FlinkClientTrait $this, String flinkHome) {
        Configuration flinkDefaultConfiguration = $this.getFlinkDefaultConfiguration(flinkHome);
        String configurationDirectory = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/conf"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{flinkHome}));
        List customCommandLines = CliFrontend.loadCustomCommandLines((Configuration)flinkDefaultConfiguration, (String)configurationDirectory);
        new CliFrontend(flinkDefaultConfiguration, customCommandLines);
        return customCommandLines;
    }

    public static Integer getParallelism(FlinkClientTrait $this, SubmitRequest submitRequest) {
        return submitRequest.properties().containsKey(ConfigConst$.MODULE$.KEY_FLINK_PARALLELISM(ConfigConst$.MODULE$.KEY_FLINK_PARALLELISM$default$1())) ? Integer.valueOf(submitRequest.properties().get(ConfigConst$.MODULE$.KEY_FLINK_PARALLELISM(ConfigConst$.MODULE$.KEY_FLINK_PARALLELISM$default$1())).toString()) : Predef$.MODULE$.int2Integer($this.getFlinkDefaultConfiguration(submitRequest.flinkVersion().flinkHome()).getInteger(CoreOptions.DEFAULT_PARALLELISM, Predef$.MODULE$.Integer2int((Integer)CoreOptions.DEFAULT_PARALLELISM.defaultValue())));
    }

    public static Tuple2 org$apache$streampark$flink$client$trait$FlinkClientTrait$$getCommandLineAndFlinkConfig(FlinkClientTrait $this, SubmitRequest submitRequest) {
        Options commandLineOptions = $this.getCommandLineOptions(submitRequest.flinkVersion().flinkHome());
        HashMap optionMap = new HashMap();
        ((IterableLike)submitRequest.appOption().filter((Function1)new Serializable($this, commandLineOptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkClientTrait $outer;
            private final Options commandLineOptions$1;

            /*
             * WARNING - void declaration
             */
            public final boolean apply(Tuple2<String, String> x) {
                void var2_2;
                boolean verify = this.commandLineOptions$1.hasOption((String)x._1());
                if (!verify) {
                    this.$outer.logWarn((Function0)new Serializable(this, x){
                        public static final long serialVersionUID = 0L;
                        private final Tuple2 x$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"param:", " is error,skip it."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x$2._1()}));
                        }
                        {
                            this.x$2 = x$2;
                        }
                    });
                }
                return (boolean)var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commandLineOptions$1 = commandLineOptions$1;
            }
        })).foreach((Function1)new Serializable($this, commandLineOptions, optionMap){
            public static final long serialVersionUID = 0L;
            private final Options commandLineOptions$1;
            private final HashMap optionMap$1;

            public final Object apply(Tuple2<String, String> x) {
                String opt = this.commandLineOptions$1.getOption(((String)x._1()).trim()).getOpt();
                Object object = Try$.MODULE$.apply((Function0)new Serializable(this, x){
                    public static final long serialVersionUID = 0L;
                    private final Tuple2 x$3;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return new StringOps(Predef$.MODULE$.augmentString((String)this.x$3._2())).toBoolean();
                    }
                    {
                        this.x$3 = x$3;
                    }
                }).getOrElse((Function0)new Serializable(this, x){
                    public static final long serialVersionUID = 0L;
                    private final Tuple2 x$3;

                    public final String apply() {
                        return (String)this.x$3._2();
                    }
                    {
                        this.x$3 = x$3;
                    }
                });
                Object object2 = object instanceof Boolean ? (BoxesRunTime.unboxToBoolean((Object)object) ? this.optionMap$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opt}))), (Object)BoxesRunTime.boxToBoolean((boolean)true))) : BoxedUnit.UNIT) : this.optionMap$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opt}))), object));
                return object2;
            }
            {
                this.commandLineOptions$1 = commandLineOptions$1;
                this.optionMap$1 = optionMap$1;
            }
        });
        Object object = submitRequest.savePoint() == null ? BoxedUnit.UNIT : optionMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{FlinkRunOption$.MODULE$.SAVEPOINT_PATH_OPTION().getOpt()}))), (Object)submitRequest.savePoint()));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-e", "--executor", "-t", "--target"}))).foreach((Function1)new Serializable($this, optionMap){
            public static final long serialVersionUID = 0L;
            private final HashMap optionMap$1;

            public final Option<Object> apply(String key) {
                return this.optionMap$1.remove((Object)key);
            }
            {
                this.optionMap$1 = optionMap$1;
            }
        });
        Object object2 = submitRequest.executionMode() == null ? BoxedUnit.UNIT : optionMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-t"), (Object)submitRequest.executionMode().getName()));
        ArrayBuffer array2 = new ArrayBuffer();
        optionMap.foreach((Function1)new Serializable($this, array2){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer array$1;

            public final Object apply(Tuple2<String, Object> x) {
                BoxedUnit boxedUnit;
                this.array$1.$plus$eq(x._1());
                Object object = x._2();
                if (object instanceof String) {
                    String string = (String)object;
                    boxedUnit = this.array$1.$plus$eq((Object)string);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.array$1 = array$1;
            }
        });
        if (MapUtils.isNotEmpty((Map)submitRequest.properties())) {
            JavaConversions$.MODULE$.mapAsScalaMap(submitRequest.properties()).foreach((Function1)new Serializable($this, array2){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer array$1;

                public final Object apply(Tuple2<String, Object> x) {
                    return ((String)x._1()).startsWith(CoreOptions.FLINK_JVM_OPTIONS.key()) ? BoxedUnit.UNIT : this.array$1.$plus$eq((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-D", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x._1(), x._2()})));
                }
                {
                    this.array$1 = array$1;
                }
            });
        }
        String[] cliArgs = (String[])array2.toArray(ClassTag$.MODULE$.apply(String.class));
        $this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cliArgs: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])cliArgs).mkString(" ")})));
        CommandLine commandLine = FlinkRunOption$.MODULE$.parse(commandLineOptions, cliArgs, Predef$.MODULE$.boolean2Boolean(true));
        CustomCommandLine activeCommandLine = $this.validateAndGetActiveCommandLine(FlinkClientTrait$class.org$apache$streampark$flink$client$trait$FlinkClientTrait$$getCustomCommandLines($this, submitRequest.flinkVersion().flinkHome()), commandLine);
        Configuration configuration = FlinkClientTrait$class.org$apache$streampark$flink$client$trait$FlinkClientTrait$$applyConfiguration($this, submitRequest.flinkVersion().flinkHome(), activeCommandLine, commandLine);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)commandLine), (Object)configuration);
    }

    public static Options getCommandLineOptions(FlinkClientTrait $this, String flinkHome) {
        List customCommandLines = FlinkClientTrait$class.org$apache$streampark$flink$client$trait$FlinkClientTrait$$getCustomCommandLines($this, flinkHome);
        Options customCommandLineOptions = new Options();
        JavaConversions$.MODULE$.asScalaBuffer(customCommandLines).foreach((Function1)new Serializable($this, customCommandLineOptions){
            public static final long serialVersionUID = 0L;
            private final Options customCommandLineOptions$1;

            public final void apply(CustomCommandLine customCommandLine) {
                customCommandLine.addGeneralOptions(this.customCommandLineOptions$1);
                customCommandLine.addRunOptions(this.customCommandLineOptions$1);
            }
            {
                this.customCommandLineOptions$1 = customCommandLineOptions$1;
            }
        });
        return FlinkRunOption$.MODULE$.mergeOptions(CliFrontendParser.getRunCommandOptions(), customCommandLineOptions);
    }

    public static Configuration extractConfiguration(FlinkClientTrait $this, String flinkHome, Map properties) {
        Options commandLineOptions = $this.getCommandLineOptions(flinkHome);
        ArrayBuffer array2 = new ArrayBuffer();
        if (MapUtils.isNotEmpty((Map)properties)) {
            JavaConversions$.MODULE$.mapAsScalaMap(properties).foreach((Function1)new Serializable($this, array2){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer array$2;

                public final ArrayBuffer<String> apply(Tuple2<String, Object> x) {
                    return this.array$2.$plus$eq((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-D", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x._1(), x._2().toString().trim()})));
                }
                {
                    this.array$2 = array$2;
                }
            });
        }
        String[] cliArgs = (String[])array2.toArray(ClassTag$.MODULE$.apply(String.class));
        CommandLine commandLine = FlinkRunOption$.MODULE$.parse(commandLineOptions, cliArgs, Predef$.MODULE$.boolean2Boolean(true));
        CustomCommandLine activeCommandLine = $this.validateAndGetActiveCommandLine(FlinkClientTrait$class.org$apache$streampark$flink$client$trait$FlinkClientTrait$$getCustomCommandLines($this, flinkHome), commandLine);
        Configuration flinkConfig = FlinkClientTrait$class.org$apache$streampark$flink$client$trait$FlinkClientTrait$$applyConfiguration($this, flinkHome, activeCommandLine, commandLine);
        return flinkConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List org$apache$streampark$flink$client$trait$FlinkClientTrait$$extractProgramArgs(FlinkClientTrait $this, SubmitRequest submitRequest) {
        BoxedUnit boxedUnit;
        ArrayBuffer programArgs = new ArrayBuffer();
        programArgs.$plus$plus$eq((TraversableOnce)PropertiesUtils$.MODULE$.extractArguments(submitRequest.args()));
        ApplicationType applicationType = submitRequest.applicationType();
        ApplicationType applicationType2 = ApplicationType.STREAMPARK_FLINK;
        if (!(applicationType != null ? !applicationType.equals(applicationType2) : applicationType2 != null)) {
            BoxedUnit boxedUnit2;
            programArgs.$plus$eq((Object)$this.PARAM_KEY_FLINK_CONF()).$plus$eq((Object)submitRequest.flinkYaml());
            programArgs.$plus$eq((Object)$this.PARAM_KEY_APP_NAME()).$plus$eq((Object)DeflaterUtils$.MODULE$.zipString(submitRequest.effectiveAppName()));
            programArgs.$plus$eq((Object)$this.PARAM_KEY_FLINK_PARALLELISM()).$plus$eq((Object)$this.getParallelism(submitRequest).toString());
            DevelopmentMode developmentMode = submitRequest.developmentMode();
            if (DevelopmentMode.FLINK_SQL.equals(developmentMode)) {
                programArgs.$plus$eq((Object)$this.PARAM_KEY_FLINK_SQL()).$plus$eq((Object)submitRequest.flinkSQL());
                boxedUnit2 = submitRequest.appConf() == null ? BoxedUnit.UNIT : programArgs.$plus$eq((Object)$this.PARAM_KEY_APP_CONF()).$plus$eq((Object)submitRequest.appConf());
            } else {
                if (!BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable($this, submitRequest){
                    public static final long serialVersionUID = 0L;
                    private final SubmitRequest submitRequest$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return !this.submitRequest$1.appConf().startsWith("json:");
                    }
                    {
                        this.submitRequest$1 = submitRequest$1;
                    }
                }).getOrElse((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return true;
                    }
                }))) throw new MatchError((Object)developmentMode);
                boxedUnit2 = programArgs.$plus$eq((Object)$this.PARAM_KEY_APP_CONF()).$plus$eq((Object)submitRequest.appConf());
            }
            boxedUnit = boxedUnit2;
            return Lists.newArrayList((Object[])((Object[])programArgs.toArray(ClassTag$.MODULE$.apply(String.class))));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Lists.newArrayList((Object[])((Object[])programArgs.toArray(ClassTag$.MODULE$.apply(String.class))));
    }

    public static Configuration org$apache$streampark$flink$client$trait$FlinkClientTrait$$applyConfiguration(FlinkClientTrait $this, String flinkHome, CustomCommandLine activeCustomCommandLine, CommandLine commandLine) {
        Predef$.MODULE$.require(activeCustomCommandLine != null, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "activeCustomCommandLine must not be null.";
            }
        });
        Configuration configuration = new Configuration();
        Configuration flinkDefaultConfiguration = $this.getFlinkDefaultConfiguration(flinkHome);
        JavaConversions$.MODULE$.asScalaSet(flinkDefaultConfiguration.keySet()).foreach((Function1)new Serializable($this, configuration, flinkDefaultConfiguration){
            public static final long serialVersionUID = 0L;
            private final Configuration configuration$1;
            private final Configuration flinkDefaultConfiguration$1;

            public final void apply(String x) {
                String string = this.flinkDefaultConfiguration$1.getString(x, null);
                if (string == null) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.configuration$1.setString(x, string);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.configuration$1 = configuration$1;
                this.flinkDefaultConfiguration$1 = flinkDefaultConfiguration$1;
            }
        });
        configuration.addAll(activeCustomCommandLine.toConfiguration(commandLine));
        return configuration;
    }

    public static FlinkClientTrait.EnhanceFlinkConfiguration EnhanceFlinkConfiguration(FlinkClientTrait $this, Configuration flinkConfig) {
        return new FlinkClientTrait.EnhanceFlinkConfiguration($this, flinkConfig);
    }

    public static String cancelJob(FlinkClientTrait $this, CancelRequest cancelRequest, JobID jobID, ClusterClient client) {
        Tuple2.mcZZ.sp sp2;
        block5: {
            String string;
            block3: {
                FlinkClusterClient clientWrapper;
                String savePointDir;
                block4: {
                    block2: {
                        savePointDir = FlinkClientTrait$class.tryGetSavepointPathIfNeed($this, (SavepointRequestTrait)cancelRequest);
                        clientWrapper = new FlinkClusterClient(client);
                        sp2 = new Tuple2.mcZZ.sp(BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable($this, cancelRequest){
                            public static final long serialVersionUID = 0L;
                            private final CancelRequest cancelRequest$2;

                            public final boolean apply() {
                                return this.apply$mcZ$sp();
                            }

                            public boolean apply$mcZ$sp() {
                                return this.cancelRequest$2.withSavepoint();
                            }
                            {
                                this.cancelRequest$2 = cancelRequest$2;
                            }
                        }).getOrElse((Function0)new Serializable($this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply() {
                                return this.apply$mcZ$sp();
                            }

                            public boolean apply$mcZ$sp() {
                                return false;
                            }
                        })), BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable($this, cancelRequest){
                            public static final long serialVersionUID = 0L;
                            private final CancelRequest cancelRequest$2;

                            public final boolean apply() {
                                return this.apply$mcZ$sp();
                            }

                            public boolean apply$mcZ$sp() {
                                return this.cancelRequest$2.withDrain();
                            }
                            {
                                this.cancelRequest$2 = cancelRequest$2;
                            }
                        }).getOrElse((Function0)new Serializable($this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply() {
                                return this.apply$mcZ$sp();
                            }

                            public boolean apply$mcZ$sp() {
                                return false;
                            }
                        })));
                        if (sp2 == null) break block2;
                        boolean bl = sp2._1$mcZ$sp();
                        boolean bl2 = sp2._2$mcZ$sp();
                        if (bl || bl2) break block2;
                        client.cancel(jobID).get();
                        string = null;
                        break block3;
                    }
                    if (sp2 == null) break block4;
                    boolean bl = sp2._1$mcZ$sp();
                    boolean bl3 = sp2._2$mcZ$sp();
                    if (!bl || bl3) break block4;
                    string = (String)clientWrapper.cancelWithSavepoint(jobID, savePointDir).get();
                    break block3;
                }
                if (sp2 == null) break block5;
                string = (String)clientWrapper.stopWithSavepoint(jobID, cancelRequest.withDrain(), savePointDir).get();
            }
            return string;
        }
        throw new MatchError((Object)sp2);
    }

    private static String tryGetSavepointPathIfNeed(FlinkClientTrait $this, SavepointRequestTrait request) {
        String string;
        if (request.withSavepoint()) {
            if (StringUtils.isNotEmpty((CharSequence)request.savepointPath())) {
                string = request.savepointPath();
            } else {
                ExecutionMode executionMode = request.executionMode();
                ExecutionMode executionMode2 = ExecutionMode.YARN_APPLICATION;
                String configDir = (String)$this.getOptionFromDefaultFlinkConfig(request.flinkVersion().flinkHome(), ConfigOptions.key((String)CheckpointingOptions.SAVEPOINT_DIRECTORY.key()).stringType().defaultValue(!(executionMode != null ? !executionMode.equals(executionMode2) : executionMode2 != null) ? Workspace$.MODULE$.remote().APP_SAVEPOINTS() : null));
                if (StringUtils.isEmpty((CharSequence)configDir)) {
                    throw new FlinkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] executionMode: ", ", savePoint path is null or invalid."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.executionMode().getName()})));
                }
                string = configDir;
            }
        } else {
            string = null;
        }
        return string;
    }

    public static String triggerSavepoint(FlinkClientTrait $this, TriggerSavepointRequest savepointRequest, JobID jobID, ClusterClient client) {
        String savepointPath = FlinkClientTrait$class.tryGetSavepointPathIfNeed($this, (SavepointRequestTrait)savepointRequest);
        FlinkClusterClient clientWrapper = new FlinkClusterClient(client);
        return (String)clientWrapper.triggerSavepoint(jobID, savepointPath).get();
    }

    public static void $init$(FlinkClientTrait $this) {
    }
}

