/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.task;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.SavePoint;
import org.apache.streampark.console.core.enums.CheckPointStatus;
import org.apache.streampark.console.core.enums.FailoverStrategy;
import org.apache.streampark.console.core.metrics.flink.CheckPoints;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.SavePointService;
import org.apache.streampark.console.core.service.alert.AlertService;
import org.apache.streampark.console.core.task.FlinkRESTAPIWatcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CheckpointProcessor {
    private static final Byte DEFAULT_FLAG_BYTE = Byte.valueOf("0");
    private static final Integer SAVEPOINT_CACHE_HOUR = 1;
    private final Cache<String, Long> checkPointCache = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build();
    private final Cache<String, Byte> savepointedCache = Caffeine.newBuilder().expireAfterWrite((long)SAVEPOINT_CACHE_HOUR.intValue(), TimeUnit.HOURS).build();
    private final Map<Long, Counter> checkPointFailedCache = new ConcurrentHashMap<Long, Counter>(0);
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private AlertService alertService;
    @Autowired
    private SavePointService savePointService;
    @Autowired
    private FlinkRESTAPIWatcher flinkRESTAPIWatcher;

    public void process(Application application, @Nonnull CheckPoints checkPoints) {
        checkPoints.getLatestCheckpoint().forEach(checkPoint -> this.process(application, (CheckPoints.CheckPoint)checkPoint));
    }

    private void process(Application application, @Nonnull CheckPoints.CheckPoint checkPoint) {
        String jobID = application.getJobId();
        Long appId = application.getId();
        CheckPointStatus status = checkPoint.getCheckPointStatus();
        CheckPointKey checkPointKey = new CheckPointKey(appId, jobID, checkPoint.getId());
        if (CheckPointStatus.COMPLETED.equals(status)) {
            if (this.shouldStoreAsSavepoint(checkPointKey, checkPoint)) {
                this.savepointedCache.put((Object)checkPointKey.getSavePointId(), (Object)DEFAULT_FLAG_BYTE);
                this.saveSavepoint(checkPoint, application.getId());
                this.flinkRESTAPIWatcher.cleanSavepoint(application);
                return;
            }
            Long latestChkId = this.getLatestCheckpointedId(appId, checkPointKey.getCheckPointId());
            if (CheckpointProcessor.shouldStoreAsCheckpoint(checkPoint, latestChkId)) {
                this.checkPointCache.put((Object)checkPointKey.getCheckPointId(), (Object)checkPoint.getId());
                this.saveSavepoint(checkPoint, application.getId());
            }
        } else if (this.shouldProcessFailedTrigger(checkPoint, application.cpFailedTrigger(), status)) {
            Counter counter = this.checkPointFailedCache.get(appId);
            if (counter == null) {
                this.checkPointFailedCache.put(appId, new Counter(checkPoint.getTriggerTimestamp()));
            } else {
                long minute = counter.getDuration(checkPoint.getTriggerTimestamp());
                if (minute <= (long)application.getCpFailureRateInterval().intValue() && counter.getCount() >= application.getCpMaxFailureInterval()) {
                    this.checkPointFailedCache.remove(appId);
                    FailoverStrategy failoverStrategy = FailoverStrategy.of(application.getCpFailureAction());
                    if (failoverStrategy == null) {
                        throw new IllegalArgumentException("Unexpected cpFailureAction: " + application.getCpFailureAction());
                    }
                    switch (failoverStrategy) {
                        case ALERT: {
                            this.alertService.alert(application, CheckPointStatus.FAILED);
                            break;
                        }
                        case RESTART: {
                            try {
                                this.applicationService.restart(application);
                                break;
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                } else {
                    counter.increment();
                }
            }
        }
    }

    private static boolean shouldStoreAsCheckpoint(@Nonnull CheckPoints.CheckPoint checkPoint, Long latestId) {
        return checkPoint.getIsSavepoint() == false && (latestId == null || latestId < checkPoint.getId());
    }

    private boolean shouldStoreAsSavepoint(CheckPointKey checkPointKey, @Nonnull CheckPoints.CheckPoint checkPoint) {
        if (!checkPoint.getIsSavepoint().booleanValue()) {
            return false;
        }
        return this.savepointedCache.getIfPresent((Object)checkPointKey.getSavePointId()) == null && checkPoint.getTriggerTimestamp() >= System.currentTimeMillis() - TimeUnit.HOURS.toMillis(SAVEPOINT_CACHE_HOUR.intValue());
    }

    @Nullable
    private Long getLatestCheckpointedId(Long appId, String cacheId) {
        return (Long)this.checkPointCache.get((Object)cacheId, key -> {
            SavePoint savePoint = this.savePointService.getLatest(appId);
            return Optional.ofNullable(savePoint).map(SavePoint::getChkId).orElse(null);
        });
    }

    private boolean shouldProcessFailedTrigger(CheckPoints.CheckPoint checkPoint, boolean cpFailedTrigger, CheckPointStatus status) {
        return CheckPointStatus.FAILED.equals(status) && checkPoint.getIsSavepoint() == false && cpFailedTrigger;
    }

    private void saveSavepoint(CheckPoints.CheckPoint checkPoint, Long appId) {
        SavePoint savePoint = new SavePoint();
        savePoint.setAppId(appId);
        savePoint.setChkId(checkPoint.getId());
        savePoint.setLatest(true);
        savePoint.setType(checkPoint.getCheckPointType().get());
        savePoint.setPath(checkPoint.getExternalPath());
        savePoint.setTriggerTime(new Date(checkPoint.getTriggerTimestamp()));
        savePoint.setCreateTime(new Date());
        this.savePointService.save(savePoint);
    }

    public static class CheckPointKey {
        private Long appId;
        private String jobId;
        private Long checkId;

        public CheckPointKey(Long appId, String jobId, Long checkId) {
            this.appId = appId;
            this.jobId = jobId;
            this.checkId = checkId;
        }

        public String getSavePointId() {
            return String.format("%s_%s_%s", this.appId, this.jobId, this.checkId);
        }

        public String getCheckPointId() {
            return String.format("%s_%s", this.appId, this.jobId);
        }

        public Long getAppId() {
            return this.appId;
        }

        public String getJobId() {
            return this.jobId;
        }

        public Long getCheckId() {
            return this.checkId;
        }

        public void setAppId(Long appId) {
            this.appId = appId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public void setCheckId(Long checkId) {
            this.checkId = checkId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CheckPointKey)) {
                return false;
            }
            CheckPointKey other = (CheckPointKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$appId = this.getAppId();
            Long other$appId = other.getAppId();
            if (this$appId == null ? other$appId != null : !((Object)this$appId).equals(other$appId)) {
                return false;
            }
            Long this$checkId = this.getCheckId();
            Long other$checkId = other.getCheckId();
            if (this$checkId == null ? other$checkId != null : !((Object)this$checkId).equals(other$checkId)) {
                return false;
            }
            String this$jobId = this.getJobId();
            String other$jobId = other.getJobId();
            return !(this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CheckPointKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $appId = this.getAppId();
            result = result * 59 + ($appId == null ? 43 : ((Object)$appId).hashCode());
            Long $checkId = this.getCheckId();
            result = result * 59 + ($checkId == null ? 43 : ((Object)$checkId).hashCode());
            String $jobId = this.getJobId();
            result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
            return result;
        }

        public String toString() {
            return "CheckpointProcessor.CheckPointKey(appId=" + this.getAppId() + ", jobId=" + this.getJobId() + ", checkId=" + this.getCheckId() + ")";
        }
    }

    public static class Counter {
        private final Long timestamp;
        private final AtomicInteger count;

        public Counter(Long timestamp) {
            this.timestamp = timestamp;
            this.count = new AtomicInteger(1);
        }

        public void increment() {
            this.count.incrementAndGet();
        }

        public Integer getCount() {
            return this.count.get();
        }

        public long getDuration(Long currentTimestamp) {
            return (currentTimestamp - this.timestamp) / 1000L / 60L;
        }
    }
}

