/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.websocket;

import io.undertow.util.CopyOnWriteMap;
import java.io.IOException;
import java.util.Map;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.apache.streampark.console.core.entity.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/websocket/{id}")
public class WebSocketEndpoint {
    private static final Logger log = LoggerFactory.getLogger(WebSocketEndpoint.class);
    private static final Map<String, Session> SOCKET_SESSIONS = new CopyOnWriteMap();
    private String id;
    private Session session;

    @OnOpen
    public void onOpen(Session session, @PathParam(value="id") String id) {
        log.debug("websocket onOpen....");
        this.id = id;
        this.session = session;
        SOCKET_SESSIONS.put(id, session);
    }

    @OnClose
    public void onClose() throws IOException {
        log.debug("websocket onClose....");
        this.session.close();
        SOCKET_SESSIONS.remove(this.id);
    }

    @OnError
    public void onError(Session session, Throwable e) {
        log.error(e.getMessage(), e);
    }

    public static void writeMessage(String socketId, String message) {
        try {
            Session session = SOCKET_SESSIONS.get(socketId);
            if (session != null) {
                session.getBasicRemote().sendText(message);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void pushNotice(Message message) {
        try {
            Session session = SOCKET_SESSIONS.get(message.getUserId().toString());
            if (session != null) {
                session.getBasicRemote().sendObject((Object)message);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getId() {
        return this.id;
    }

    public Session getSession() {
        return this.session;
    }
}

