/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.extension;

import com.github.xiaoymin.knife4j.spring.configuration.Knife4jProperties;
import com.github.xiaoymin.knife4j.spring.configuration.Knife4jSetting;
import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtensionResolver;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.customizers.GlobalOpenApiCustomizer;

public class Knife4jOpenApiCustomizer
implements GlobalOpenApiCustomizer {
    private static final Logger log = LoggerFactory.getLogger(Knife4jOpenApiCustomizer.class);
    final Knife4jProperties knife4jProperties;

    public void customise(OpenAPI openApi) {
        log.debug("Knife4j OpenApiCustomizer");
        if (this.knife4jProperties.isEnable()) {
            Knife4jSetting setting = this.knife4jProperties.getSetting();
            OpenApiExtensionResolver openApiExtensionResolver = new OpenApiExtensionResolver(setting, this.knife4jProperties.getDocuments());
            openApiExtensionResolver.start();
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            objectMap.put("x-setting", setting);
            objectMap.put("x-markdownFiles", openApiExtensionResolver.getMarkdownFiles());
            openApi.addExtension("x-openapi", objectMap);
        }
    }

    public Knife4jOpenApiCustomizer(Knife4jProperties knife4jProperties) {
        this.knife4jProperties = knife4jProperties;
    }
}

