/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.util.Preconditions;

@Internal
public class FieldList
extends FieldSet {
    public static final FieldList EMPTY_LIST = new FieldList();

    public FieldList() {
        super(Collections.emptyList());
    }

    public FieldList(int fieldId) {
        super(Collections.singletonList(fieldId));
    }

    public FieldList(Integer fieldId) {
        super(Collections.singletonList(Preconditions.checkNotNull(fieldId, "The fields ID must not be null.")));
    }

    public FieldList(int ... columnIndexes) {
        super(FieldList.fromInts(columnIndexes));
    }

    private FieldList(List<Integer> fields) {
        super(fields);
    }

    @Override
    public FieldList addField(Integer fieldID) {
        if (fieldID == null) {
            throw new IllegalArgumentException("Field ID must not be null.");
        }
        if (this.size() == 0) {
            return new FieldList(fieldID);
        }
        ArrayList<Integer> list = new ArrayList<Integer>(this.size() + 1);
        list.addAll(this.collection);
        list.add(fieldID);
        return new FieldList(Collections.unmodifiableList(list));
    }

    @Override
    public FieldList addFields(int ... fieldIDs) {
        if (fieldIDs == null || fieldIDs.length == 0) {
            return this;
        }
        if (this.size() == 0) {
            return new FieldList(fieldIDs);
        }
        ArrayList<Integer> list = new ArrayList<Integer>(this.size() + fieldIDs.length);
        list.addAll(this.collection);
        for (int i = 0; i < fieldIDs.length; ++i) {
            list.add(fieldIDs[i]);
        }
        return new FieldList(Collections.unmodifiableList(list));
    }

    @Override
    public FieldList addFields(FieldSet set) {
        if (set == null) {
            throw new IllegalArgumentException("FieldSet to add must not be null.");
        }
        if (set.size() == 0) {
            return this;
        }
        if (this.size() == 0 && set instanceof FieldList) {
            return (FieldList)set;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(this.size() + set.size());
        list.addAll(this.collection);
        list.addAll(set.collection);
        return new FieldList(Collections.unmodifiableList(list));
    }

    public Integer get(int pos) {
        return this.get().get(pos);
    }

    @Override
    public FieldList toFieldList() {
        return this;
    }

    @Override
    public boolean isValidSubset(FieldSet set) {
        if (set instanceof FieldList) {
            return this.isValidSubset((FieldList)set);
        }
        return false;
    }

    public boolean isValidSubset(FieldList list) {
        if (list.size() > this.size()) {
            return false;
        }
        List<Integer> myList = this.get();
        List<Integer> theirList = list.get();
        for (int i = 0; i < theirList.size(); ++i) {
            Integer myInt = myList.get(i);
            Integer theirInt = theirList.get(i);
            if (myInt.intValue() == theirInt.intValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isValidUnorderedPrefix(FieldSet set) {
        if (set.size() > this.size()) {
            return false;
        }
        List<Integer> list = this.get();
        for (int i = 0; i < set.size(); ++i) {
            if (set.contains(list.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isExactMatch(FieldList list) {
        if (this.size() != list.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).equals(list.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getDescriptionPrefix() {
        return "[";
    }

    @Override
    protected String getDescriptionSuffix() {
        return "]";
    }

    private List<Integer> get() {
        return (List)this.collection;
    }

    private static final List<Integer> fromInts(int ... ints) {
        if (ints == null || ints.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Integer> al = new ArrayList<Integer>(ints.length);
        for (int i = 0; i < ints.length; ++i) {
            al.add(ints[i]);
        }
        return Collections.unmodifiableList(al);
    }
}

