/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.MaskUtils;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.types.RowUtils;
import org.apache.flink.util.Preconditions;

@Internal
public final class RowSerializer
extends TypeSerializer<Row> {
    public static final int ROW_KIND_OFFSET = 2;
    private static final long serialVersionUID = 1L;
    private final boolean supportsRowKind;
    private final int rowKindOffset;
    private final TypeSerializer<Object>[] fieldSerializers;
    private final int arity;
    @Nullable
    private final LinkedHashMap<String, Integer> positionByName;
    private transient boolean[] mask;
    private transient Row reuseRowPositionBased;

    public RowSerializer(TypeSerializer<?>[] fieldSerializers) {
        this(fieldSerializers, null, true);
    }

    public RowSerializer(TypeSerializer<?>[] fieldSerializers, @Nullable LinkedHashMap<String, Integer> positionByName) {
        this(fieldSerializers, positionByName, true);
    }

    public RowSerializer(TypeSerializer<?>[] fieldSerializers, @Nullable LinkedHashMap<String, Integer> positionByName, boolean supportsRowKind) {
        this.supportsRowKind = supportsRowKind;
        this.rowKindOffset = supportsRowKind ? 2 : 0;
        this.fieldSerializers = Preconditions.checkNotNull(fieldSerializers);
        this.arity = fieldSerializers.length;
        this.positionByName = positionByName;
        this.mask = new boolean[this.rowKindOffset + fieldSerializers.length];
        this.reuseRowPositionBased = new Row(fieldSerializers.length);
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public TypeSerializer<Row> duplicate() {
        TypeSerializer[] duplicateFieldSerializers = new TypeSerializer[this.fieldSerializers.length];
        for (int i = 0; i < this.fieldSerializers.length; ++i) {
            duplicateFieldSerializers[i] = this.fieldSerializers[i].duplicate();
        }
        return new RowSerializer(duplicateFieldSerializers, this.positionByName, this.supportsRowKind);
    }

    @Override
    public Row createInstance() {
        return RowUtils.createRowWithNamedPositions(RowKind.INSERT, new Object[this.fieldSerializers.length], this.positionByName);
    }

    @Override
    public Row copy(Row from) {
        Set<String> fieldNames = from.getFieldNames(false);
        if (fieldNames == null) {
            return this.copyPositionBased(from);
        }
        return this.copyNameBased(from, fieldNames);
    }

    private Row copyPositionBased(Row from) {
        int length = this.fieldSerializers.length;
        if (from.getArity() != length) {
            throw new RuntimeException("Row arity of from (" + from.getArity() + ") does not match this serializer's field length (" + length + ").");
        }
        Object[] fieldByPosition = new Object[length];
        for (int i = 0; i < length; ++i) {
            Object copy;
            Object fromField = from.getField(i);
            if (fromField == null) continue;
            fieldByPosition[i] = copy = this.fieldSerializers[i].copy(fromField);
        }
        return RowUtils.createRowWithNamedPositions(from.getKind(), fieldByPosition, this.positionByName);
    }

    private Row copyNameBased(Row from, Set<String> fieldNames) {
        if (this.positionByName == null) {
            throw new RuntimeException("Serializer does not support named field positions.");
        }
        Row newRow = Row.withNames(from.getKind());
        for (String fieldName : fieldNames) {
            int targetPos = this.getPositionByName(fieldName);
            Object fromField = from.getField(fieldName);
            if (fromField != null) {
                Object copy = this.fieldSerializers[targetPos].copy(fromField);
                newRow.setField(fieldName, copy);
                continue;
            }
            newRow.setField(fieldName, null);
        }
        return newRow;
    }

    @Override
    public Row copy(Row from, Row reuse) {
        if (reuse == null) {
            return this.copy(from);
        }
        Set<String> fieldNames = from.getFieldNames(false);
        if (fieldNames == null) {
            if (reuse.getFieldNames(false) != null) {
                return this.copy(from);
            }
            return this.copyPositionBased(from, reuse);
        }
        if (reuse.getFieldNames(false) == null) {
            return this.copy(from);
        }
        return this.copyNameBased(from, fieldNames, reuse);
    }

    private Row copyPositionBased(Row from, Row reuse) {
        int length = this.fieldSerializers.length;
        if (from.getArity() != length || reuse.getArity() != length) {
            throw new RuntimeException("Row arity of reuse (" + reuse.getArity() + ") or from (" + from.getArity() + ") is incompatible with this serializer's field length (" + length + ").");
        }
        reuse.setKind(from.getKind());
        for (int i = 0; i < length; ++i) {
            Object fromField = from.getField(i);
            if (fromField != null) {
                Object copy;
                Object reuseField = reuse.getField(i);
                if (reuseField != null) {
                    copy = this.fieldSerializers[i].copy(fromField, reuseField);
                    reuse.setField(i, copy);
                    continue;
                }
                copy = this.fieldSerializers[i].copy(fromField);
                reuse.setField(i, copy);
                continue;
            }
            reuse.setField(i, null);
        }
        return reuse;
    }

    private Row copyNameBased(Row from, Set<String> fieldNames, Row reuse) {
        if (this.positionByName == null) {
            throw new RuntimeException("Serializer does not support named field positions.");
        }
        reuse.clear();
        reuse.setKind(from.getKind());
        for (String fieldName : fieldNames) {
            Object copy;
            int targetPos = this.getPositionByName(fieldName);
            Object fromField = from.getField(fieldName);
            if (fromField == null) continue;
            Object reuseField = reuse.getField(fieldName);
            if (reuseField != null) {
                copy = this.fieldSerializers[targetPos].copy(fromField, reuseField);
                reuse.setField(fieldName, copy);
                continue;
            }
            copy = this.fieldSerializers[targetPos].copy(fromField);
            reuse.setField(fieldName, copy);
        }
        return reuse;
    }

    @Override
    public int getLength() {
        return -1;
    }

    public int getArity() {
        return this.arity;
    }

    @Override
    public void serialize(Row record, DataOutputView target) throws IOException {
        Set<String> fieldNames = record.getFieldNames(false);
        if (fieldNames == null) {
            this.serializePositionBased(record, target);
        } else {
            this.serializeNameBased(record, fieldNames, target);
        }
    }

    private void serializePositionBased(Row record, DataOutputView target) throws IOException {
        int length = this.fieldSerializers.length;
        if (record.getArity() != length) {
            throw new RuntimeException("Row arity of record (" + record.getArity() + ") does not match this serializer's field length (" + length + ").");
        }
        RowSerializer.fillMask(length, record, this.mask, this.supportsRowKind, this.rowKindOffset);
        MaskUtils.writeMask(this.mask, target);
        for (int fieldPos = 0; fieldPos < length; ++fieldPos) {
            Object o = record.getField(fieldPos);
            if (o == null) continue;
            this.fieldSerializers[fieldPos].serialize(o, target);
        }
    }

    private void serializeNameBased(Row record, Set<String> fieldNames, DataOutputView target) throws IOException {
        if (this.positionByName == null) {
            throw new RuntimeException("Serializer does not support named field positions.");
        }
        this.reuseRowPositionBased.clear();
        this.reuseRowPositionBased.setKind(record.getKind());
        for (String fieldName : fieldNames) {
            int targetPos = this.getPositionByName(fieldName);
            Object value = record.getField(fieldName);
            this.reuseRowPositionBased.setField(targetPos, value);
        }
        this.serializePositionBased(this.reuseRowPositionBased, target);
    }

    @Override
    public Row deserialize(DataInputView source) throws IOException {
        int length = this.fieldSerializers.length;
        MaskUtils.readIntoMask(source, this.mask);
        RowKind kind = !this.supportsRowKind ? RowKind.INSERT : RowSerializer.readKindFromMask(this.mask);
        Object[] fieldByPosition = new Object[length];
        for (int fieldPos = 0; fieldPos < length; ++fieldPos) {
            if (this.mask[this.rowKindOffset + fieldPos]) continue;
            fieldByPosition[fieldPos] = this.fieldSerializers[fieldPos].deserialize(source);
        }
        return RowUtils.createRowWithNamedPositions(kind, fieldByPosition, this.positionByName);
    }

    @Override
    public Row deserialize(Row reuse, DataInputView source) throws IOException {
        if (reuse == null || reuse.getFieldNames(false) != null) {
            return this.deserialize(source);
        }
        int length = this.fieldSerializers.length;
        if (reuse.getArity() != length) {
            throw new RuntimeException("Row arity of reuse (" + reuse.getArity() + ") does not match this serializer's field length (" + length + ").");
        }
        MaskUtils.readIntoMask(source, this.mask);
        if (this.supportsRowKind) {
            reuse.setKind(RowSerializer.readKindFromMask(this.mask));
        }
        for (int fieldPos = 0; fieldPos < length; ++fieldPos) {
            if (this.mask[this.rowKindOffset + fieldPos]) {
                reuse.setField(fieldPos, null);
                continue;
            }
            Object reuseField = reuse.getField(fieldPos);
            if (reuseField != null) {
                reuse.setField(fieldPos, this.fieldSerializers[fieldPos].deserialize(reuseField, source));
                continue;
            }
            reuse.setField(fieldPos, this.fieldSerializers[fieldPos].deserialize(source));
        }
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int len = this.fieldSerializers.length;
        MaskUtils.readIntoAndCopyMask(source, target, this.mask);
        for (int fieldPos = 0; fieldPos < len; ++fieldPos) {
            if (this.mask[this.rowKindOffset + fieldPos]) continue;
            this.fieldSerializers[fieldPos].copy(source, target);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowSerializer that = (RowSerializer)o;
        return this.supportsRowKind == that.supportsRowKind && Arrays.equals(this.fieldSerializers, that.fieldSerializers);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.supportsRowKind);
        result = 31 * result + Arrays.hashCode(this.fieldSerializers);
        return result;
    }

    private int getPositionByName(String fieldName) {
        assert (this.positionByName != null);
        Integer targetPos = this.positionByName.get(fieldName);
        if (targetPos == null) {
            throw new RuntimeException(String.format("Unknown field name '%s' for mapping to a row position. Available names are: %s", fieldName, this.positionByName.keySet()));
        }
        return targetPos;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.mask = new boolean[this.rowKindOffset + this.fieldSerializers.length];
        this.reuseRowPositionBased = new Row(this.fieldSerializers.length);
    }

    private static void fillMask(int fieldLength, Row row, boolean[] mask, boolean supportsRowKind, int rowKindOffset) {
        if (supportsRowKind) {
            byte kind = row.getKind().toByteValue();
            mask[0] = (kind & 1) > 0;
            mask[1] = (kind & 2) > 0;
        }
        for (int fieldPos = 0; fieldPos < fieldLength; ++fieldPos) {
            mask[rowKindOffset + fieldPos] = row.getField(fieldPos) == null;
        }
    }

    private static RowKind readKindFromMask(boolean[] mask) {
        byte kind = (byte)((mask[0] ? 1 : 0) + (mask[1] ? 2 : 0));
        return RowKind.fromByteValue(kind);
    }

    @Override
    public TypeSerializerSnapshot<Row> snapshotConfiguration() {
        return new RowSerializerSnapshot(this);
    }

    public static final class RowSerializerSnapshot
    extends CompositeTypeSerializerSnapshot<Row, RowSerializer> {
        private static final int VERSION = 4;
        private static final int FIRST_VERSION_WITH_ROW_KIND = 3;
        private boolean supportsRowKind = true;

        public RowSerializerSnapshot() {
            super(RowSerializer.class);
        }

        RowSerializerSnapshot(RowSerializer serializerInstance) {
            super(serializerInstance);
            this.supportsRowKind = serializerInstance.supportsRowKind;
        }

        @Override
        protected int getCurrentOuterSnapshotVersion() {
            return 4;
        }

        @Override
        protected void readOuterSnapshot(int readOuterSnapshotVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            this.supportsRowKind = readOuterSnapshotVersion < 3 ? false : (readOuterSnapshotVersion == 3 ? true : in.readBoolean());
        }

        @Override
        protected void writeOuterSnapshot(DataOutputView out) throws IOException {
            out.writeBoolean(this.supportsRowKind);
        }

        @Override
        protected CompositeTypeSerializerSnapshot.OuterSchemaCompatibility resolveOuterSchemaCompatibility(RowSerializer newSerializer) {
            if (this.supportsRowKind != newSerializer.supportsRowKind) {
                return CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AFTER_MIGRATION;
            }
            return CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AS_IS;
        }

        @Override
        protected TypeSerializer<?>[] getNestedSerializers(RowSerializer outerSerializer) {
            return outerSerializer.fieldSerializers;
        }

        @Override
        protected RowSerializer createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            return new RowSerializer(nestedSerializers, null, this.supportsRowKind);
        }
    }

    @Deprecated
    public static final class RowSerializerConfigSnapshot
    extends CompositeTypeSerializerConfigSnapshot<Row> {
        private static final int VERSION = 1;

        public RowSerializerConfigSnapshot() {
        }

        public RowSerializerConfigSnapshot(TypeSerializer<?>[] fieldSerializers) {
            super(fieldSerializers);
        }

        @Override
        public int getVersion() {
            return 1;
        }

        @Override
        public TypeSerializerSchemaCompatibility<Row> resolveSchemaCompatibility(TypeSerializer<Row> newSerializer) {
            TypeSerializerSnapshot[] nestedSnapshots = (TypeSerializerSnapshot[])this.getNestedSerializersAndConfigs().stream().map(t -> (TypeSerializerSnapshot)t.f1).toArray(TypeSerializerSnapshot[]::new);
            return CompositeTypeSerializerUtil.delegateCompatibilityCheckToNewSnapshot(newSerializer, new RowSerializerSnapshot(), nestedSnapshots);
        }
    }
}

