/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.state.StreamCompressionDecorator;
import org.apache.flink.runtime.util.NonClosingInputStreamDecorator;
import org.apache.flink.runtime.util.NonClosingOutpusStreamDecorator;
import org.xerial.snappy.SnappyFramedInputStream;
import org.xerial.snappy.SnappyFramedOutputStream;

@Internal
public class SnappyStreamCompressionDecorator
extends StreamCompressionDecorator {
    public static final StreamCompressionDecorator INSTANCE = new SnappyStreamCompressionDecorator();
    private static final long serialVersionUID = 1L;
    private static final int COMPRESSION_BLOCK_SIZE = 65536;
    private static final double MIN_COMPRESSION_RATIO = 0.85;

    @Override
    protected OutputStream decorateWithCompression(NonClosingOutpusStreamDecorator stream) throws IOException {
        return new SnappyFramedOutputStream((OutputStream)stream, 65536, 0.85);
    }

    @Override
    protected InputStream decorateWithCompression(NonClosingInputStreamDecorator stream) throws IOException {
        return new SnappyFramedInputStream((InputStream)stream, false);
    }
}

