/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.traversals;

import org.apache.flink.optimizer.dag.BinaryUnionNode;
import org.apache.flink.optimizer.dag.DagConnection;
import org.apache.flink.optimizer.dag.IterationNode;
import org.apache.flink.optimizer.dag.OptimizerNode;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.util.Visitor;

public class UnionParallelismAndForwardEnforcer
implements Visitor<OptimizerNode> {
    public boolean preVisit(OptimizerNode node) {
        if (node instanceof BinaryUnionNode) {
            int parallelism = -1;
            for (DagConnection conn : node.getOutgoingConnections()) {
                parallelism = conn.getTarget().getParallelism();
                conn.setShipStrategy(ShipStrategyType.FORWARD);
            }
            node.setParallelism(parallelism);
        }
        return true;
    }

    public void postVisit(OptimizerNode node) {
        if (node instanceof IterationNode) {
            ((IterationNode)((Object)node)).acceptForStepFunction(this);
        }
    }
}

