/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointIDCounter;

public class PerJobCheckpointRecoveryFactory<T extends CompletedCheckpointStore>
implements CheckpointRecoveryFactory {
    private final BiFunction<Integer, T, T> completedCheckpointStorePerJobFactory;
    private final Supplier<CheckpointIDCounter> checkpointIDCounterPerJobFactory;
    private final ConcurrentMap<JobID, T> store;
    private final ConcurrentMap<JobID, CheckpointIDCounter> counter;

    @VisibleForTesting
    public static <T extends CompletedCheckpointStore> CheckpointRecoveryFactory withoutCheckpointStoreRecovery(IntFunction<T> storeFn) {
        return new PerJobCheckpointRecoveryFactory<CompletedCheckpointStore>((maxCheckpoints, previous) -> {
            if (previous != null) {
                throw new UnsupportedOperationException("Checkpoint store recovery is not supported.");
            }
            return (CompletedCheckpointStore)storeFn.apply((int)maxCheckpoints);
        });
    }

    public PerJobCheckpointRecoveryFactory(BiFunction<Integer, T, T> completedCheckpointStorePerJobFactory) {
        this(completedCheckpointStorePerJobFactory, StandaloneCheckpointIDCounter::new);
    }

    public PerJobCheckpointRecoveryFactory(BiFunction<Integer, T, T> completedCheckpointStorePerJobFactory, Supplier<CheckpointIDCounter> checkpointIDCounterPerJobFactory) {
        this.completedCheckpointStorePerJobFactory = completedCheckpointStorePerJobFactory;
        this.checkpointIDCounterPerJobFactory = checkpointIDCounterPerJobFactory;
        this.store = new ConcurrentHashMap<JobID, T>();
        this.counter = new ConcurrentHashMap<JobID, CheckpointIDCounter>();
    }

    @Override
    public CompletedCheckpointStore createRecoveredCompletedCheckpointStore(JobID jobId, int maxNumberOfCheckpointsToRetain, ClassLoader userClassLoader) {
        return this.store.compute(jobId, (key, previous) -> (CompletedCheckpointStore)this.completedCheckpointStorePerJobFactory.apply(maxNumberOfCheckpointsToRetain, (Integer)((Object)previous)));
    }

    @Override
    public CheckpointIDCounter createCheckpointIDCounter(JobID jobId) {
        return this.counter.computeIfAbsent(jobId, jId -> this.checkpointIDCounterPerJobFactory.get());
    }
}

