/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.SimpleAccumulator;

@PublicEvolving
public class LongMinimum
implements SimpleAccumulator<Long> {
    private static final long serialVersionUID = 1L;
    private long min = Long.MAX_VALUE;

    public LongMinimum() {
    }

    public LongMinimum(long value) {
        this.min = value;
    }

    @Override
    public void add(Long value) {
        this.min = Math.min(this.min, value);
    }

    @Override
    public Long getLocalValue() {
        return this.min;
    }

    @Override
    public void merge(Accumulator<Long, Long> other) {
        this.min = Math.min(this.min, other.getLocalValue());
    }

    @Override
    public void resetLocal() {
        this.min = Long.MAX_VALUE;
    }

    public LongMinimum clone() {
        LongMinimum clone = new LongMinimum();
        clone.min = this.min;
        return clone;
    }

    @Override
    public void add(long value) {
        this.min = Math.min(this.min, value);
    }

    public long getLocalValuePrimitive() {
        return this.min;
    }

    public String toString() {
        return "LongMinimum " + this.min;
    }
}

