/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.ConfigGroup;
import org.apache.flink.annotation.docs.ConfigGroups;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.shaded.guava30.com.google.common.base.Splitter;
import org.apache.flink.shaded.guava30.com.google.common.collect.Iterables;

@ConfigGroups(groups={@ConfigGroup(name="Environment", keyPrefix="env")})
@PublicEvolving
public class CoreOptions {
    @Internal
    public static final String PARENT_FIRST_LOGGING_PATTERNS = "org.slf4j;org.apache.log4j;org.apache.logging;org.apache.commons.logging;ch.qos.logback";
    @Documentation.Section(value={"expert_class_loading"})
    public static final ConfigOption<String> CLASSLOADER_RESOLVE_ORDER = ConfigOptions.key("classloader.resolve-order").defaultValue("child-first").withDescription("Defines the class resolution strategy when loading classes from user code, meaning whether to first check the user code jar (\"child-first\") or the application classpath (\"parent-first\"). The default settings indicate to load classes first from the user code jar, which means that user code jars can include and load different dependencies than Flink uses (transitively).");
    @Documentation.Section(value={"expert_class_loading"})
    public static final ConfigOption<String> ALWAYS_PARENT_FIRST_LOADER_PATTERNS = ConfigOptions.key("classloader.parent-first-patterns.default").defaultValue("java.;scala.;org.apache.flink.;com.esotericsoftware.kryo;org.apache.hadoop.;javax.annotation.;org.xml;javax.xml;org.apache.xerces;org.w3c;org.rocksdb.;org.slf4j;org.apache.log4j;org.apache.logging;org.apache.commons.logging;ch.qos.logback").withDeprecatedKeys("classloader.parent-first-patterns").withDescription("A (semicolon-separated) list of patterns that specifies which classes should always be resolved through the parent ClassLoader first. A pattern is a simple prefix that is checked against the fully qualified class name. This setting should generally not be modified. To add another pattern we recommend to use \"classloader.parent-first-patterns.additional\" instead.");
    @Documentation.Section(value={"expert_class_loading"})
    public static final ConfigOption<String> ALWAYS_PARENT_FIRST_LOADER_PATTERNS_ADDITIONAL = ConfigOptions.key("classloader.parent-first-patterns.additional").defaultValue("").withDescription("A (semicolon-separated) list of patterns that specifies which classes should always be resolved through the parent ClassLoader first. A pattern is a simple prefix that is checked against the fully qualified class name. These patterns are appended to \"" + ALWAYS_PARENT_FIRST_LOADER_PATTERNS.key() + "\".");
    @Documentation.Section(value={"expert_class_loading"})
    public static final ConfigOption<Boolean> FAIL_ON_USER_CLASS_LOADING_METASPACE_OOM = ConfigOptions.key("classloader.fail-on-metaspace-oom-error").booleanType().defaultValue(true).withDescription("Fail Flink JVM processes if 'OutOfMemoryError: Metaspace' is thrown while trying to load a user code class.");
    @Documentation.Section(value={"expert_class_loading"})
    public static final ConfigOption<Boolean> CHECK_LEAKED_CLASSLOADER = ConfigOptions.key("classloader.check-leaked-classloader").booleanType().defaultValue(true).withDescription("Fails attempts at loading classes if the user classloader of a job is used after it has terminated.\nThis is usually caused by the classloader being leaked by lingering threads or misbehaving libraries, which may also result in the classloader being used by other jobs.\nThis check should only be disabled if such a leak prevents further jobs from running.");
    @Documentation.ExcludeFromDocumentation(value="Plugin classloader list is considered an implementation detail. Configuration only included in case to mitigate unintended side-effects of this young feature.")
    public static final ConfigOption<String> PLUGIN_ALWAYS_PARENT_FIRST_LOADER_PATTERNS = ConfigOptions.key("plugin.classloader.parent-first-patterns.default").stringType().defaultValue("java.;org.apache.flink.;javax.annotation.;org.slf4j;org.apache.log4j;org.apache.logging;org.apache.commons.logging;ch.qos.logback").withDescription("A (semicolon-separated) list of patterns that specifies which classes should always be resolved through the plugin parent ClassLoader first. A pattern is a simple prefix that is checked  against the fully qualified class name. This setting should generally not be modified. To add another  pattern we recommend to use \"plugin.classloader.parent-first-patterns.additional\" instead.");
    @Documentation.ExcludeFromDocumentation(value="Plugin classloader list is considered an implementation detail. Configuration only included in case to mitigate unintended side-effects of this young feature.")
    public static final ConfigOption<String> PLUGIN_ALWAYS_PARENT_FIRST_LOADER_PATTERNS_ADDITIONAL = ConfigOptions.key("plugin.classloader.parent-first-patterns.additional").stringType().defaultValue("").withDescription("A (semicolon-separated) list of patterns that specifies which classes should always be resolved through the plugin parent ClassLoader first. A pattern is a simple prefix that is checked  against the fully qualified class name. These patterns are appended to \"" + PLUGIN_ALWAYS_PARENT_FIRST_LOADER_PATTERNS.key() + "\".");
    public static final ConfigOption<String> FLINK_JVM_OPTIONS = ConfigOptions.key("env.java.opts").stringType().defaultValue("").withDescription(Description.builder().text("Java options to start the JVM of all Flink processes with.").build());
    public static final ConfigOption<String> FLINK_JM_JVM_OPTIONS = ConfigOptions.key("env.java.opts.jobmanager").stringType().defaultValue("").withDescription(Description.builder().text("Java options to start the JVM of the JobManager with.").build());
    public static final ConfigOption<String> FLINK_TM_JVM_OPTIONS = ConfigOptions.key("env.java.opts.taskmanager").stringType().defaultValue("").withDescription(Description.builder().text("Java options to start the JVM of the TaskManager with.").build());
    public static final ConfigOption<String> FLINK_HS_JVM_OPTIONS = ConfigOptions.key("env.java.opts.historyserver").stringType().defaultValue("").withDescription(Description.builder().text("Java options to start the JVM of the HistoryServer with.").build());
    public static final ConfigOption<String> FLINK_CLI_JVM_OPTIONS = ConfigOptions.key("env.java.opts.client").stringType().defaultValue("").withDescription(Description.builder().text("Java options to start the JVM of the Flink Client with.").build());
    public static final ConfigOption<String> FLINK_LOG_DIR = ConfigOptions.key("env.log.dir").noDefaultValue().withDescription("Defines the directory where the Flink logs are saved. It has to be an absolute path. (Defaults to the log directory under Flink\u2019s home)");
    public static final ConfigOption<String> FLINK_PID_DIR = ConfigOptions.key("env.pid.dir").defaultValue("/tmp").withDescription("Defines the directory where the flink-<host>-<process>.pid files are saved.");
    public static final ConfigOption<Integer> FLINK_LOG_MAX = ConfigOptions.key("env.log.max").defaultValue(5).withDescription("The maximum number of old log files to keep.");
    public static final ConfigOption<String> FLINK_SSH_OPTIONS = ConfigOptions.key("env.ssh.opts").noDefaultValue().withDescription("Additional command line options passed to SSH clients when starting or stopping JobManager, TaskManager, and Zookeeper services (start-cluster.sh, stop-cluster.sh, start-zookeeper-quorum.sh, stop-zookeeper-quorum.sh).");
    public static final ConfigOption<String> FLINK_HADOOP_CONF_DIR = ConfigOptions.key("env.hadoop.conf.dir").noDefaultValue().withDescription("Path to hadoop configuration directory. It is required to read HDFS and/or YARN configuration. You can also set it via environment variable.");
    public static final ConfigOption<String> FLINK_YARN_CONF_DIR = ConfigOptions.key("env.yarn.conf.dir").noDefaultValue().withDescription("Path to yarn configuration directory. It is required to run flink on YARN. You can also set it via environment variable.");
    public static final ConfigOption<String> FLINK_HBASE_CONF_DIR = ConfigOptions.key("env.hbase.conf.dir").noDefaultValue().withDescription("Path to hbase configuration directory. It is required to read HBASE configuration. You can also set it via environment variable.");
    @Documentation.OverrideDefault(value="'LOCAL_DIRS' on Yarn. System.getProperty(\"java.io.tmpdir\") in standalone.")
    @Documentation.Section(value={"common_miscellaneous"})
    public static final ConfigOption<String> TMP_DIRS = ConfigOptions.key("io.tmp.dirs").defaultValue(System.getProperty("java.io.tmpdir")).withDeprecatedKeys("taskmanager.tmp.dirs").withDescription("Directories for temporary files, separated by\",\", \"|\", or the system's java.io.File.pathSeparator.");
    public static final ConfigOption<Integer> DEFAULT_PARALLELISM = ConfigOptions.key("parallelism.default").defaultValue(1).withDescription("Default parallelism for jobs.");
    @Documentation.Section(value={"common_miscellaneous"})
    public static final ConfigOption<String> DEFAULT_FILESYSTEM_SCHEME = ConfigOptions.key("fs.default-scheme").noDefaultValue().withDescription("The default filesystem scheme, used for paths that do not declare a scheme explicitly. May contain an authority, e.g. host:port in case of an HDFS NameNode.");
    @Documentation.Section(value={"common_miscellaneous"})
    public static final ConfigOption<String> ALLOWED_FALLBACK_FILESYSTEMS = ConfigOptions.key("fs.allowed-fallback-filesystems").stringType().defaultValue("").withDescription("A (semicolon-separated) list of file schemes, for which Hadoop can be used instead of an appropriate Flink plugin. (example: s3;wasb)");
    @Documentation.Section(value={"deprecated_file_sinks"})
    public static final ConfigOption<Boolean> FILESYTEM_DEFAULT_OVERRIDE = ConfigOptions.key("fs.overwrite-files").defaultValue(false).withDescription("Specifies whether file output writers should overwrite existing files by default. Set to \"true\" to overwrite by default,\"false\" otherwise.");
    @Documentation.Section(value={"deprecated_file_sinks"})
    public static final ConfigOption<Boolean> FILESYSTEM_OUTPUT_ALWAYS_CREATE_DIRECTORY = ConfigOptions.key("fs.output.always-create-directory").defaultValue(false).withDescription("File writers running with a parallelism larger than one create a directory for the output file path and put the different result files (one per parallel writer task) into that directory. If this option is set to \"true\", writers with a parallelism of 1 will also create a directory and place a single result file into it. If the option is set to \"false\", the writer will directly create the file directly at the output path, without creating a containing directory.");

    public static String[] getParentFirstLoaderPatterns(Configuration config) {
        String base = config.getString(ALWAYS_PARENT_FIRST_LOADER_PATTERNS);
        String append = config.getString(ALWAYS_PARENT_FIRST_LOADER_PATTERNS_ADDITIONAL);
        return CoreOptions.parseParentFirstLoaderPatterns(base, append);
    }

    public static String[] getPluginParentFirstLoaderPatterns(Configuration config) {
        String base = config.getString(PLUGIN_ALWAYS_PARENT_FIRST_LOADER_PATTERNS);
        String append = config.getString(PLUGIN_ALWAYS_PARENT_FIRST_LOADER_PATTERNS_ADDITIONAL);
        return CoreOptions.parseParentFirstLoaderPatterns(base, append);
    }

    @Internal
    public static String[] parseParentFirstLoaderPatterns(String base, String append) {
        Splitter splitter = Splitter.on((char)';').omitEmptyStrings();
        return (String[])Iterables.toArray((Iterable)Iterables.concat((Iterable)splitter.split((CharSequence)base), (Iterable)splitter.split((CharSequence)append)), String.class);
    }

    public static ConfigOption<Integer> fileSystemConnectionLimit(String scheme) {
        return ConfigOptions.key("fs." + scheme + ".limit.total").defaultValue(-1);
    }

    public static ConfigOption<Integer> fileSystemConnectionLimitIn(String scheme) {
        return ConfigOptions.key("fs." + scheme + ".limit.input").defaultValue(-1);
    }

    public static ConfigOption<Integer> fileSystemConnectionLimitOut(String scheme) {
        return ConfigOptions.key("fs." + scheme + ".limit.output").defaultValue(-1);
    }

    public static ConfigOption<Long> fileSystemConnectionLimitTimeout(String scheme) {
        return ConfigOptions.key("fs." + scheme + ".limit.timeout").defaultValue(0L);
    }

    public static ConfigOption<Long> fileSystemConnectionLimitStreamInactivityTimeout(String scheme) {
        return ConfigOptions.key("fs." + scheme + ".limit.stream-timeout").defaultValue(0L);
    }
}

