/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.ReportLoader;

public class JRXmlLoader {
    public static final String EXCEPTION_MESSAGE_KEY_NO_LOADER = "xml.loader.unknown.subdataset";
    private final JasperReportsContext jasperReportsContext;
    private boolean ignoreConsistencyProblems;

    public JRXmlLoader(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public JasperReportsContext getJasperReportsContext() {
        return this.jasperReportsContext;
    }

    public static JasperDesign load(String sourceFileName) throws JRException {
        return JRXmlLoader.load((JasperReportsContext)DefaultJasperReportsContext.getInstance(), sourceFileName);
    }

    public static JasperDesign load(JasperReportsContext jasperReportsContext, String sourceFileName) throws JRException {
        return JRXmlLoader.load(jasperReportsContext, new File(sourceFileName));
    }

    public static JasperDesign load(File file) throws JRException {
        return JRXmlLoader.load((JasperReportsContext)DefaultJasperReportsContext.getInstance(), file);
    }

    public static JasperDesign load(JasperReportsContext jasperReportsContext, File file) throws JRException {
        JasperDesign jasperDesign = null;
        try (FileInputStream fis = new FileInputStream(file);){
            jasperDesign = JRXmlLoader.load(jasperReportsContext, fis);
        }
        catch (IOException e) {
            throw new JRException(e);
        }
        return jasperDesign;
    }

    public static JasperDesign load(InputStream is) throws JRException {
        return JRXmlLoader.load((JasperReportsContext)DefaultJasperReportsContext.getInstance(), is);
    }

    public static JasperDesign load(JasperReportsContext jasperReportsContext, InputStream is) throws JRException {
        JasperDesign jasperDesign = null;
        JRXmlLoader xmlLoader = new JRXmlLoader(jasperReportsContext);
        jasperDesign = xmlLoader.loadXML(is);
        return jasperDesign;
    }

    public JasperDesign loadXML(InputStream is) throws JRException {
        byte[] data = JRLoader.loadBytes(is);
        List<ReportLoader> loaders = this.jasperReportsContext.getExtensions(ReportLoader.class);
        for (ReportLoader reportLoader : loaders) {
            Optional<JasperDesign> report = reportLoader.loadReport(this.jasperReportsContext, data);
            if (!report.isPresent()) continue;
            return report.get();
        }
        throw new JRException("Unable to load report");
    }

    public boolean isIgnoreConsistencyProblems() {
        return this.ignoreConsistencyProblems;
    }

    public void setIgnoreConsistencyProblems(boolean ignoreConsistencyProblems) {
        this.ignoreConsistencyProblems = ignoreConsistencyProblems;
    }
}

