/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.jsr223;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.jsr223.AbstractGremlinPlugin;
import org.apache.tinkerpop.gremlin.jsr223.DefaultImportCustomizer;

public final class ImportGremlinPlugin
extends AbstractGremlinPlugin {
    private static final String NAME = "tinkerpop.import";

    private ImportGremlinPlugin(Builder builder) {
        super(NAME, builder.appliesTo, DefaultImportCustomizer.build().addClassImports(builder.classImports).addEnumImports(builder.enumImports).addMethodImports(builder.methodImports).addFieldImports(builder.fieldImports).create());
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class Builder {
        private static final Pattern METHOD_PATTERN = Pattern.compile("(.*)#(.*)\\((.*)\\)");
        private static final Pattern ENUM_PATTERN = Pattern.compile("(.*)#(.*)");
        private Set<Field> fieldImports = new HashSet<Field>();
        private Set<Class> classImports = new HashSet<Class>();
        private Set<Method> methodImports = new HashSet<Method>();
        private Set<Enum> enumImports = new HashSet<Enum>();
        private final Set<String> appliesTo = new HashSet<String>();

        private Builder() {
        }

        public Builder appliesTo(Collection<String> scriptEngineName) {
            this.appliesTo.addAll(scriptEngineName);
            return this;
        }

        public Builder classImports(Class<?> ... classes) {
            this.classImports.addAll(Arrays.asList(classes));
            return this;
        }

        public Builder classImports(Collection<String> classes) {
            for (String clazz : classes) {
                try {
                    this.classImports.add(Class.forName(clazz));
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
            return this;
        }

        public Builder methodImports(Collection<String> methods) {
            for (String method : methods) {
                try {
                    if (method.endsWith("#*")) {
                        String classString = method.substring(0, method.length() - 2);
                        Class<?> clazz = Class.forName(classString);
                        this.methodImports.addAll(Builder.allStaticMethods(clazz));
                        continue;
                    }
                    Matcher matcher = METHOD_PATTERN.matcher(method);
                    if (!matcher.matches()) {
                        throw new IllegalArgumentException(String.format("Could not read method descriptor - check format of: %s", method));
                    }
                    String classString = matcher.group(1);
                    String methodString = matcher.group(2);
                    String argString = matcher.group(3);
                    Class<?> clazz = Class.forName(classString);
                    this.methodImports.add(clazz.getMethod(methodString, Builder.parse(argString)));
                }
                catch (IllegalArgumentException iae) {
                    throw iae;
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
            return this;
        }

        public Builder methodImports(Method ... methods) {
            this.methodImports.addAll(Arrays.asList(methods));
            return this;
        }

        public Builder enumImports(Collection<String> enums) {
            for (String enumItem : enums) {
                try {
                    if (enumItem.endsWith("#*")) {
                        String classString = enumItem.substring(0, enumItem.length() - 2);
                        Class<?> clazz = Class.forName(classString);
                        this.enumImports.addAll(Builder.allEnums(clazz));
                        continue;
                    }
                    Matcher matcher = ENUM_PATTERN.matcher(enumItem);
                    if (!matcher.matches()) {
                        throw new IllegalArgumentException(String.format("Could not read enum descriptor - check format of: %s", enumItem));
                    }
                    String classString = matcher.group(1);
                    String enumValString = matcher.group(2);
                    Class<?> clazz = Class.forName(classString);
                    Stream.of(clazz.getEnumConstants()).filter(e -> ((Enum)e).name().equals(enumValString)).findFirst().ifPresent(e -> this.enumImports.add((Enum)e));
                }
                catch (IllegalArgumentException iae) {
                    throw iae;
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
            return this;
        }

        public Builder enumImports(Enum ... enums) {
            this.enumImports.addAll(Arrays.asList(enums));
            return this;
        }

        public Builder fieldsImports(Collection<String> fields) {
            for (String fieldItem : fields) {
                try {
                    if (fieldItem.endsWith("#*")) {
                        String classString = fieldItem.substring(0, fieldItem.length() - 2);
                        Class<?> clazz = Class.forName(classString);
                        this.fieldImports.addAll(Builder.allStaticFields(clazz));
                        continue;
                    }
                    Matcher matcher = ENUM_PATTERN.matcher(fieldItem);
                    if (!matcher.matches()) {
                        throw new IllegalArgumentException(String.format("Could not read field descriptor - check format of: %s", fieldItem));
                    }
                    String classString = matcher.group(1);
                    String fieldName = matcher.group(2);
                    Class<?> clazz = Class.forName(classString);
                    this.fieldImports.add(clazz.getField(fieldName));
                }
                catch (IllegalArgumentException iae) {
                    throw iae;
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
            return this;
        }

        public Builder fieldsImports(Field ... fields) {
            this.fieldImports.addAll(Arrays.asList(fields));
            return this;
        }

        public ImportGremlinPlugin create() {
            if (this.enumImports.isEmpty() && this.classImports.isEmpty() && this.methodImports.isEmpty() && this.fieldImports.isEmpty()) {
                throw new IllegalStateException("At least one import must be specified");
            }
            return new ImportGremlinPlugin(this);
        }

        private static List<Enum> allEnums(Class<?> clazz) {
            return Stream.of(clazz.getEnumConstants()).map(e -> (Enum)e).collect(Collectors.toList());
        }

        private static List<Method> allStaticMethods(Class<?> clazz) {
            return Stream.of(clazz.getMethods()).filter(m -> Modifier.isStatic(m.getModifiers())).collect(Collectors.toList());
        }

        private static List<Field> allStaticFields(Class<?> clazz) {
            return Stream.of(clazz.getFields()).filter(f -> Modifier.isStatic(f.getModifiers())).collect(Collectors.toList());
        }

        private static Class<?>[] parse(String argString) {
            if (null == argString || argString.isEmpty()) {
                return new Class[0];
            }
            List args = Stream.of(argString.split(",")).map(String::trim).collect(Collectors.toList());
            Class[] classes = new Class[args.size()];
            for (int ix = 0; ix < args.size(); ++ix) {
                try {
                    classes[ix] = Class.forName((String)args.get(ix));
                    continue;
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
            return classes;
        }
    }
}

