/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.lang.model.SourceVersion;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.SackFunctions;
import org.apache.tinkerpop.gremlin.process.traversal.TextP;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.OptionsStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversal;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.DatetimeHelper;
import org.apache.tinkerpop.gremlin.util.NumberHelper;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class GremlinLang
implements Cloneable,
Serializable {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private StringBuilder gremlin = new StringBuilder();
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private static final AtomicInteger paramCount = new AtomicInteger(0);
    private List<OptionsStrategy> optionsStrategies = new ArrayList<OptionsStrategy>();

    public GremlinLang() {
    }

    public GremlinLang(String sourceName, Object ... arguments) {
        this.addToGremlin(sourceName, arguments);
    }

    private void addToGremlin(String name, Object ... arguments) {
        Object[] flattenedArguments = this.flattenArguments(arguments);
        if ("CardinalityValueTraversal".equals(name)) {
            this.gremlin.append("Cardinality.").append(flattenedArguments[0]).append("(").append(flattenedArguments[1]).append(")");
            return;
        }
        this.gremlin.append(".").append(name).append('(');
        for (int i = 0; i < flattenedArguments.length; ++i) {
            if (i != 0) {
                this.gremlin.append(',');
            }
            this.gremlin.append(this.argAsString(flattenedArguments[i]));
        }
        this.gremlin.append(')');
    }

    private String argAsString(Object arg) {
        if (arg == null) {
            return "null";
        }
        if (arg instanceof String) {
            return String.format("\"%s\"", StringEscapeUtils.escapeJava((String)((String)arg)));
        }
        if (arg instanceof Boolean) {
            return arg.toString();
        }
        if (arg instanceof Byte) {
            return String.format("%sB", arg);
        }
        if (arg instanceof Short) {
            return String.format("%sS", arg);
        }
        if (arg instanceof Integer) {
            return arg.toString();
        }
        if (arg instanceof Long) {
            return String.format("%sL", arg);
        }
        if (arg instanceof BigInteger) {
            return String.format("%sN", arg);
        }
        if (arg instanceof Float) {
            if (NumberHelper.isNaN(arg)) {
                return "NaN";
            }
            if (NumberHelper.isPositiveInfinity(arg)) {
                return "+Infinity";
            }
            if (NumberHelper.isNegativeInfinity(arg)) {
                return "-Infinity";
            }
            return String.format("%sF", arg);
        }
        if (arg instanceof Double) {
            if (NumberHelper.isNaN(arg)) {
                return "NaN";
            }
            if (NumberHelper.isPositiveInfinity(arg)) {
                return "+Infinity";
            }
            if (NumberHelper.isNegativeInfinity(arg)) {
                return "-Infinity";
            }
            return String.format("%sD", arg);
        }
        if (arg instanceof BigDecimal) {
            return String.format("%sM", arg);
        }
        if (arg instanceof OffsetDateTime) {
            return String.format("datetime(\"%s\")", DatetimeHelper.format(((OffsetDateTime)arg).toInstant()));
        }
        if (arg instanceof Enum) {
            if (arg instanceof T) {
                return String.format("T.%s", arg);
            }
            if (arg instanceof Order) {
                return String.format("Order.%s", arg);
            }
            if (arg instanceof Column) {
                return String.format("Column.%s", arg);
            }
            if (arg instanceof Operator) {
                return String.format("Operator.%s", arg);
            }
            if (arg instanceof SackFunctions.Barrier) {
                return String.format("Barrier.%s", arg);
            }
            return String.format("%s.%s", arg.getClass().getSimpleName(), arg);
        }
        if (arg instanceof Vertex) {
            return String.format("new ReferenceVertex(%s,\"%s\")", this.argAsString(((Vertex)arg).id()), ((Vertex)arg).label());
        }
        if (arg instanceof P) {
            return this.asString((P)arg);
        }
        if (arg instanceof GremlinLang || arg instanceof DefaultTraversal) {
            GremlinLang gremlinLang = arg instanceof GremlinLang ? (GremlinLang)arg : ((DefaultTraversal)arg).getGremlinLang();
            this.parameters.putAll(gremlinLang.getParameters());
            return gremlinLang.getGremlin("__");
        }
        if (arg instanceof GValue) {
            GValue gValue = (GValue)arg;
            String key = gValue.getName();
            if (key == null) {
                return this.argAsString(((GValue)arg).get());
            }
            if (!SourceVersion.isIdentifier(key)) {
                throw new IllegalArgumentException(String.format("Invalid parameter name [%s].", key));
            }
            if (this.parameters.containsKey(key)) {
                if (!Objects.equals(this.parameters.get(key), gValue.get())) {
                    throw new IllegalArgumentException(String.format("Parameter with name [%s] already defined.", key));
                }
            } else {
                this.parameters.put(key, gValue.get());
            }
            return key;
        }
        if (arg instanceof Map) {
            return this.asString((Map)arg);
        }
        if (arg instanceof Set) {
            return this.asString((Set)arg);
        }
        if (arg instanceof List || arg instanceof Object[] || arg.getClass().isArray()) {
            return this.asString(IteratorUtils.asIterator(arg));
        }
        if (arg instanceof Class) {
            return ((Class)arg).getSimpleName();
        }
        return this.asParameter(arg);
    }

    private String asParameter(Object arg) {
        String paramName = String.format("_%d", paramCount.getAndIncrement());
        this.parameters.put(paramName, arg);
        return paramName;
    }

    private String asString(Iterator itty) {
        StringBuilder sb = new StringBuilder().append("[");
        while (itty.hasNext()) {
            sb.append(this.argAsString(itty.next()));
            if (!itty.hasNext()) continue;
            sb.append(",");
        }
        return sb.append("]").toString();
    }

    private String asString(Set<?> set) {
        StringBuilder sb = new StringBuilder().append("{");
        Iterator itty = IteratorUtils.asIterator(set);
        while (itty.hasNext()) {
            sb.append(this.argAsString(itty.next()));
            if (!itty.hasNext()) continue;
            sb.append(",");
        }
        return sb.append("}").toString();
    }

    private String asString(P<?> p) {
        StringBuilder sb = new StringBuilder();
        if (p instanceof TextP) {
            sb.append("TextP.").append(p.getPredicateName()).append("(");
            sb.append(this.argAsString(p.getValue()));
        } else if (p instanceof ConnectiveP) {
            List list = ((ConnectiveP)p).getPredicates();
            String connector = p.getPredicateName();
            for (int i = 0; i < list.size(); ++i) {
                sb.append(this.argAsString(list.get(i)));
                if (i > 0 && i < list.size() - 1) {
                    sb.append(")");
                }
                if (i >= list.size() - 1) continue;
                sb.append(".").append(connector).append("(");
            }
        } else {
            sb.append("P.").append(p.getPredicateName()).append("(");
            sb.append(this.argAsString(p.getValue()));
        }
        sb.append(")");
        return sb.toString();
    }

    private String asString(Map<?, ?> map) {
        StringBuilder sb = new StringBuilder("[");
        int size = map.size();
        if (size == 0) {
            sb.append(":");
        } else {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                String key = this.argAsString(entry.getKey());
                if (entry.getKey() instanceof Enum && key.contains(".")) {
                    key = String.format("(%s)", key);
                }
                sb.append(key).append(":").append(this.argAsString(entry.getValue()));
                if (--size <= 0) continue;
                sb.append(',');
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public String getGremlin() {
        return this.getGremlin("g");
    }

    public String getGremlin(String g) {
        if (this.gremlin.length() != 0 && this.gremlin.charAt(0) != '.') {
            return this.gremlin.toString();
        }
        return g + this.gremlin;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void addG(String g) {
        this.parameters.put("g", g);
    }

    public void reset() {
        paramCount.set(0);
    }

    public void addSource(String sourceName, Object ... arguments) {
        if (sourceName.equals("withStrategies") && arguments.length != 0) {
            String args = this.buildStrategyArgs(arguments);
            if (!args.isEmpty()) {
                this.gremlin.append('.').append("withStrategies").append('(').append(args).append(')');
            }
            return;
        }
        this.addToGremlin(sourceName, arguments);
    }

    private String buildStrategyArgs(Object[] arguments) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arguments.length; ++i) {
            String strategyName;
            Configuration configuration;
            if (arguments[i] instanceof OptionsStrategy) {
                this.optionsStrategies.add((OptionsStrategy)arguments[i]);
                break;
            }
            if (arguments[i] instanceof TraversalStrategyProxy) {
                configuration = ((TraversalStrategy)arguments[i]).getConfiguration();
                strategyName = ((TraversalStrategyProxy)arguments[i]).getStrategyName();
            } else {
                configuration = ((TraversalStrategy)arguments[i]).getConfiguration();
                strategyName = arguments[i].getClass().getSimpleName();
            }
            if (configuration.isEmpty()) {
                sb.append(strategyName);
            } else {
                sb.append("new ").append(strategyName).append("(");
                configuration.getKeys().forEachRemaining(key -> {
                    if (!key.equals("strategy")) {
                        sb.append((String)key).append(":").append(this.argAsString(configuration.getProperty(key))).append(",");
                    }
                });
                if (sb.lastIndexOf(",") == sb.length() - 1) {
                    sb.setLength(sb.length() - 1);
                }
                sb.append(')');
            }
            if (i == arguments.length - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public void addStep(String stepName, Object ... arguments) {
        this.addToGremlin(stepName, arguments);
    }

    public List<OptionsStrategy> getOptionsStrategies() {
        return this.optionsStrategies;
    }

    public boolean isEmpty() {
        return this.gremlin.length() == 0;
    }

    public String toString() {
        return this.gremlin.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GremlinLang gremlinLang = (GremlinLang)o;
        return Objects.equals(this.gremlin.toString(), gremlinLang.gremlin.toString()) && Objects.equals(this.parameters, gremlinLang.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.gremlin, this.parameters);
    }

    public GremlinLang clone() {
        try {
            GremlinLang clone = (GremlinLang)super.clone();
            clone.parameters = new HashMap<String, Object>(this.parameters);
            clone.gremlin = new StringBuilder(this.gremlin.length());
            clone.gremlin.append((CharSequence)this.gremlin);
            clone.optionsStrategies = new ArrayList<OptionsStrategy>(this.optionsStrategies);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private Object[] flattenArguments(Object ... arguments) {
        if (arguments == null || arguments.length == 0) {
            return EMPTY_ARRAY;
        }
        ArrayList<Object> flatArguments = new ArrayList<Object>(arguments.length);
        for (Object object : arguments) {
            if (object instanceof Object[]) {
                for (Object nestObject : (Object[])object) {
                    flatArguments.add(this.convertArgument(nestObject));
                }
                continue;
            }
            flatArguments.add(this.convertArgument(object));
        }
        return flatArguments.toArray();
    }

    private Object convertArgument(Object argument) {
        if (argument instanceof Traversal) {
            if (((Traversal)argument).asAdmin().getTraversalSource().isPresent()) {
                throw new IllegalStateException(String.format("The child traversal of %s was not spawned anonymously - use the __ class rather than a TraversalSource to construct the child traversal", argument));
            }
            return ((Traversal)argument).asAdmin().getGremlinLang();
        }
        if (argument instanceof Map) {
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(((Map)argument).size());
            for (Map.Entry entry : ((Map)argument).entrySet()) {
                map.put(this.convertArgument(entry.getKey()), this.convertArgument(entry.getValue()));
            }
            return map;
        }
        if (argument instanceof List) {
            ArrayList<Object> list = new ArrayList<Object>(((List)argument).size());
            for (Object item : (List)argument) {
                list.add(this.convertArgument(item));
            }
            return list;
        }
        if (argument instanceof Set) {
            LinkedHashSet<Object> set = new LinkedHashSet<Object>(((Set)argument).size());
            for (Object item : (Set)argument) {
                set.add(this.convertArgument(item));
            }
            return set;
        }
        return argument;
    }
}

