/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class BulkSetSerializer
extends SimpleTypeSerializer<BulkSet> {
    public BulkSetSerializer() {
        super(DataType.LIST);
    }

    @Override
    protected BulkSet readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        throw new UnsupportedOperationException("BulkSet is used as an internal serializer for bulk lists, deserializing into BulkSet is not supported");
    }

    @Override
    protected void writeValue(BulkSet value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        Map raw = value.asBulk();
        buffer.writeInt(raw.size());
        for (Object key : raw.keySet()) {
            context.write(key, buffer);
            buffer.writeLong(value.get(key));
        }
    }
}

