/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.detached;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;

public abstract class DetachedElement<E>
implements Element,
Serializable,
Attachable<E> {
    protected Object id;
    protected String label;
    protected Map<String, List<Property>> properties = null;

    protected DetachedElement() {
    }

    protected DetachedElement(Element element) {
        this.id = element.id();
        try {
            this.label = element.label();
        }
        catch (UnsupportedOperationException e) {
            this.label = "vertex";
        }
    }

    protected DetachedElement(Object id, String label) {
        this.id = id;
        this.label = label;
    }

    @Override
    public Graph graph() {
        return EmptyGraph.instance();
    }

    @Override
    public Object id() {
        return this.id;
    }

    @Override
    public String label() {
        return this.label;
    }

    @Override
    public <V> Property<V> property(String key, V value) {
        throw Element.Exceptions.propertyAdditionNotSupported();
    }

    @Override
    public <V> Property<V> property(String key) {
        return null != this.properties && this.properties.containsKey(key) ? this.properties.get(key).get(0) : Property.empty();
    }

    public int hashCode() {
        return ElementHelper.hashCode(this);
    }

    public boolean equals(Object object) {
        return ElementHelper.areEqual(this, object);
    }

    @Override
    public <V> Iterator<? extends Property<V>> properties(String ... propertyKeys) {
        return null == this.properties ? Collections.emptyIterator() : this.properties.entrySet().stream().filter(entry -> ElementHelper.keyExists((String)entry.getKey(), propertyKeys)).flatMap(entry -> ((List)entry.getValue()).stream()).iterator();
    }

    @Override
    public E get() {
        return (E)this;
    }

    abstract void internalAddProperty(Property var1);
}

