/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context;

import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.component.visit.MyFacesVisitHints;
import org.apache.myfaces.context.RequestViewMetadata;

public class RequestViewContext {
    public static final String VIEW_CONTEXT_KEY = "oam.VIEW_CONTEXT";
    public static final String RESOURCE_DEPENDENCY_INSPECTED_CLASS = "oam.RDClass";
    private RequestViewMetadata requestViewMetadata = new RequestViewMetadata();
    private Map<String, Boolean> renderTargetMap = null;
    private Map<String, List<UIComponent>> renderTargetMapComponents = null;

    public RequestViewContext() {
    }

    public RequestViewContext(RequestViewMetadata rvm) {
    }

    public static RequestViewContext getCurrentInstance() {
        return RequestViewContext.getCurrentInstance(FacesContext.getCurrentInstance());
    }

    public static RequestViewContext getCurrentInstance(FacesContext ctx) {
        return RequestViewContext.getCurrentInstance(ctx, ctx.getViewRoot());
    }

    public static RequestViewContext getCurrentInstance(FacesContext ctx, UIViewRoot root) {
        return RequestViewContext.getCurrentInstance(ctx, root, true);
    }

    public static RequestViewContext getCurrentInstance(FacesContext ctx, UIViewRoot root, boolean create) {
        HashMap<UIViewRoot, RequestViewContext> map = (HashMap<UIViewRoot, RequestViewContext>)ctx.getAttributes().get(VIEW_CONTEXT_KEY);
        if (create && map == null) {
            map = new HashMap<UIViewRoot, RequestViewContext>(5);
            ctx.getAttributes().put(VIEW_CONTEXT_KEY, map);
        }
        if (map != null) {
            RequestViewContext rvc = (RequestViewContext)map.get(root);
            if (create && rvc == null) {
                rvc = new RequestViewContext();
                map.put(root, rvc);
            }
            return rvc;
        }
        return null;
    }

    public static RequestViewContext newInstance(RequestViewMetadata rvm) {
        RequestViewContext clone = new RequestViewContext(rvm.cloneInstance());
        return clone;
    }

    public static void setCurrentInstance(FacesContext ctx, UIViewRoot root, RequestViewContext rvc) {
        Map map = (Map)ctx.getAttributes().computeIfAbsent(VIEW_CONTEXT_KEY, k -> new HashMap());
        map.put(root, rvc);
    }

    public boolean isResourceDependencyAlreadyProcessed(ResourceDependency dependency) {
        return this.requestViewMetadata.isResourceDependencyAlreadyProcessed(dependency);
    }

    public void setResourceDependencyAsProcessed(ResourceDependency dependency) {
        this.requestViewMetadata.setResourceDependencyAsProcessed(dependency);
    }

    public boolean isClassAlreadyProcessed(Class<?> inspectedClass) {
        return this.requestViewMetadata.isClassAlreadyProcessed(inspectedClass);
    }

    public void setClassProcessed(Class<?> inspectedClass) {
        this.requestViewMetadata.setClassProcessed(inspectedClass);
    }

    public boolean isRenderTarget(String target) {
        if (this.renderTargetMap != null) {
            return Boolean.TRUE.equals(this.renderTargetMap.get(target));
        }
        return false;
    }

    public void setRenderTarget(String target, boolean value, UIComponent component) {
        List componentList;
        if (this.renderTargetMap == null) {
            this.renderTargetMap = new HashMap<String, Boolean>(8);
        }
        this.renderTargetMap.put(target, value);
        if (this.renderTargetMapComponents == null) {
            this.renderTargetMapComponents = new HashMap<String, List<UIComponent>>(8);
        }
        if (!(componentList = this.renderTargetMapComponents.computeIfAbsent(target, k -> new ArrayList(8))).contains(component)) {
            componentList.add(component);
        }
    }

    public List<UIComponent> getRenderTargetComponentList(String target) {
        if (this.renderTargetMapComponents == null) {
            return Collections.emptyList();
        }
        List<UIComponent> list = this.renderTargetMapComponents.get(target);
        return list != null ? list : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRequestViewContext(FacesContext facesContext, UIViewRoot root) {
        RefreshViewContextCallback callback = null;
        for (Map.Entry entry : root.getFacets().entrySet()) {
            UIComponent facet = (UIComponent)entry.getValue();
            if (facet.getId() == null || !facet.getId().startsWith("jakarta_faces_location_")) continue;
            try {
                facesContext.getAttributes().put("jakarta.faces.visit.SKIP_ITERATION", Boolean.TRUE);
                if (callback == null) {
                    callback = new RefreshViewContextCallback();
                }
                VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, MyFacesVisitHints.SET_SKIP_ITERATION);
                facet.visitTree(visitContext, (VisitCallback)callback);
            }
            finally {
                facesContext.getAttributes().remove("jakarta.faces.visit.SKIP_ITERATION");
            }
        }
    }

    public RequestViewMetadata getRequestViewMetadata() {
        return this.requestViewMetadata;
    }

    public void setRequestViewMetadata(RequestViewMetadata requestViewMetadata) {
        this.requestViewMetadata = requestViewMetadata;
    }

    private class RefreshViewContextCallback
    implements VisitCallback {
        private RefreshViewContextCallback() {
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            Class inspectedClass = (Class)target.getAttributes().get(RequestViewContext.RESOURCE_DEPENDENCY_INSPECTED_CLASS);
            if (inspectedClass != null) {
                RequestViewContext.this.setClassProcessed(inspectedClass);
            }
            return VisitResult.ACCEPT;
        }
    }
}

