/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.composite;

import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import jakarta.faces.view.facelets.TagHandler;
import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentBeanInfo;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentPropertyDescriptor;
import org.apache.myfaces.view.facelets.tag.composite.CompositeTagAttributeUtils;
import org.apache.myfaces.view.facelets.tag.composite.InterfaceDescriptorCreator;

public class FacetHandler
extends TagHandler
implements InterfaceDescriptorCreator {
    private static final Logger log = Logger.getLogger(FacetHandler.class.getName());
    private static final String[] STANDARD_ATTRIBUTES_SORTED = new String[]{"displayName", "expert", "hidden", "name", "preferred", "required", "shortDescription"};
    private final TagAttribute _name = this.getRequiredAttribute("name");
    private final TagAttribute _displayName = this.getAttribute("displayName");
    private final TagAttribute _required = this.getAttribute("required");
    private final TagAttribute _preferred = this.getAttribute("preferred");
    private final TagAttribute _expert = this.getAttribute("expert");
    private final TagAttribute _shortDescription = this.getAttribute("shortDescription");
    protected final TagAttribute _hidden = this.getAttribute("hidden");
    private boolean _cacheable;
    private PropertyDescriptor _propertyDescriptor;

    public FacetHandler(TagConfig config) {
        super(config);
        boolean development = FacesContext.getCurrentInstance().isProjectStage(ProjectStage.Development);
        if (this._name.isLiteral() && (!development || this._areDevelopmentAttributesLiteral())) {
            this._cacheable = true;
            if (this._required == null && !CompositeTagAttributeUtils.containsUnspecifiedAttributes(this.tag, STANDARD_ATTRIBUTES_SORTED)) {
                this._propertyDescriptor = this._createFacetPropertyDescriptor(development);
            }
        } else {
            this._cacheable = false;
        }
    }

    private boolean _areDevelopmentAttributesLiteral() {
        return CompositeTagAttributeUtils.areAttributesLiteral(this._displayName, this._shortDescription, this._expert, this._hidden, this._preferred);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        CompositeComponentBeanInfo beanInfo = (CompositeComponentBeanInfo)parent.getAttributes().get("jakarta.faces.component.BEANINFO_KEY");
        if (beanInfo == null) {
            if (log.isLoggable(Level.SEVERE)) {
                log.severe("Cannot find composite bean descriptor UIComponent.BEANINFO_KEY ");
            }
            return;
        }
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        HashMap<String, PropertyDescriptor> facetPropertyDescriptorMap = (HashMap<String, PropertyDescriptor>)beanDescriptor.getValue("jakarta.faces.component.FACETS_KEY");
        if (facetPropertyDescriptorMap == null) {
            facetPropertyDescriptorMap = new HashMap<String, PropertyDescriptor>(5);
            beanDescriptor.setValue("jakarta.faces.component.FACETS_KEY", facetPropertyDescriptorMap);
        }
        String facetName = this._name.getValue(ctx);
        if (this.isCacheable()) {
            if (this._propertyDescriptor == null) {
                this._propertyDescriptor = this._createFacetPropertyDescriptor(facetName, ctx);
            }
            facetPropertyDescriptorMap.put(facetName, this._propertyDescriptor);
        } else {
            PropertyDescriptor facetDescriptor = this._createFacetPropertyDescriptor(facetName, ctx);
            facetPropertyDescriptorMap.put(facetName, facetDescriptor);
        }
        this.nextHandler.apply(ctx, parent);
    }

    private PropertyDescriptor _createFacetPropertyDescriptor(boolean development) {
        try {
            CompositeComponentPropertyDescriptor facetPropertyDescriptor = new CompositeComponentPropertyDescriptor(this._name.getValue());
            if (development) {
                CompositeTagAttributeUtils.addDevelopmentAttributesLiteral(facetPropertyDescriptor, this._displayName, this._shortDescription, this._expert, this._hidden, this._preferred);
            }
            return facetPropertyDescriptor;
        }
        catch (IntrospectionException e) {
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, "Cannot create PropertyDescriptor for facet ", e);
            }
            throw new TagException(this.tag, (Throwable)e);
        }
    }

    private PropertyDescriptor _createFacetPropertyDescriptor(String facetName, FaceletContext ctx) throws TagException, IOException {
        try {
            CompositeComponentPropertyDescriptor facetPropertyDescriptor = new CompositeComponentPropertyDescriptor(facetName);
            if (this._required != null) {
                facetPropertyDescriptor.setValue("required", this._required.getValueExpression(ctx, Boolean.class));
            }
            if (ctx.getFacesContext().isProjectStage(ProjectStage.Development)) {
                CompositeTagAttributeUtils.addDevelopmentAttributes(facetPropertyDescriptor, ctx, this._displayName, this._shortDescription, this._expert, this._hidden, this._preferred);
            }
            CompositeTagAttributeUtils.addUnspecifiedAttributes(facetPropertyDescriptor, this.tag, STANDARD_ATTRIBUTES_SORTED, ctx);
            return facetPropertyDescriptor;
        }
        catch (IntrospectionException e) {
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, "Cannot create PropertyDescriptor for attribute ", e);
            }
            throw new TagException(this.tag, (Throwable)e);
        }
    }

    @Override
    public boolean isCacheable() {
        return this._cacheable;
    }

    @Override
    public void setCacheable(boolean cacheable) {
        this._cacheable = cacheable;
    }
}

