/*
 * Decompiled with CFR 0.152.
 */
package jakarta.enterprise.lang.model.declarations;

import jakarta.enterprise.lang.model.AnnotationTarget;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.FieldInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import jakarta.enterprise.lang.model.declarations.PackageInfo;
import jakarta.enterprise.lang.model.declarations.ParameterInfo;
import jakarta.enterprise.lang.model.declarations.RecordComponentInfo;
import jakarta.enterprise.lang.model.types.Type;

public interface DeclarationInfo
extends AnnotationTarget {
    @Override
    default public boolean isDeclaration() {
        return true;
    }

    @Override
    default public boolean isType() {
        return false;
    }

    @Override
    default public DeclarationInfo asDeclaration() {
        return this;
    }

    @Override
    default public Type asType() {
        throw new IllegalStateException("Not a type");
    }

    public Kind kind();

    default public boolean isPackage() {
        return this.kind() == Kind.PACKAGE;
    }

    default public boolean isClass() {
        return this.kind() == Kind.CLASS;
    }

    default public boolean isMethod() {
        return this.kind() == Kind.METHOD;
    }

    default public boolean isParameter() {
        return this.kind() == Kind.PARAMETER;
    }

    default public boolean isField() {
        return this.kind() == Kind.FIELD;
    }

    default public boolean isRecordComponent() {
        return this.kind() == Kind.RECORD_COMPONENT;
    }

    default public PackageInfo asPackage() {
        throw new IllegalStateException("Not a package");
    }

    default public ClassInfo asClass() {
        throw new IllegalStateException("Not a class");
    }

    default public MethodInfo asMethod() {
        throw new IllegalStateException("Not a method");
    }

    default public ParameterInfo asParameter() {
        throw new IllegalStateException("Not a parameter");
    }

    default public FieldInfo asField() {
        throw new IllegalStateException("Not a field");
    }

    default public RecordComponentInfo asRecordComponent() {
        throw new IllegalStateException("Not a record component");
    }

    public static enum Kind {
        PACKAGE,
        CLASS,
        METHOD,
        PARAMETER,
        FIELD,
        RECORD_COMPONENT;

    }
}

