/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow;

import jakarta.el.MethodExpression;
import jakarta.faces.application.NavigationCase;
import jakarta.faces.context.FacesContext;
import jakarta.faces.flow.Flow;
import jakarta.faces.flow.FlowCallNode;
import jakarta.faces.flow.FlowNode;
import jakarta.faces.flow.MethodCallNode;
import jakarta.faces.flow.Parameter;
import jakarta.faces.flow.ReturnNode;
import jakarta.faces.flow.SwitchNode;
import jakarta.faces.flow.ViewNode;
import jakarta.faces.lifecycle.ClientWindow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.flow.Freezable;

public class FlowImpl
extends Flow
implements Freezable {
    private MethodExpression _initializer;
    private MethodExpression _finalizer;
    private String _startNodeId;
    private String _id;
    private String _definingDocumentId;
    private Map<String, FlowNode> _flowNodeMap = new HashMap<String, FlowNode>();
    private Map<String, Parameter> _inboundParametersMap = new HashMap<String, Parameter>();
    private Map<String, FlowCallNode> _flowCallsMap = new HashMap<String, FlowCallNode>();
    private List<MethodCallNode> _methodCallsList = new ArrayList<MethodCallNode>();
    private Map<String, ReturnNode> _returnsMap = new HashMap<String, ReturnNode>();
    private Map<String, SwitchNode> _switchesMap = new HashMap<String, SwitchNode>();
    private List<ViewNode> _viewsList = new ArrayList<ViewNode>();
    private Map<String, Parameter> _unmodifiableInboundParametersMap;
    private Map<String, FlowCallNode> _unmodifiableFlowCallsMap;
    private List<MethodCallNode> _unmodifiableMethodCallsList;
    private Map<String, ReturnNode> _unmodifiableReturnsMap;
    private Map<String, SwitchNode> _unmodifiableSwitchesMap;
    private List<ViewNode> _unmodifiableViewsList;
    private Map<String, Set<NavigationCase>> _navigationCases = new HashMap<String, Set<NavigationCase>>();
    private Map<String, Set<NavigationCase>> _unmodifiableNavigationCases;
    private boolean _initialized;

    public FlowImpl() {
        this._unmodifiableInboundParametersMap = Collections.unmodifiableMap(this._inboundParametersMap);
        this._unmodifiableFlowCallsMap = Collections.unmodifiableMap(this._flowCallsMap);
        this._unmodifiableMethodCallsList = Collections.unmodifiableList(this._methodCallsList);
        this._unmodifiableReturnsMap = Collections.unmodifiableMap(this._returnsMap);
        this._unmodifiableSwitchesMap = Collections.unmodifiableMap(this._switchesMap);
        this._unmodifiableViewsList = Collections.unmodifiableList(this._viewsList);
        this._unmodifiableNavigationCases = Collections.unmodifiableMap(this._navigationCases);
    }

    @Override
    public void freeze() {
        this._initialized = true;
        for (Map.Entry<String, Parameter> entry : this._inboundParametersMap.entrySet()) {
            if (!(entry.getValue() instanceof Freezable)) continue;
            ((Freezable)entry.getValue()).freeze();
        }
        for (Map.Entry<String, Parameter> entry : this._flowCallsMap.entrySet()) {
            if (!(entry.getValue() instanceof Freezable)) continue;
            ((Freezable)entry.getValue()).freeze();
        }
        for (MethodCallNode methodCallNode : this._methodCallsList) {
            if (!(methodCallNode instanceof Freezable)) continue;
            ((Freezable)methodCallNode).freeze();
        }
        for (Map.Entry<String, Parameter> entry : this._returnsMap.entrySet()) {
            if (!(entry.getValue() instanceof Freezable)) continue;
            ((Freezable)entry.getValue()).freeze();
        }
        for (Map.Entry<String, Parameter> entry : this._switchesMap.entrySet()) {
            if (!(entry.getValue() instanceof Freezable)) continue;
            ((Freezable)entry.getValue()).freeze();
        }
        for (ViewNode viewNode : this._viewsList) {
            if (!(viewNode instanceof Freezable)) continue;
            ((Freezable)viewNode).freeze();
        }
    }

    public String getClientWindowFlowId(ClientWindow curWindow) {
        String id = this.getId();
        String documentId = this.getDefiningDocumentId();
        String windowId = curWindow.getId();
        StringBuilder sb = new StringBuilder(id.length() + 1 + windowId.length());
        sb.append(windowId).append('_').append(documentId).append('_').append(id);
        return sb.toString();
    }

    public String getDefiningDocumentId() {
        return this._definingDocumentId;
    }

    public void setDefiningDocumentId(String definingDocumentId) {
        this.checkInitialized();
        this._definingDocumentId = definingDocumentId;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this.checkInitialized();
        this._id = id;
    }

    public MethodExpression getInitializer() {
        return this._initializer;
    }

    public void setInitializer(MethodExpression initializer) {
        this.checkInitialized();
        this._initializer = initializer;
    }

    public MethodExpression getFinalizer() {
        return this._finalizer;
    }

    public void setFinalizer(MethodExpression finalizer) {
        this.checkInitialized();
        this._finalizer = finalizer;
    }

    public String getStartNodeId() {
        return this._startNodeId;
    }

    public void setStartNodeId(String startNodeId) {
        this.checkInitialized();
        this._startNodeId = startNodeId;
    }

    public Map<String, Parameter> getInboundParameters() {
        return this._unmodifiableInboundParametersMap;
    }

    public void putInboundParameter(String key, Parameter value) {
        this.checkInitialized();
        this._inboundParametersMap.put(key, value);
    }

    public Map<String, FlowCallNode> getFlowCalls() {
        return this._unmodifiableFlowCallsMap;
    }

    public void putFlowCall(String key, FlowCallNode value) {
        this.checkInitialized();
        this._flowCallsMap.put(key, value);
        this._flowNodeMap.put(value.getId(), (FlowNode)value);
    }

    public List<MethodCallNode> getMethodCalls() {
        return this._unmodifiableMethodCallsList;
    }

    public void addMethodCall(MethodCallNode value) {
        this.checkInitialized();
        this._methodCallsList.add(value);
        this._flowNodeMap.put(value.getId(), (FlowNode)value);
    }

    public Map<String, ReturnNode> getReturns() {
        return this._unmodifiableReturnsMap;
    }

    public void putReturn(String key, ReturnNode value) {
        this.checkInitialized();
        this._returnsMap.put(key, value);
        this._flowNodeMap.put(value.getId(), (FlowNode)value);
    }

    public Map<String, SwitchNode> getSwitches() {
        return this._unmodifiableSwitchesMap;
    }

    public void putSwitch(String key, SwitchNode value) {
        this.checkInitialized();
        this._switchesMap.put(key, value);
        this._flowNodeMap.put(value.getId(), (FlowNode)value);
    }

    public List<ViewNode> getViews() {
        return this._unmodifiableViewsList;
    }

    public void addView(ViewNode value) {
        this.checkInitialized();
        this._viewsList.add(value);
        this._flowNodeMap.put(value.getId(), (FlowNode)value);
    }

    public FlowCallNode getFlowCall(Flow targetFlow) {
        FacesContext facesContext = null;
        for (Map.Entry<String, FlowCallNode> entry : this._flowCallsMap.entrySet()) {
            if (facesContext == null) {
                facesContext = FacesContext.getCurrentInstance();
            }
            String calledDocumentId = entry.getValue().getCalledFlowDocumentId(facesContext);
            String calledFlowId = entry.getValue().getCalledFlowId(facesContext);
            if (!targetFlow.getDefiningDocumentId().equals(calledDocumentId) || !targetFlow.getId().equals(calledFlowId)) continue;
            return entry.getValue();
        }
        return null;
    }

    public FlowNode getNode(String nodeId) {
        return this._flowNodeMap.get(nodeId);
    }

    public void addNavigationCases(String fromViewId, Set<NavigationCase> navigationCases) {
        this.checkInitialized();
        Set navigationCaseSet = this._navigationCases.computeIfAbsent(fromViewId, k -> new HashSet());
        navigationCaseSet.addAll(navigationCases);
    }

    public void addNavigationCase(NavigationCase navigationCase) {
        this.checkInitialized();
        Set navigationCaseSet = this._navigationCases.computeIfAbsent(navigationCase.getFromViewId(), k -> new HashSet());
        navigationCaseSet.add(navigationCase);
    }

    public void removeNavigationCase(NavigationCase navigationCase) {
        this.checkInitialized();
        Set<NavigationCase> navigationCaseSet = this._navigationCases.get(navigationCase.getFromViewId());
        if (navigationCaseSet == null) {
            return;
        }
        navigationCaseSet.remove(navigationCase);
    }

    private void checkInitialized() throws IllegalStateException {
        if (this._initialized) {
            throw new IllegalStateException("Flow is inmutable once initialized");
        }
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        return this._unmodifiableNavigationCases;
    }
}

