/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel.exps;

import java.util.Collection;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.exps.AggregateVal;
import org.apache.openjpa.kernel.exps.Val;

class Sum
extends AggregateVal {
    private static final long serialVersionUID = 1L;

    public Sum(Val val) {
        super(val);
    }

    @Override
    protected Class getType(Class c) {
        Class<?> wrap = Filters.wrap(c);
        if (wrap == Integer.class || wrap == Short.class || wrap == Byte.class) {
            return Long.TYPE;
        }
        return c;
    }

    @Override
    protected Object operate(Collection os, Class c) {
        if (os.isEmpty()) {
            return null;
        }
        Class type = this.getType(c);
        Object sum = Filters.convert(0, type);
        for (Object o : os) {
            Object cur = o;
            if (cur == null) continue;
            sum = Filters.add(sum, type, cur, c);
        }
        return sum;
    }
}

