/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.BeforeRetry;
import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.internal.BeforeRetryMethod;
import io.smallrye.faulttolerance.internal.InterceptionPoint;
import java.lang.reflect.Method;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public interface BeforeRetryConfig
extends BeforeRetry,
Config {
    default public void validate() {
        Method guardedMethod;
        String INVALID_BEFORE_RETRY_ON = "Invalid @BeforeRetry on ";
        try {
            guardedMethod = this.method().reflect();
        }
        catch (NoSuchMethodException e) {
            throw new FaultToleranceDefinitionException((Throwable)e);
        }
        if (!"".equals(this.methodName())) {
            if (!BeforeRetry.DEFAULT.class.equals((Object)this.value())) {
                throw new FaultToleranceDefinitionException("Invalid @BeforeRetry on " + String.valueOf(this.method()) + ": before retry handler class and before retry method can't be specified both at the same time");
            }
            BeforeRetryMethod beforeRetryMethod = BeforeRetryMethod.find(new InterceptionPoint(this.beanClass(), guardedMethod), this.methodName());
            if (beforeRetryMethod == null) {
                throw new FaultToleranceDefinitionException("Invalid @BeforeRetry on " + String.valueOf(this.method()) + ": can't find before retry method '" + this.methodName() + "' with no parameter and return type of void");
            }
        }
    }
}

