/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.annotation;

import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.caseditor.editor.annotation.EclipseAnnotationPeer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class TokenDrawingStrategy
implements AnnotationPainter.IDrawingStrategy {
    private static final int BRACKET_WIDTH = 5;

    private static boolean isWhitespace(String text, int offset) {
        char character = text.charAt(offset);
        return Character.isWhitespace(character);
    }

    public void draw(Annotation annotation, GC gc, StyledText textWidget, int offset, int length, Color color) {
        if (length > 0 && annotation instanceof EclipseAnnotationPeer) {
            AnnotationFS annotationFS = ((EclipseAnnotationPeer)annotation).getAnnotationFS();
            if (gc != null) {
                boolean isDrawCloseBracket;
                boolean isDrawOpenBracket;
                Rectangle bounds = textWidget.getTextBounds(offset, offset + length - 1);
                gc.setForeground(color);
                boolean bl = isDrawOpenBracket = annotationFS.getBegin() == offset;
                if (isDrawOpenBracket && offset > 1 && !TokenDrawingStrategy.isWhitespace(annotationFS.getCAS().getDocumentText(), offset - 1)) {
                    gc.drawLine(bounds.x, bounds.y + bounds.height - 1, bounds.x + 5, bounds.y + bounds.height - 1);
                    gc.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height - 1);
                    gc.drawLine(bounds.x, bounds.y, bounds.x + 5, bounds.y);
                }
                boolean bl2 = isDrawCloseBracket = annotationFS.getEnd() == offset + length;
                if (isDrawCloseBracket && offset + length < textWidget.getText().length() && !TokenDrawingStrategy.isWhitespace(annotationFS.getCAS().getDocumentText(), offset + length)) {
                    gc.drawLine(bounds.x + bounds.width, bounds.y + bounds.height - 1, bounds.x + bounds.width - 5, bounds.y + bounds.height - 1);
                    gc.drawLine(bounds.x + bounds.width - 1, bounds.y, bounds.x + bounds.width - 1, bounds.y + bounds.height - 1);
                    gc.drawLine(bounds.x + bounds.width, bounds.y, bounds.x + bounds.width - 5, bounds.y);
                }
            } else {
                textWidget.redrawRange(offset, length, true);
            }
        }
    }
}

