/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.reader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.spark.executor.ShuffleReadMetrics;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.uniffle.client.api.ShuffleReadClient;
import org.apache.uniffle.client.response.CompressedShuffleBlock;
import org.apache.uniffle.common.compression.Codec;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.io.netty.buffer.ByteBufInputStream;
import org.apache.uniffle.shaded.io.netty.buffer.Unpooled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Product2;
import scala.Tuple2;
import scala.collection.AbstractIterator;
import scala.collection.Iterator;
import scala.runtime.BoxedUnit;

public class RssShuffleDataIterator<K, C>
extends AbstractIterator<Product2<K, C>> {
    private static final Logger LOG = LoggerFactory.getLogger(RssShuffleDataIterator.class);
    private Iterator<Tuple2<Object, Object>> recordsIterator = null;
    private SerializerInstance serializerInstance;
    private ShuffleReadClient shuffleReadClient;
    private ShuffleReadMetrics shuffleReadMetrics;
    private long readTime = 0L;
    private long serializeTime = 0L;
    private long decompressTime = 0L;
    private DeserializationStream deserializationStream = null;
    private ByteBufInputStream byteBufInputStream = null;
    private long totalRawBytesLength = 0L;
    private long unCompressedBytesLength = 0L;
    private ByteBuffer uncompressedData;
    private Codec codec;

    public RssShuffleDataIterator(Serializer serializer, ShuffleReadClient shuffleReadClient, ShuffleReadMetrics shuffleReadMetrics, RssConf rssConf) {
        this.serializerInstance = serializer.newInstance();
        this.shuffleReadClient = shuffleReadClient;
        this.shuffleReadMetrics = shuffleReadMetrics;
        boolean compress = rssConf.getBoolean("spark.shuffle.compress".substring("spark.".length()), true);
        this.codec = compress ? Codec.newInstance(rssConf) : null;
    }

    public Iterator<Tuple2<Object, Object>> createKVIterator(ByteBuffer data) {
        this.clearDeserializationStream();
        this.byteBufInputStream = new ByteBufInputStream(Unpooled.wrappedBuffer(data), true);
        this.deserializationStream = this.serializerInstance.deserializeStream((InputStream)this.byteBufInputStream);
        return this.deserializationStream.asKeyValueIterator();
    }

    private void clearDeserializationStream() {
        if (this.byteBufInputStream != null) {
            try {
                this.byteBufInputStream.close();
            }
            catch (IOException e) {
                LOG.warn("Can't close ByteBufInputStream, memory may be leaked.");
            }
        }
        if (this.deserializationStream != null) {
            this.deserializationStream.close();
        }
        this.deserializationStream = null;
        this.byteBufInputStream = null;
    }

    public boolean hasNext() {
        if (this.recordsIterator == null || !this.recordsIterator.hasNext()) {
            long startFetch = System.currentTimeMillis();
            CompressedShuffleBlock rawBlock = this.shuffleReadClient.readShuffleBlockData();
            ByteBuffer rawData = rawBlock != null ? rawBlock.getByteBuffer() : null;
            long fetchDuration = System.currentTimeMillis() - startFetch;
            this.shuffleReadMetrics.incFetchWaitTime(fetchDuration);
            if (rawData != null) {
                this.uncompress(rawBlock, rawData);
                long startSerialization = System.currentTimeMillis();
                this.recordsIterator = this.createKVIterator(this.uncompressedData);
                long serializationDuration = System.currentTimeMillis() - startSerialization;
                this.readTime += fetchDuration;
                this.serializeTime += serializationDuration;
            } else {
                this.shuffleReadClient.checkProcessedBlockIds();
                this.shuffleReadClient.logStatics();
                String decInfo = this.codec == null ? "." : ", " + this.decompressTime + " ms to decompress with unCompressionLength[" + this.unCompressedBytesLength + "]";
                LOG.info("Fetch {} bytes cost {} ms and {} ms to serialize{}", new Object[]{this.totalRawBytesLength, this.readTime, this.serializeTime, decInfo});
                return false;
            }
        }
        return this.recordsIterator.hasNext();
    }

    private boolean isSameMemoryType(ByteBuffer left, ByteBuffer right) {
        return left.isDirect() == right.isDirect();
    }

    private int uncompress(CompressedShuffleBlock rawBlock, ByteBuffer rawData) {
        long rawDataLength = rawData.limit() - rawData.position();
        this.totalRawBytesLength += rawDataLength;
        this.shuffleReadMetrics.incRemoteBytesRead(rawDataLength);
        int uncompressedLen = rawBlock.getUncompressLength();
        if (this.codec != null) {
            if (this.uncompressedData == null || this.uncompressedData.capacity() < uncompressedLen || !this.isSameMemoryType(this.uncompressedData, rawData)) {
                if (LOG.isDebugEnabled() && this.uncompressedData != null && !this.isSameMemoryType(this.uncompressedData, rawData)) {
                    LOG.debug("This should not happen that the temporary uncompressed data's memory type(isDirect:{}) is not same with fetched data buffer(isDirect:{})", (Object)this.uncompressedData.isDirect(), (Object)rawData.isDirect());
                }
                if (this.uncompressedData != null) {
                    RssUtils.releaseByteBuffer(this.uncompressedData);
                }
                this.uncompressedData = rawData.isDirect() ? ByteBuffer.allocateDirect(uncompressedLen) : ByteBuffer.allocate(uncompressedLen);
            }
            this.uncompressedData.clear();
            long startDecompress = System.currentTimeMillis();
            this.codec.decompress(rawData, uncompressedLen, this.uncompressedData, 0);
            this.unCompressedBytesLength += (long)uncompressedLen;
            long decompressDuration = System.currentTimeMillis() - startDecompress;
            this.decompressTime += decompressDuration;
            this.uncompressedData.limit(this.uncompressedData.position() + uncompressedLen);
        } else {
            this.uncompressedData = rawData;
        }
        return uncompressedLen;
    }

    public Product2<K, C> next() {
        this.shuffleReadMetrics.incRecordsRead(1L);
        return (Product2)this.recordsIterator.next();
    }

    public BoxedUnit cleanup() {
        this.clearDeserializationStream();
        if (this.codec != null) {
            RssUtils.releaseByteBuffer(this.uncompressedData);
        }
        if (this.shuffleReadClient != null) {
            this.shuffleReadClient.close();
        }
        this.shuffleReadClient = null;
        this.uncompressedData = null;
        return BoxedUnit.UNIT;
    }

    @VisibleForTesting
    protected ShuffleReadMetrics getShuffleReadMetrics() {
        return this.shuffleReadMetrics;
    }
}

