/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.protocol;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.ShuffleBlockInfo;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.util.ByteBufUtils;
import org.apache.uniffle.common.util.NettyUtils;

public class Decoders {
    public static ShuffleServerInfo decodeShuffleServerInfo(ByteBuf byteBuf) {
        String id = ByteBufUtils.readLengthAndString(byteBuf);
        String host = ByteBufUtils.readLengthAndString(byteBuf);
        int grpcPort = byteBuf.readInt();
        int nettyPort = byteBuf.readInt();
        return new ShuffleServerInfo(id, host, grpcPort, nettyPort);
    }

    public static ShuffleBlockInfo decodeShuffleBlockInfo(ByteBuf byteBuf) {
        int partId = byteBuf.readInt();
        long blockId = byteBuf.readLong();
        int length = byteBuf.readInt();
        int shuffleId = byteBuf.readInt();
        long crc = byteBuf.readLong();
        long taskAttemptId = byteBuf.readLong();
        int dataLength = byteBuf.readInt();
        ByteBuf data = NettyUtils.getNettyBufferAllocator().directBuffer(dataLength);
        data.writeBytes(byteBuf, dataLength);
        int lengthOfShuffleServers = byteBuf.readInt();
        ArrayList serverInfos = Lists.newArrayList();
        for (int k = 0; k < lengthOfShuffleServers; ++k) {
            serverInfos.add(Decoders.decodeShuffleServerInfo(byteBuf));
        }
        int uncompressLength = byteBuf.readInt();
        long freeMemory = byteBuf.readLong();
        return new ShuffleBlockInfo(shuffleId, partId, blockId, length, crc, data, (List<ShuffleServerInfo>)serverInfos, uncompressLength, freeMemory, taskAttemptId);
    }

    public static Map<Integer, List<Long>> decodePartitionToBlockIds(ByteBuf byteBuf) {
        HashMap partitionToBlockIds = Maps.newHashMap();
        int mapSize = byteBuf.readInt();
        for (int i = 0; i < mapSize; ++i) {
            int partitionId = byteBuf.readInt();
            int blockListSize = byteBuf.readInt();
            ArrayList blocks = Lists.newArrayList();
            for (int j = 0; j < blockListSize; ++j) {
                blocks.add(byteBuf.readLong());
            }
            partitionToBlockIds.put(partitionId, blocks);
        }
        return partitionToBlockIds;
    }

    public static List<BufferSegment> decodeBufferSegments(ByteBuf byteBuf) {
        ArrayList bufferSegments = Lists.newArrayList();
        int size = byteBuf.readInt();
        for (int i = 0; i < size; ++i) {
            long blockId = byteBuf.readLong();
            int offset = byteBuf.readInt();
            int length = byteBuf.readInt();
            int uncompressLength = byteBuf.readInt();
            long crc = byteBuf.readLong();
            long taskAttemptId = byteBuf.readLong();
            BufferSegment bufferSegment = new BufferSegment(blockId, offset, length, uncompressLength, crc, taskAttemptId);
            bufferSegments.add(bufferSegment);
        }
        return bufferSegments;
    }
}

