/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.protocol;

import org.apache.uniffle.common.netty.buffer.ManagedBuffer;
import org.apache.uniffle.common.netty.buffer.NettyManagedBuffer;
import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.netty.protocol.RpcResponse;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.util.ByteBufUtils;
import org.apache.uniffle.shaded.io.netty.buffer.ByteBuf;
import org.apache.uniffle.shaded.io.netty.buffer.Unpooled;

public class GetLocalShuffleIndexResponse
extends RpcResponse {
    private long fileLength;

    public GetLocalShuffleIndexResponse(long requestId, StatusCode statusCode, String retMessage, byte[] indexData, long fileLength) {
        this(requestId, statusCode, retMessage, indexData == null ? Unpooled.EMPTY_BUFFER : Unpooled.wrappedBuffer(indexData), fileLength);
    }

    public GetLocalShuffleIndexResponse(long requestId, StatusCode statusCode, String retMessage, ByteBuf indexData, long fileLength) {
        this(requestId, statusCode, retMessage, new NettyManagedBuffer(indexData), fileLength);
    }

    public GetLocalShuffleIndexResponse(long requestId, StatusCode statusCode, String retMessage, ManagedBuffer managedBuffer, long fileLength) {
        super(requestId, statusCode, retMessage, managedBuffer);
        this.fileLength = fileLength;
    }

    @Override
    public int encodedLength() {
        return super.encodedLength() + 8;
    }

    @Override
    public void encode(ByteBuf buf) {
        super.encode(buf);
        buf.writeLong(this.fileLength);
    }

    public static GetLocalShuffleIndexResponse decode(ByteBuf byteBuf, boolean decodeBody) {
        long requestId = byteBuf.readLong();
        StatusCode statusCode = StatusCode.fromCode(byteBuf.readInt());
        String retMessage = ByteBufUtils.readLengthAndString(byteBuf);
        long fileLength = byteBuf.readLong();
        if (decodeBody) {
            NettyManagedBuffer nettyManagedBuffer = new NettyManagedBuffer(byteBuf);
            return new GetLocalShuffleIndexResponse(requestId, statusCode, retMessage, nettyManagedBuffer, fileLength);
        }
        return new GetLocalShuffleIndexResponse(requestId, statusCode, retMessage, NettyManagedBuffer.EMPTY_BUFFER, fileLength);
    }

    @Override
    public Message.Type type() {
        return Message.Type.GET_LOCAL_SHUFFLE_INDEX_RESPONSE;
    }

    public long getFileLength() {
        return this.fileLength;
    }
}

