/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.util;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uniffle.common.util.ByteUnit;

public final class UnitConverter {
    private static final Map<String, ByteUnit> byteSuffixes = ImmutableMap.builder().put((Object)"b", (Object)ByteUnit.BYTE).put((Object)"k", (Object)ByteUnit.KiB).put((Object)"kb", (Object)ByteUnit.KiB).put((Object)"m", (Object)ByteUnit.MiB).put((Object)"mb", (Object)ByteUnit.MiB).put((Object)"g", (Object)ByteUnit.GiB).put((Object)"gb", (Object)ByteUnit.GiB).put((Object)"t", (Object)ByteUnit.TiB).put((Object)"tb", (Object)ByteUnit.TiB).put((Object)"p", (Object)ByteUnit.PiB).put((Object)"pb", (Object)ByteUnit.PiB).build();
    private static final Map<String, TimeUnit> timeSuffixes = ImmutableMap.builder().put((Object)"us", (Object)TimeUnit.MICROSECONDS).put((Object)"ms", (Object)TimeUnit.MILLISECONDS).put((Object)"s", (Object)TimeUnit.SECONDS).put((Object)"m", (Object)TimeUnit.MINUTES).put((Object)"min", (Object)TimeUnit.MINUTES).put((Object)"h", (Object)TimeUnit.HOURS).put((Object)"d", (Object)TimeUnit.DAYS).build();

    private UnitConverter() {
    }

    public static boolean isByteString(String str) {
        String strLower = str.toLowerCase();
        for (String key : byteSuffixes.keySet()) {
            if (!strLower.contains(key)) continue;
            return true;
        }
        return false;
    }

    public static long byteStringAs(String str, ByteUnit unit) {
        String lower = str.toLowerCase(Locale.ROOT).trim();
        try {
            Matcher m = Pattern.compile("([0-9]+)([a-z]+)?").matcher(lower);
            Matcher fractionMatcher = Pattern.compile("([0-9]+\\.[0-9]+)([a-z]+)?").matcher(lower);
            if (m.matches()) {
                long val = Long.parseLong(m.group(1));
                String suffix = m.group(2);
                ByteUnit byteUnit = unit;
                if (suffix != null && (byteUnit = byteSuffixes.get(suffix)) == null) {
                    throw new NumberFormatException("Invalid suffix: \"" + suffix + "\"");
                }
                return unit.convertFrom(val, byteUnit);
            }
            if (fractionMatcher.matches()) {
                throw new NumberFormatException("Fractional values are not supported. Input was: " + fractionMatcher.group(1));
            }
            throw new NumberFormatException("Failed to parse byte string: " + str);
        }
        catch (NumberFormatException e) {
            String byteError = "Size must be specified as bytes (b), kibibytes (k), mebibytes (m), gibibytes (g), tebibytes (t), or pebibytes(p). E.g. 50b, 100k, or 250m.";
            throw new NumberFormatException(byteError + "\n" + e.getMessage());
        }
    }

    public static long byteStringAsBytes(String str) {
        return UnitConverter.byteStringAs(str, ByteUnit.BYTE);
    }

    public static long timeStringAs(String str, TimeUnit unit) {
        String lower = str.toLowerCase(Locale.ROOT).trim();
        try {
            Matcher m = Pattern.compile("(-?[0-9]+)([a-z]+)?").matcher(lower);
            if (!m.matches()) {
                throw new NumberFormatException("Failed to parse time string: " + str);
            }
            long val = Long.parseLong(m.group(1));
            String suffix = m.group(2);
            TimeUnit timeUnit = unit;
            if (suffix != null && (timeUnit = timeSuffixes.get(suffix)) == null) {
                throw new NumberFormatException("Invalid suffix: \"" + suffix + "\"");
            }
            return unit.convert(val, timeUnit);
        }
        catch (NumberFormatException e) {
            String timeError = "Time must be specified as seconds (s), milliseconds (ms), microseconds (us), minutes (m or min), hour (h), or day (d). E.g. 50s, 100ms, or 250us.";
            throw new NumberFormatException(timeError + "\n" + e.getMessage());
        }
    }
}

