/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.function.ConsumerWithException;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.server.FlushEventHandler;
import org.apache.uniffle.server.ShuffleDataFlushEvent;
import org.apache.uniffle.server.ShuffleServer;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.ShuffleServerMetrics;
import org.apache.uniffle.server.flush.EventDiscardException;
import org.apache.uniffle.server.flush.EventInvalidException;
import org.apache.uniffle.server.flush.EventRetryException;
import org.apache.uniffle.server.storage.StorageManager;
import org.apache.uniffle.shaded.guava.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.guava.collect.Queues;
import org.apache.uniffle.storage.common.HadoopStorage;
import org.apache.uniffle.storage.common.LocalStorage;
import org.apache.uniffle.storage.common.Storage;
import org.apache.uniffle.storage.util.StorageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFlushEventHandler
implements FlushEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFlushEventHandler.class);
    private final ShuffleServerConf shuffleServerConf;
    private final StorageManager storageManager;
    private Executor localFileThreadPoolExecutor;
    private Executor hadoopThreadPoolExecutor;
    private Executor fallbackThreadPoolExecutor;
    private final StorageType storageType;
    protected final BlockingQueue<ShuffleDataFlushEvent> flushQueue = Queues.newLinkedBlockingQueue();
    private ConsumerWithException<ShuffleDataFlushEvent> eventConsumer;
    private final ShuffleServer shuffleServer;
    private volatile boolean stopped = false;

    public DefaultFlushEventHandler(ShuffleServerConf conf, StorageManager storageManager, ShuffleServer shuffleServer, ConsumerWithException<ShuffleDataFlushEvent> eventConsumer) {
        this.shuffleServerConf = conf;
        this.storageType = StorageType.valueOf((String)((org.apache.uniffle.common.StorageType)this.shuffleServerConf.get(RssBaseConf.RSS_STORAGE_TYPE)).name());
        this.storageManager = storageManager;
        this.shuffleServer = shuffleServer;
        this.eventConsumer = eventConsumer;
        this.initFlushEventExecutor();
    }

    @Override
    public void handle(ShuffleDataFlushEvent event) {
        if (!this.flushQueue.offer(event)) {
            LOG.error("Flush queue is full, discard event: " + event);
            event.doCleanup();
            ShuffleServerMetrics.counterTotalDroppedEventNum.inc();
        } else {
            ShuffleServerMetrics.gaugeEventQueueSize.inc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEventAndUpdateMetrics(ShuffleDataFlushEvent event, Storage storage) {
        long start = System.currentTimeMillis();
        String appId = event.getAppId();
        ReentrantReadWriteLock.ReadLock readLock = this.shuffleServer.getShuffleTaskManager().getAppReadLock(appId);
        try {
            readLock.lock();
            try {
                this.eventConsumer.accept((Object)event);
            }
            finally {
                readLock.unlock();
            }
            if (storage != null) {
                ShuffleServerMetrics.incStorageSuccessCounter(storage.getStorageHost());
            }
            event.doCleanup();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Flush event:{} successfully in {} ms and release {} bytes", new Object[]{event, System.currentTimeMillis() - start, event.getSize()});
            }
        }
        catch (Exception e) {
            if (e instanceof EventRetryException) {
                event.increaseRetryTimes();
                event.markPended();
                if (storage != null) {
                    ShuffleServerMetrics.incStorageRetryCounter(storage.getStorageHost());
                }
                this.handle(event);
                return;
            }
            if (e instanceof EventDiscardException) {
                ShuffleServerMetrics.counterTotalDroppedEventNum.inc();
                ShuffleServerMetrics.counterTotalFailedWrittenEventNum.inc();
                if (storage != null) {
                    ShuffleServerMetrics.incStorageFailedCounter(storage.getStorageHost());
                }
                event.doCleanup();
                LOG.error("Flush event: {} failed in {} ms and release {} bytes. This will make data lost.", new Object[]{event, System.currentTimeMillis() - start, event.getSize()});
                return;
            }
            if (e instanceof EventInvalidException) {
                event.doCleanup();
                return;
            }
            LOG.error("Unexpected exceptions happened when handling the flush event: {}, due to ", (Object)event, (Object)e);
            event.doCleanup();
        }
        finally {
            if (storage != null) {
                if (storage instanceof HadoopStorage) {
                    ShuffleServerMetrics.counterHadoopEventFlush.inc();
                    ShuffleServerMetrics.gaugeHadoopFlushThreadPoolQueueSize.dec();
                } else if (storage instanceof LocalStorage) {
                    ShuffleServerMetrics.counterLocalFileEventFlush.inc();
                    ShuffleServerMetrics.gaugeLocalfileFlushThreadPoolQueueSize.dec();
                } else {
                    ShuffleServerMetrics.gaugeFallbackFlushThreadPoolQueueSize.dec();
                }
            } else {
                ShuffleServerMetrics.gaugeFallbackFlushThreadPoolQueueSize.dec();
            }
            ShuffleServerMetrics.gaugeEventQueueSize.dec();
        }
    }

    protected void initFlushEventExecutor() {
        int poolSize;
        if (StorageType.withLocalfile((StorageType)this.storageType)) {
            poolSize = this.shuffleServerConf.getInteger(ShuffleServerConf.SERVER_FLUSH_LOCALFILE_THREAD_POOL_SIZE);
            this.localFileThreadPoolExecutor = this.createFlushEventExecutor(poolSize, "LocalFileFlushEventThreadPool");
        }
        if (StorageType.withHadoop((StorageType)this.storageType)) {
            poolSize = this.shuffleServerConf.getInteger(ShuffleServerConf.SERVER_FLUSH_HADOOP_THREAD_POOL_SIZE);
            this.hadoopThreadPoolExecutor = this.createFlushEventExecutor(poolSize, "HadoopFlushEventThreadPool");
        }
        this.fallbackThreadPoolExecutor = this.createFlushEventExecutor(5, "FallBackFlushEventThreadPool");
        this.startEventProcessor();
    }

    private void startEventProcessor() {
        Thread processEventThread = new Thread(this::eventLoop);
        processEventThread.setName("ProcessEventThread");
        processEventThread.setDaemon(true);
        processEventThread.start();
    }

    protected void eventLoop() {
        while (!this.stopped && !Thread.currentThread().isInterrupted()) {
            this.dispatchEvent();
        }
    }

    protected void dispatchEvent() {
        try {
            ShuffleDataFlushEvent event = this.flushQueue.take();
            Storage storage = this.storageManager.selectStorage(event);
            Executor dedicatedExecutor = this.fallbackThreadPoolExecutor;
            if (!event.isPended()) {
                if (storage instanceof HadoopStorage) {
                    dedicatedExecutor = this.hadoopThreadPoolExecutor;
                    ShuffleServerMetrics.gaugeHadoopFlushThreadPoolQueueSize.inc();
                } else if (storage instanceof LocalStorage) {
                    dedicatedExecutor = this.localFileThreadPoolExecutor;
                    ShuffleServerMetrics.gaugeLocalfileFlushThreadPoolQueueSize.inc();
                }
            } else {
                dedicatedExecutor = this.fallbackThreadPoolExecutor;
                ShuffleServerMetrics.gaugeFallbackFlushThreadPoolQueueSize.inc();
            }
            CompletableFuture.runAsync(() -> this.handleEventAndUpdateMetrics(event, storage), dedicatedExecutor).exceptionally(e -> {
                LOG.error("Exception happened when handling event and updating metrics.", e);
                return null;
            });
        }
        catch (Exception e2) {
            LOG.error("Exception happened when pushing events to dedicated event handler.", (Throwable)e2);
        }
    }

    protected Executor createFlushEventExecutor(int poolSize, String threadFactoryName) {
        int waitQueueSize = this.shuffleServerConf.getInteger(ShuffleServerConf.SERVER_FLUSH_THREAD_POOL_QUEUE_SIZE);
        LinkedBlockingQueue<Runnable> waitQueue = Queues.newLinkedBlockingQueue(waitQueueSize);
        long keepAliveTime = this.shuffleServerConf.getLong(ShuffleServerConf.SERVER_FLUSH_THREAD_ALIVE);
        LOG.info("CreateFlushPool, poolSize:{}, keepAliveTime:{}, queueSize:{}", new Object[]{poolSize, keepAliveTime, waitQueueSize});
        return new ThreadPoolExecutor(poolSize, poolSize, keepAliveTime, TimeUnit.SECONDS, waitQueue, ThreadUtils.getThreadFactory((String)threadFactoryName));
    }

    @Override
    public int getEventNumInFlush() {
        return (int)ShuffleServerMetrics.gaugeEventQueueSize.get();
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    @VisibleForTesting
    public Executor getFallbackThreadPoolExecutor() {
        return this.fallbackThreadPoolExecutor;
    }
}

