/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.storage;

import java.util.Set;
import org.apache.uniffle.server.ShuffleDataFlushEvent;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.storage.AbstractStorageManagerFallbackStrategy;
import org.apache.uniffle.server.storage.LocalStorageManager;
import org.apache.uniffle.server.storage.StorageManager;
import org.apache.uniffle.shaded.guava.collect.Sets;

public class LocalStorageManagerFallbackStrategy
extends AbstractStorageManagerFallbackStrategy {
    private final Long fallBackTimes;
    private Set<Class<? extends StorageManager>> excludeTypes = Sets.newHashSet(LocalStorageManager.class);

    public LocalStorageManagerFallbackStrategy(ShuffleServerConf conf) {
        super(conf);
        this.fallBackTimes = (Long)conf.get(ShuffleServerConf.FALLBACK_MAX_FAIL_TIMES);
    }

    @Override
    public StorageManager tryFallback(StorageManager current, ShuffleDataFlushEvent event, StorageManager ... candidates) {
        if ((long)event.getRetryTimes() > this.fallBackTimes || !current.canWrite(event)) {
            return this.findNextStorageManager(current, this.excludeTypes, event, candidates);
        }
        return current;
    }
}

