// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file sequences.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__NOCOMMON_MODULE_SEQUENCES_HPP
#define FAST_DDS_GENERATED__NOCOMMON_MODULE_SEQUENCES_HPP

#include <cstdint>
#include <string>
#include <utility>
#include <vector>

#include <fastcdr/cdr/fixed_size_string.hpp>
#include "helpers/basic_inner_types.hpp"

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(SEQUENCES_SOURCE)
#define SEQUENCES_DllAPI __declspec( dllexport )
#else
#define SEQUENCES_DllAPI __declspec( dllimport )
#endif // SEQUENCES_SOURCE
#else
#define SEQUENCES_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define SEQUENCES_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure SequenceShort defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceShort that will be copied.
     */
    eProsima_user_DllExport SequenceShort(
            const SequenceShort& x)
    {
                    m_var_sequence_short = x.m_var_sequence_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceShort that will be copied.
     */
    eProsima_user_DllExport SequenceShort(
            SequenceShort&& x) noexcept
    {
        m_var_sequence_short = std::move(x.m_var_sequence_short);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceShort that will be copied.
     */
    eProsima_user_DllExport SequenceShort& operator =(
            const SequenceShort& x)
    {

                    m_var_sequence_short = x.m_var_sequence_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceShort that will be copied.
     */
    eProsima_user_DllExport SequenceShort& operator =(
            SequenceShort&& x) noexcept
    {

        m_var_sequence_short = std::move(x.m_var_sequence_short);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceShort& x) const
    {
        return (m_var_sequence_short == x.m_var_sequence_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_short
     * @param _var_sequence_short New value to be copied in member var_sequence_short
     */
    eProsima_user_DllExport void var_sequence_short(
            const std::vector<int16_t>& _var_sequence_short)
    {
        m_var_sequence_short = _var_sequence_short;
    }

    /*!
     * @brief This function moves the value in member var_sequence_short
     * @param _var_sequence_short New value to be moved in member var_sequence_short
     */
    eProsima_user_DllExport void var_sequence_short(
            std::vector<int16_t>&& _var_sequence_short)
    {
        m_var_sequence_short = std::move(_var_sequence_short);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_short
     * @return Constant reference to member var_sequence_short
     */
    eProsima_user_DllExport const std::vector<int16_t>& var_sequence_short() const
    {
        return m_var_sequence_short;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_short
     * @return Reference to member var_sequence_short
     */
    eProsima_user_DllExport std::vector<int16_t>& var_sequence_short()
    {
        return m_var_sequence_short;
    }



private:

    std::vector<int16_t> m_var_sequence_short;

};
/*!
 * @brief This class represents the structure SequenceUShort defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceUShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceUShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceUShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceUShort that will be copied.
     */
    eProsima_user_DllExport SequenceUShort(
            const SequenceUShort& x)
    {
                    m_var_sequence_ushort = x.m_var_sequence_ushort;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceUShort that will be copied.
     */
    eProsima_user_DllExport SequenceUShort(
            SequenceUShort&& x) noexcept
    {
        m_var_sequence_ushort = std::move(x.m_var_sequence_ushort);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceUShort that will be copied.
     */
    eProsima_user_DllExport SequenceUShort& operator =(
            const SequenceUShort& x)
    {

                    m_var_sequence_ushort = x.m_var_sequence_ushort;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceUShort that will be copied.
     */
    eProsima_user_DllExport SequenceUShort& operator =(
            SequenceUShort&& x) noexcept
    {

        m_var_sequence_ushort = std::move(x.m_var_sequence_ushort);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceUShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceUShort& x) const
    {
        return (m_var_sequence_ushort == x.m_var_sequence_ushort);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceUShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceUShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_ushort
     * @param _var_sequence_ushort New value to be copied in member var_sequence_ushort
     */
    eProsima_user_DllExport void var_sequence_ushort(
            const std::vector<uint16_t>& _var_sequence_ushort)
    {
        m_var_sequence_ushort = _var_sequence_ushort;
    }

    /*!
     * @brief This function moves the value in member var_sequence_ushort
     * @param _var_sequence_ushort New value to be moved in member var_sequence_ushort
     */
    eProsima_user_DllExport void var_sequence_ushort(
            std::vector<uint16_t>&& _var_sequence_ushort)
    {
        m_var_sequence_ushort = std::move(_var_sequence_ushort);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_ushort
     * @return Constant reference to member var_sequence_ushort
     */
    eProsima_user_DllExport const std::vector<uint16_t>& var_sequence_ushort() const
    {
        return m_var_sequence_ushort;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_ushort
     * @return Reference to member var_sequence_ushort
     */
    eProsima_user_DllExport std::vector<uint16_t>& var_sequence_ushort()
    {
        return m_var_sequence_ushort;
    }



private:

    std::vector<uint16_t> m_var_sequence_ushort;

};
/*!
 * @brief This class represents the structure SequenceLong defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceLong that will be copied.
     */
    eProsima_user_DllExport SequenceLong(
            const SequenceLong& x)
    {
                    m_var_sequence_long = x.m_var_sequence_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceLong that will be copied.
     */
    eProsima_user_DllExport SequenceLong(
            SequenceLong&& x) noexcept
    {
        m_var_sequence_long = std::move(x.m_var_sequence_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceLong that will be copied.
     */
    eProsima_user_DllExport SequenceLong& operator =(
            const SequenceLong& x)
    {

                    m_var_sequence_long = x.m_var_sequence_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceLong that will be copied.
     */
    eProsima_user_DllExport SequenceLong& operator =(
            SequenceLong&& x) noexcept
    {

        m_var_sequence_long = std::move(x.m_var_sequence_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceLong& x) const
    {
        return (m_var_sequence_long == x.m_var_sequence_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_long
     * @param _var_sequence_long New value to be copied in member var_sequence_long
     */
    eProsima_user_DllExport void var_sequence_long(
            const std::vector<int32_t>& _var_sequence_long)
    {
        m_var_sequence_long = _var_sequence_long;
    }

    /*!
     * @brief This function moves the value in member var_sequence_long
     * @param _var_sequence_long New value to be moved in member var_sequence_long
     */
    eProsima_user_DllExport void var_sequence_long(
            std::vector<int32_t>&& _var_sequence_long)
    {
        m_var_sequence_long = std::move(_var_sequence_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_long
     * @return Constant reference to member var_sequence_long
     */
    eProsima_user_DllExport const std::vector<int32_t>& var_sequence_long() const
    {
        return m_var_sequence_long;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_long
     * @return Reference to member var_sequence_long
     */
    eProsima_user_DllExport std::vector<int32_t>& var_sequence_long()
    {
        return m_var_sequence_long;
    }



private:

    std::vector<int32_t> m_var_sequence_long;

};
/*!
 * @brief This class represents the structure SequenceULong defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceULong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceULong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceULong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceULong that will be copied.
     */
    eProsima_user_DllExport SequenceULong(
            const SequenceULong& x)
    {
                    m_var_sequence_ulong = x.m_var_sequence_ulong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceULong that will be copied.
     */
    eProsima_user_DllExport SequenceULong(
            SequenceULong&& x) noexcept
    {
        m_var_sequence_ulong = std::move(x.m_var_sequence_ulong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceULong that will be copied.
     */
    eProsima_user_DllExport SequenceULong& operator =(
            const SequenceULong& x)
    {

                    m_var_sequence_ulong = x.m_var_sequence_ulong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceULong that will be copied.
     */
    eProsima_user_DllExport SequenceULong& operator =(
            SequenceULong&& x) noexcept
    {

        m_var_sequence_ulong = std::move(x.m_var_sequence_ulong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceULong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceULong& x) const
    {
        return (m_var_sequence_ulong == x.m_var_sequence_ulong);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceULong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceULong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_ulong
     * @param _var_sequence_ulong New value to be copied in member var_sequence_ulong
     */
    eProsima_user_DllExport void var_sequence_ulong(
            const std::vector<uint32_t>& _var_sequence_ulong)
    {
        m_var_sequence_ulong = _var_sequence_ulong;
    }

    /*!
     * @brief This function moves the value in member var_sequence_ulong
     * @param _var_sequence_ulong New value to be moved in member var_sequence_ulong
     */
    eProsima_user_DllExport void var_sequence_ulong(
            std::vector<uint32_t>&& _var_sequence_ulong)
    {
        m_var_sequence_ulong = std::move(_var_sequence_ulong);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_ulong
     * @return Constant reference to member var_sequence_ulong
     */
    eProsima_user_DllExport const std::vector<uint32_t>& var_sequence_ulong() const
    {
        return m_var_sequence_ulong;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_ulong
     * @return Reference to member var_sequence_ulong
     */
    eProsima_user_DllExport std::vector<uint32_t>& var_sequence_ulong()
    {
        return m_var_sequence_ulong;
    }



private:

    std::vector<uint32_t> m_var_sequence_ulong;

};
/*!
 * @brief This class represents the structure SequenceLongLong defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceLongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceLongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceLongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceLongLong that will be copied.
     */
    eProsima_user_DllExport SequenceLongLong(
            const SequenceLongLong& x)
    {
                    m_var_sequence_longlong = x.m_var_sequence_longlong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceLongLong that will be copied.
     */
    eProsima_user_DllExport SequenceLongLong(
            SequenceLongLong&& x) noexcept
    {
        m_var_sequence_longlong = std::move(x.m_var_sequence_longlong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceLongLong that will be copied.
     */
    eProsima_user_DllExport SequenceLongLong& operator =(
            const SequenceLongLong& x)
    {

                    m_var_sequence_longlong = x.m_var_sequence_longlong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceLongLong that will be copied.
     */
    eProsima_user_DllExport SequenceLongLong& operator =(
            SequenceLongLong&& x) noexcept
    {

        m_var_sequence_longlong = std::move(x.m_var_sequence_longlong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceLongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceLongLong& x) const
    {
        return (m_var_sequence_longlong == x.m_var_sequence_longlong);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceLongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceLongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_longlong
     * @param _var_sequence_longlong New value to be copied in member var_sequence_longlong
     */
    eProsima_user_DllExport void var_sequence_longlong(
            const std::vector<int64_t>& _var_sequence_longlong)
    {
        m_var_sequence_longlong = _var_sequence_longlong;
    }

    /*!
     * @brief This function moves the value in member var_sequence_longlong
     * @param _var_sequence_longlong New value to be moved in member var_sequence_longlong
     */
    eProsima_user_DllExport void var_sequence_longlong(
            std::vector<int64_t>&& _var_sequence_longlong)
    {
        m_var_sequence_longlong = std::move(_var_sequence_longlong);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_longlong
     * @return Constant reference to member var_sequence_longlong
     */
    eProsima_user_DllExport const std::vector<int64_t>& var_sequence_longlong() const
    {
        return m_var_sequence_longlong;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_longlong
     * @return Reference to member var_sequence_longlong
     */
    eProsima_user_DllExport std::vector<int64_t>& var_sequence_longlong()
    {
        return m_var_sequence_longlong;
    }



private:

    std::vector<int64_t> m_var_sequence_longlong;

};
/*!
 * @brief This class represents the structure SequenceULongLong defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceULongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceULongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceULongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceULongLong that will be copied.
     */
    eProsima_user_DllExport SequenceULongLong(
            const SequenceULongLong& x)
    {
                    m_var_sequence_ulonglong = x.m_var_sequence_ulonglong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceULongLong that will be copied.
     */
    eProsima_user_DllExport SequenceULongLong(
            SequenceULongLong&& x) noexcept
    {
        m_var_sequence_ulonglong = std::move(x.m_var_sequence_ulonglong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceULongLong that will be copied.
     */
    eProsima_user_DllExport SequenceULongLong& operator =(
            const SequenceULongLong& x)
    {

                    m_var_sequence_ulonglong = x.m_var_sequence_ulonglong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceULongLong that will be copied.
     */
    eProsima_user_DllExport SequenceULongLong& operator =(
            SequenceULongLong&& x) noexcept
    {

        m_var_sequence_ulonglong = std::move(x.m_var_sequence_ulonglong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceULongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceULongLong& x) const
    {
        return (m_var_sequence_ulonglong == x.m_var_sequence_ulonglong);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceULongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceULongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_ulonglong
     * @param _var_sequence_ulonglong New value to be copied in member var_sequence_ulonglong
     */
    eProsima_user_DllExport void var_sequence_ulonglong(
            const std::vector<uint64_t>& _var_sequence_ulonglong)
    {
        m_var_sequence_ulonglong = _var_sequence_ulonglong;
    }

    /*!
     * @brief This function moves the value in member var_sequence_ulonglong
     * @param _var_sequence_ulonglong New value to be moved in member var_sequence_ulonglong
     */
    eProsima_user_DllExport void var_sequence_ulonglong(
            std::vector<uint64_t>&& _var_sequence_ulonglong)
    {
        m_var_sequence_ulonglong = std::move(_var_sequence_ulonglong);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_ulonglong
     * @return Constant reference to member var_sequence_ulonglong
     */
    eProsima_user_DllExport const std::vector<uint64_t>& var_sequence_ulonglong() const
    {
        return m_var_sequence_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_ulonglong
     * @return Reference to member var_sequence_ulonglong
     */
    eProsima_user_DllExport std::vector<uint64_t>& var_sequence_ulonglong()
    {
        return m_var_sequence_ulonglong;
    }



private:

    std::vector<uint64_t> m_var_sequence_ulonglong;

};
/*!
 * @brief This class represents the structure SequenceFloat defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceFloat
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceFloat()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceFloat()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceFloat that will be copied.
     */
    eProsima_user_DllExport SequenceFloat(
            const SequenceFloat& x)
    {
                    m_var_sequence_float = x.m_var_sequence_float;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceFloat that will be copied.
     */
    eProsima_user_DllExport SequenceFloat(
            SequenceFloat&& x) noexcept
    {
        m_var_sequence_float = std::move(x.m_var_sequence_float);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceFloat that will be copied.
     */
    eProsima_user_DllExport SequenceFloat& operator =(
            const SequenceFloat& x)
    {

                    m_var_sequence_float = x.m_var_sequence_float;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceFloat that will be copied.
     */
    eProsima_user_DllExport SequenceFloat& operator =(
            SequenceFloat&& x) noexcept
    {

        m_var_sequence_float = std::move(x.m_var_sequence_float);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceFloat object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceFloat& x) const
    {
        return (m_var_sequence_float == x.m_var_sequence_float);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceFloat object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceFloat& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_float
     * @param _var_sequence_float New value to be copied in member var_sequence_float
     */
    eProsima_user_DllExport void var_sequence_float(
            const std::vector<float>& _var_sequence_float)
    {
        m_var_sequence_float = _var_sequence_float;
    }

    /*!
     * @brief This function moves the value in member var_sequence_float
     * @param _var_sequence_float New value to be moved in member var_sequence_float
     */
    eProsima_user_DllExport void var_sequence_float(
            std::vector<float>&& _var_sequence_float)
    {
        m_var_sequence_float = std::move(_var_sequence_float);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_float
     * @return Constant reference to member var_sequence_float
     */
    eProsima_user_DllExport const std::vector<float>& var_sequence_float() const
    {
        return m_var_sequence_float;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_float
     * @return Reference to member var_sequence_float
     */
    eProsima_user_DllExport std::vector<float>& var_sequence_float()
    {
        return m_var_sequence_float;
    }



private:

    std::vector<float> m_var_sequence_float;

};
/*!
 * @brief This class represents the structure SequenceDouble defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceDouble that will be copied.
     */
    eProsima_user_DllExport SequenceDouble(
            const SequenceDouble& x)
    {
                    m_var_sequence_double = x.m_var_sequence_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceDouble that will be copied.
     */
    eProsima_user_DllExport SequenceDouble(
            SequenceDouble&& x) noexcept
    {
        m_var_sequence_double = std::move(x.m_var_sequence_double);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceDouble that will be copied.
     */
    eProsima_user_DllExport SequenceDouble& operator =(
            const SequenceDouble& x)
    {

                    m_var_sequence_double = x.m_var_sequence_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceDouble that will be copied.
     */
    eProsima_user_DllExport SequenceDouble& operator =(
            SequenceDouble&& x) noexcept
    {

        m_var_sequence_double = std::move(x.m_var_sequence_double);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceDouble& x) const
    {
        return (m_var_sequence_double == x.m_var_sequence_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_double
     * @param _var_sequence_double New value to be copied in member var_sequence_double
     */
    eProsima_user_DllExport void var_sequence_double(
            const std::vector<double>& _var_sequence_double)
    {
        m_var_sequence_double = _var_sequence_double;
    }

    /*!
     * @brief This function moves the value in member var_sequence_double
     * @param _var_sequence_double New value to be moved in member var_sequence_double
     */
    eProsima_user_DllExport void var_sequence_double(
            std::vector<double>&& _var_sequence_double)
    {
        m_var_sequence_double = std::move(_var_sequence_double);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_double
     * @return Constant reference to member var_sequence_double
     */
    eProsima_user_DllExport const std::vector<double>& var_sequence_double() const
    {
        return m_var_sequence_double;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_double
     * @return Reference to member var_sequence_double
     */
    eProsima_user_DllExport std::vector<double>& var_sequence_double()
    {
        return m_var_sequence_double;
    }



private:

    std::vector<double> m_var_sequence_double;

};
/*!
 * @brief This class represents the structure SequenceLongDouble defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceLongDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceLongDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceLongDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceLongDouble that will be copied.
     */
    eProsima_user_DllExport SequenceLongDouble(
            const SequenceLongDouble& x)
    {
                    m_var_sequence_longdouble = x.m_var_sequence_longdouble;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceLongDouble that will be copied.
     */
    eProsima_user_DllExport SequenceLongDouble(
            SequenceLongDouble&& x) noexcept
    {
        m_var_sequence_longdouble = std::move(x.m_var_sequence_longdouble);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceLongDouble that will be copied.
     */
    eProsima_user_DllExport SequenceLongDouble& operator =(
            const SequenceLongDouble& x)
    {

                    m_var_sequence_longdouble = x.m_var_sequence_longdouble;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceLongDouble that will be copied.
     */
    eProsima_user_DllExport SequenceLongDouble& operator =(
            SequenceLongDouble&& x) noexcept
    {

        m_var_sequence_longdouble = std::move(x.m_var_sequence_longdouble);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceLongDouble& x) const
    {
        return (m_var_sequence_longdouble == x.m_var_sequence_longdouble);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceLongDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_longdouble
     * @param _var_sequence_longdouble New value to be copied in member var_sequence_longdouble
     */
    eProsima_user_DllExport void var_sequence_longdouble(
            const std::vector<long double>& _var_sequence_longdouble)
    {
        m_var_sequence_longdouble = _var_sequence_longdouble;
    }

    /*!
     * @brief This function moves the value in member var_sequence_longdouble
     * @param _var_sequence_longdouble New value to be moved in member var_sequence_longdouble
     */
    eProsima_user_DllExport void var_sequence_longdouble(
            std::vector<long double>&& _var_sequence_longdouble)
    {
        m_var_sequence_longdouble = std::move(_var_sequence_longdouble);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_longdouble
     * @return Constant reference to member var_sequence_longdouble
     */
    eProsima_user_DllExport const std::vector<long double>& var_sequence_longdouble() const
    {
        return m_var_sequence_longdouble;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_longdouble
     * @return Reference to member var_sequence_longdouble
     */
    eProsima_user_DllExport std::vector<long double>& var_sequence_longdouble()
    {
        return m_var_sequence_longdouble;
    }



private:

    std::vector<long double> m_var_sequence_longdouble;

};
/*!
 * @brief This class represents the structure SequenceBoolean defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceBoolean
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceBoolean()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceBoolean()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceBoolean that will be copied.
     */
    eProsima_user_DllExport SequenceBoolean(
            const SequenceBoolean& x)
    {
                    m_var_sequence_boolean = x.m_var_sequence_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceBoolean that will be copied.
     */
    eProsima_user_DllExport SequenceBoolean(
            SequenceBoolean&& x) noexcept
    {
        m_var_sequence_boolean = std::move(x.m_var_sequence_boolean);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceBoolean that will be copied.
     */
    eProsima_user_DllExport SequenceBoolean& operator =(
            const SequenceBoolean& x)
    {

                    m_var_sequence_boolean = x.m_var_sequence_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceBoolean that will be copied.
     */
    eProsima_user_DllExport SequenceBoolean& operator =(
            SequenceBoolean&& x) noexcept
    {

        m_var_sequence_boolean = std::move(x.m_var_sequence_boolean);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceBoolean object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceBoolean& x) const
    {
        return (m_var_sequence_boolean == x.m_var_sequence_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceBoolean object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceBoolean& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_boolean
     * @param _var_sequence_boolean New value to be copied in member var_sequence_boolean
     */
    eProsima_user_DllExport void var_sequence_boolean(
            const std::vector<bool>& _var_sequence_boolean)
    {
        m_var_sequence_boolean = _var_sequence_boolean;
    }

    /*!
     * @brief This function moves the value in member var_sequence_boolean
     * @param _var_sequence_boolean New value to be moved in member var_sequence_boolean
     */
    eProsima_user_DllExport void var_sequence_boolean(
            std::vector<bool>&& _var_sequence_boolean)
    {
        m_var_sequence_boolean = std::move(_var_sequence_boolean);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_boolean
     * @return Constant reference to member var_sequence_boolean
     */
    eProsima_user_DllExport const std::vector<bool>& var_sequence_boolean() const
    {
        return m_var_sequence_boolean;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_boolean
     * @return Reference to member var_sequence_boolean
     */
    eProsima_user_DllExport std::vector<bool>& var_sequence_boolean()
    {
        return m_var_sequence_boolean;
    }



private:

    std::vector<bool> m_var_sequence_boolean;

};
/*!
 * @brief This class represents the structure SequenceOctet defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceOctet
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceOctet()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceOctet()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceOctet that will be copied.
     */
    eProsima_user_DllExport SequenceOctet(
            const SequenceOctet& x)
    {
                    m_var_sequence_octet = x.m_var_sequence_octet;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceOctet that will be copied.
     */
    eProsima_user_DllExport SequenceOctet(
            SequenceOctet&& x) noexcept
    {
        m_var_sequence_octet = std::move(x.m_var_sequence_octet);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceOctet that will be copied.
     */
    eProsima_user_DllExport SequenceOctet& operator =(
            const SequenceOctet& x)
    {

                    m_var_sequence_octet = x.m_var_sequence_octet;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceOctet that will be copied.
     */
    eProsima_user_DllExport SequenceOctet& operator =(
            SequenceOctet&& x) noexcept
    {

        m_var_sequence_octet = std::move(x.m_var_sequence_octet);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceOctet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceOctet& x) const
    {
        return (m_var_sequence_octet == x.m_var_sequence_octet);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceOctet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceOctet& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_octet
     * @param _var_sequence_octet New value to be copied in member var_sequence_octet
     */
    eProsima_user_DllExport void var_sequence_octet(
            const std::vector<uint8_t>& _var_sequence_octet)
    {
        m_var_sequence_octet = _var_sequence_octet;
    }

    /*!
     * @brief This function moves the value in member var_sequence_octet
     * @param _var_sequence_octet New value to be moved in member var_sequence_octet
     */
    eProsima_user_DllExport void var_sequence_octet(
            std::vector<uint8_t>&& _var_sequence_octet)
    {
        m_var_sequence_octet = std::move(_var_sequence_octet);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_octet
     * @return Constant reference to member var_sequence_octet
     */
    eProsima_user_DllExport const std::vector<uint8_t>& var_sequence_octet() const
    {
        return m_var_sequence_octet;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_octet
     * @return Reference to member var_sequence_octet
     */
    eProsima_user_DllExport std::vector<uint8_t>& var_sequence_octet()
    {
        return m_var_sequence_octet;
    }



private:

    std::vector<uint8_t> m_var_sequence_octet;

};
/*!
 * @brief This class represents the structure SequenceChar defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceChar that will be copied.
     */
    eProsima_user_DllExport SequenceChar(
            const SequenceChar& x)
    {
                    m_var_sequence_char = x.m_var_sequence_char;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceChar that will be copied.
     */
    eProsima_user_DllExport SequenceChar(
            SequenceChar&& x) noexcept
    {
        m_var_sequence_char = std::move(x.m_var_sequence_char);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceChar that will be copied.
     */
    eProsima_user_DllExport SequenceChar& operator =(
            const SequenceChar& x)
    {

                    m_var_sequence_char = x.m_var_sequence_char;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceChar that will be copied.
     */
    eProsima_user_DllExport SequenceChar& operator =(
            SequenceChar&& x) noexcept
    {

        m_var_sequence_char = std::move(x.m_var_sequence_char);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceChar& x) const
    {
        return (m_var_sequence_char == x.m_var_sequence_char);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_char
     * @param _var_sequence_char New value to be copied in member var_sequence_char
     */
    eProsima_user_DllExport void var_sequence_char(
            const std::vector<char>& _var_sequence_char)
    {
        m_var_sequence_char = _var_sequence_char;
    }

    /*!
     * @brief This function moves the value in member var_sequence_char
     * @param _var_sequence_char New value to be moved in member var_sequence_char
     */
    eProsima_user_DllExport void var_sequence_char(
            std::vector<char>&& _var_sequence_char)
    {
        m_var_sequence_char = std::move(_var_sequence_char);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_char
     * @return Constant reference to member var_sequence_char
     */
    eProsima_user_DllExport const std::vector<char>& var_sequence_char() const
    {
        return m_var_sequence_char;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_char
     * @return Reference to member var_sequence_char
     */
    eProsima_user_DllExport std::vector<char>& var_sequence_char()
    {
        return m_var_sequence_char;
    }



private:

    std::vector<char> m_var_sequence_char;

};
/*!
 * @brief This class represents the structure SequenceWChar defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceWChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceWChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceWChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceWChar that will be copied.
     */
    eProsima_user_DllExport SequenceWChar(
            const SequenceWChar& x)
    {
                    m_var_sequence_wchar = x.m_var_sequence_wchar;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceWChar that will be copied.
     */
    eProsima_user_DllExport SequenceWChar(
            SequenceWChar&& x) noexcept
    {
        m_var_sequence_wchar = std::move(x.m_var_sequence_wchar);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceWChar that will be copied.
     */
    eProsima_user_DllExport SequenceWChar& operator =(
            const SequenceWChar& x)
    {

                    m_var_sequence_wchar = x.m_var_sequence_wchar;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceWChar that will be copied.
     */
    eProsima_user_DllExport SequenceWChar& operator =(
            SequenceWChar&& x) noexcept
    {

        m_var_sequence_wchar = std::move(x.m_var_sequence_wchar);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceWChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceWChar& x) const
    {
        return (m_var_sequence_wchar == x.m_var_sequence_wchar);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceWChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceWChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_wchar
     * @param _var_sequence_wchar New value to be copied in member var_sequence_wchar
     */
    eProsima_user_DllExport void var_sequence_wchar(
            const std::vector<wchar_t>& _var_sequence_wchar)
    {
        m_var_sequence_wchar = _var_sequence_wchar;
    }

    /*!
     * @brief This function moves the value in member var_sequence_wchar
     * @param _var_sequence_wchar New value to be moved in member var_sequence_wchar
     */
    eProsima_user_DllExport void var_sequence_wchar(
            std::vector<wchar_t>&& _var_sequence_wchar)
    {
        m_var_sequence_wchar = std::move(_var_sequence_wchar);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_wchar
     * @return Constant reference to member var_sequence_wchar
     */
    eProsima_user_DllExport const std::vector<wchar_t>& var_sequence_wchar() const
    {
        return m_var_sequence_wchar;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_wchar
     * @return Reference to member var_sequence_wchar
     */
    eProsima_user_DllExport std::vector<wchar_t>& var_sequence_wchar()
    {
        return m_var_sequence_wchar;
    }



private:

    std::vector<wchar_t> m_var_sequence_wchar;

};
/*!
 * @brief This class represents the structure SequenceString defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceString that will be copied.
     */
    eProsima_user_DllExport SequenceString(
            const SequenceString& x)
    {
                    m_var_sequence_string = x.m_var_sequence_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceString that will be copied.
     */
    eProsima_user_DllExport SequenceString(
            SequenceString&& x) noexcept
    {
        m_var_sequence_string = std::move(x.m_var_sequence_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceString that will be copied.
     */
    eProsima_user_DllExport SequenceString& operator =(
            const SequenceString& x)
    {

                    m_var_sequence_string = x.m_var_sequence_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceString that will be copied.
     */
    eProsima_user_DllExport SequenceString& operator =(
            SequenceString&& x) noexcept
    {

        m_var_sequence_string = std::move(x.m_var_sequence_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceString& x) const
    {
        return (m_var_sequence_string == x.m_var_sequence_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_string
     * @param _var_sequence_string New value to be copied in member var_sequence_string
     */
    eProsima_user_DllExport void var_sequence_string(
            const std::vector<std::string>& _var_sequence_string)
    {
        m_var_sequence_string = _var_sequence_string;
    }

    /*!
     * @brief This function moves the value in member var_sequence_string
     * @param _var_sequence_string New value to be moved in member var_sequence_string
     */
    eProsima_user_DllExport void var_sequence_string(
            std::vector<std::string>&& _var_sequence_string)
    {
        m_var_sequence_string = std::move(_var_sequence_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_string
     * @return Constant reference to member var_sequence_string
     */
    eProsima_user_DllExport const std::vector<std::string>& var_sequence_string() const
    {
        return m_var_sequence_string;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_string
     * @return Reference to member var_sequence_string
     */
    eProsima_user_DllExport std::vector<std::string>& var_sequence_string()
    {
        return m_var_sequence_string;
    }



private:

    std::vector<std::string> m_var_sequence_string;

};
/*!
 * @brief This class represents the structure SequenceWString defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceWString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceWString that will be copied.
     */
    eProsima_user_DllExport SequenceWString(
            const SequenceWString& x)
    {
                    m_var_sequence_wstring = x.m_var_sequence_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceWString that will be copied.
     */
    eProsima_user_DllExport SequenceWString(
            SequenceWString&& x) noexcept
    {
        m_var_sequence_wstring = std::move(x.m_var_sequence_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceWString that will be copied.
     */
    eProsima_user_DllExport SequenceWString& operator =(
            const SequenceWString& x)
    {

                    m_var_sequence_wstring = x.m_var_sequence_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceWString that will be copied.
     */
    eProsima_user_DllExport SequenceWString& operator =(
            SequenceWString&& x) noexcept
    {

        m_var_sequence_wstring = std::move(x.m_var_sequence_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceWString& x) const
    {
        return (m_var_sequence_wstring == x.m_var_sequence_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_wstring
     * @param _var_sequence_wstring New value to be copied in member var_sequence_wstring
     */
    eProsima_user_DllExport void var_sequence_wstring(
            const std::vector<std::wstring>& _var_sequence_wstring)
    {
        m_var_sequence_wstring = _var_sequence_wstring;
    }

    /*!
     * @brief This function moves the value in member var_sequence_wstring
     * @param _var_sequence_wstring New value to be moved in member var_sequence_wstring
     */
    eProsima_user_DllExport void var_sequence_wstring(
            std::vector<std::wstring>&& _var_sequence_wstring)
    {
        m_var_sequence_wstring = std::move(_var_sequence_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_wstring
     * @return Constant reference to member var_sequence_wstring
     */
    eProsima_user_DllExport const std::vector<std::wstring>& var_sequence_wstring() const
    {
        return m_var_sequence_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_wstring
     * @return Reference to member var_sequence_wstring
     */
    eProsima_user_DllExport std::vector<std::wstring>& var_sequence_wstring()
    {
        return m_var_sequence_wstring;
    }



private:

    std::vector<std::wstring> m_var_sequence_wstring;

};
/*!
 * @brief This class represents the structure SequenceStringBounded defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceStringBounded
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceStringBounded()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceStringBounded()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceStringBounded that will be copied.
     */
    eProsima_user_DllExport SequenceStringBounded(
            const SequenceStringBounded& x)
    {
                    m_var_sequence_bounded_string = x.m_var_sequence_bounded_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceStringBounded that will be copied.
     */
    eProsima_user_DllExport SequenceStringBounded(
            SequenceStringBounded&& x) noexcept
    {
        m_var_sequence_bounded_string = std::move(x.m_var_sequence_bounded_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceStringBounded that will be copied.
     */
    eProsima_user_DllExport SequenceStringBounded& operator =(
            const SequenceStringBounded& x)
    {

                    m_var_sequence_bounded_string = x.m_var_sequence_bounded_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceStringBounded that will be copied.
     */
    eProsima_user_DllExport SequenceStringBounded& operator =(
            SequenceStringBounded&& x) noexcept
    {

        m_var_sequence_bounded_string = std::move(x.m_var_sequence_bounded_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceStringBounded object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceStringBounded& x) const
    {
        return (m_var_sequence_bounded_string == x.m_var_sequence_bounded_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceStringBounded object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceStringBounded& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_bounded_string
     * @param _var_sequence_bounded_string New value to be copied in member var_sequence_bounded_string
     */
    eProsima_user_DllExport void var_sequence_bounded_string(
            const std::vector<Inner_alias_bounded_string_helper>& _var_sequence_bounded_string)
    {
        m_var_sequence_bounded_string = _var_sequence_bounded_string;
    }

    /*!
     * @brief This function moves the value in member var_sequence_bounded_string
     * @param _var_sequence_bounded_string New value to be moved in member var_sequence_bounded_string
     */
    eProsima_user_DllExport void var_sequence_bounded_string(
            std::vector<Inner_alias_bounded_string_helper>&& _var_sequence_bounded_string)
    {
        m_var_sequence_bounded_string = std::move(_var_sequence_bounded_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_bounded_string
     * @return Constant reference to member var_sequence_bounded_string
     */
    eProsima_user_DllExport const std::vector<Inner_alias_bounded_string_helper>& var_sequence_bounded_string() const
    {
        return m_var_sequence_bounded_string;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_bounded_string
     * @return Reference to member var_sequence_bounded_string
     */
    eProsima_user_DllExport std::vector<Inner_alias_bounded_string_helper>& var_sequence_bounded_string()
    {
        return m_var_sequence_bounded_string;
    }



private:

    std::vector<Inner_alias_bounded_string_helper> m_var_sequence_bounded_string;

};
/*!
 * @brief This class represents the structure SequenceWStringBounded defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceWStringBounded
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceWStringBounded()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceWStringBounded()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceWStringBounded that will be copied.
     */
    eProsima_user_DllExport SequenceWStringBounded(
            const SequenceWStringBounded& x)
    {
                    m_var_sequence_bounded_wstring = x.m_var_sequence_bounded_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceWStringBounded that will be copied.
     */
    eProsima_user_DllExport SequenceWStringBounded(
            SequenceWStringBounded&& x) noexcept
    {
        m_var_sequence_bounded_wstring = std::move(x.m_var_sequence_bounded_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceWStringBounded that will be copied.
     */
    eProsima_user_DllExport SequenceWStringBounded& operator =(
            const SequenceWStringBounded& x)
    {

                    m_var_sequence_bounded_wstring = x.m_var_sequence_bounded_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceWStringBounded that will be copied.
     */
    eProsima_user_DllExport SequenceWStringBounded& operator =(
            SequenceWStringBounded&& x) noexcept
    {

        m_var_sequence_bounded_wstring = std::move(x.m_var_sequence_bounded_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceWStringBounded object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceWStringBounded& x) const
    {
        return (m_var_sequence_bounded_wstring == x.m_var_sequence_bounded_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceWStringBounded object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceWStringBounded& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_bounded_wstring
     * @param _var_sequence_bounded_wstring New value to be copied in member var_sequence_bounded_wstring
     */
    eProsima_user_DllExport void var_sequence_bounded_wstring(
            const std::vector<Inner_alias_bounded_wstring_helper>& _var_sequence_bounded_wstring)
    {
        m_var_sequence_bounded_wstring = _var_sequence_bounded_wstring;
    }

    /*!
     * @brief This function moves the value in member var_sequence_bounded_wstring
     * @param _var_sequence_bounded_wstring New value to be moved in member var_sequence_bounded_wstring
     */
    eProsima_user_DllExport void var_sequence_bounded_wstring(
            std::vector<Inner_alias_bounded_wstring_helper>&& _var_sequence_bounded_wstring)
    {
        m_var_sequence_bounded_wstring = std::move(_var_sequence_bounded_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_bounded_wstring
     * @return Constant reference to member var_sequence_bounded_wstring
     */
    eProsima_user_DllExport const std::vector<Inner_alias_bounded_wstring_helper>& var_sequence_bounded_wstring() const
    {
        return m_var_sequence_bounded_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_bounded_wstring
     * @return Reference to member var_sequence_bounded_wstring
     */
    eProsima_user_DllExport std::vector<Inner_alias_bounded_wstring_helper>& var_sequence_bounded_wstring()
    {
        return m_var_sequence_bounded_wstring;
    }



private:

    std::vector<Inner_alias_bounded_wstring_helper> m_var_sequence_bounded_wstring;

};
/*!
 * @brief This class represents the structure SequenceEnum defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceEnum
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceEnum()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceEnum()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceEnum that will be copied.
     */
    eProsima_user_DllExport SequenceEnum(
            const SequenceEnum& x)
    {
                    m_var_sequence_enum = x.m_var_sequence_enum;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceEnum that will be copied.
     */
    eProsima_user_DllExport SequenceEnum(
            SequenceEnum&& x) noexcept
    {
        m_var_sequence_enum = std::move(x.m_var_sequence_enum);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceEnum that will be copied.
     */
    eProsima_user_DllExport SequenceEnum& operator =(
            const SequenceEnum& x)
    {

                    m_var_sequence_enum = x.m_var_sequence_enum;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceEnum that will be copied.
     */
    eProsima_user_DllExport SequenceEnum& operator =(
            SequenceEnum&& x) noexcept
    {

        m_var_sequence_enum = std::move(x.m_var_sequence_enum);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceEnum object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceEnum& x) const
    {
        return (m_var_sequence_enum == x.m_var_sequence_enum);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceEnum object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceEnum& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_enum
     * @param _var_sequence_enum New value to be copied in member var_sequence_enum
     */
    eProsima_user_DllExport void var_sequence_enum(
            const std::vector<InnerEnumHelper>& _var_sequence_enum)
    {
        m_var_sequence_enum = _var_sequence_enum;
    }

    /*!
     * @brief This function moves the value in member var_sequence_enum
     * @param _var_sequence_enum New value to be moved in member var_sequence_enum
     */
    eProsima_user_DllExport void var_sequence_enum(
            std::vector<InnerEnumHelper>&& _var_sequence_enum)
    {
        m_var_sequence_enum = std::move(_var_sequence_enum);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_enum
     * @return Constant reference to member var_sequence_enum
     */
    eProsima_user_DllExport const std::vector<InnerEnumHelper>& var_sequence_enum() const
    {
        return m_var_sequence_enum;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_enum
     * @return Reference to member var_sequence_enum
     */
    eProsima_user_DllExport std::vector<InnerEnumHelper>& var_sequence_enum()
    {
        return m_var_sequence_enum;
    }



private:

    std::vector<InnerEnumHelper> m_var_sequence_enum;

};
/*!
 * @brief This class represents the structure SequenceBitMask defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceBitMask
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceBitMask()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceBitMask()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceBitMask that will be copied.
     */
    eProsima_user_DllExport SequenceBitMask(
            const SequenceBitMask& x)
    {
                    m_var_sequence_bitmask = x.m_var_sequence_bitmask;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceBitMask that will be copied.
     */
    eProsima_user_DllExport SequenceBitMask(
            SequenceBitMask&& x) noexcept
    {
        m_var_sequence_bitmask = std::move(x.m_var_sequence_bitmask);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceBitMask that will be copied.
     */
    eProsima_user_DllExport SequenceBitMask& operator =(
            const SequenceBitMask& x)
    {

                    m_var_sequence_bitmask = x.m_var_sequence_bitmask;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceBitMask that will be copied.
     */
    eProsima_user_DllExport SequenceBitMask& operator =(
            SequenceBitMask&& x) noexcept
    {

        m_var_sequence_bitmask = std::move(x.m_var_sequence_bitmask);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceBitMask object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceBitMask& x) const
    {
        return (m_var_sequence_bitmask == x.m_var_sequence_bitmask);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceBitMask object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceBitMask& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_bitmask
     * @param _var_sequence_bitmask New value to be copied in member var_sequence_bitmask
     */
    eProsima_user_DllExport void var_sequence_bitmask(
            const std::vector<InnerBitMaskHelper>& _var_sequence_bitmask)
    {
        m_var_sequence_bitmask = _var_sequence_bitmask;
    }

    /*!
     * @brief This function moves the value in member var_sequence_bitmask
     * @param _var_sequence_bitmask New value to be moved in member var_sequence_bitmask
     */
    eProsima_user_DllExport void var_sequence_bitmask(
            std::vector<InnerBitMaskHelper>&& _var_sequence_bitmask)
    {
        m_var_sequence_bitmask = std::move(_var_sequence_bitmask);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_bitmask
     * @return Constant reference to member var_sequence_bitmask
     */
    eProsima_user_DllExport const std::vector<InnerBitMaskHelper>& var_sequence_bitmask() const
    {
        return m_var_sequence_bitmask;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_bitmask
     * @return Reference to member var_sequence_bitmask
     */
    eProsima_user_DllExport std::vector<InnerBitMaskHelper>& var_sequence_bitmask()
    {
        return m_var_sequence_bitmask;
    }



private:

    std::vector<InnerBitMaskHelper> m_var_sequence_bitmask;

};
/*!
 * @brief This class represents the structure SequenceAlias defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceAlias
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceAlias()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceAlias()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceAlias that will be copied.
     */
    eProsima_user_DllExport SequenceAlias(
            const SequenceAlias& x)
    {
                    m_var_sequence_alias = x.m_var_sequence_alias;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceAlias that will be copied.
     */
    eProsima_user_DllExport SequenceAlias(
            SequenceAlias&& x) noexcept
    {
        m_var_sequence_alias = std::move(x.m_var_sequence_alias);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceAlias that will be copied.
     */
    eProsima_user_DllExport SequenceAlias& operator =(
            const SequenceAlias& x)
    {

                    m_var_sequence_alias = x.m_var_sequence_alias;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceAlias that will be copied.
     */
    eProsima_user_DllExport SequenceAlias& operator =(
            SequenceAlias&& x) noexcept
    {

        m_var_sequence_alias = std::move(x.m_var_sequence_alias);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceAlias object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceAlias& x) const
    {
        return (m_var_sequence_alias == x.m_var_sequence_alias);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceAlias object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceAlias& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_alias
     * @param _var_sequence_alias New value to be copied in member var_sequence_alias
     */
    eProsima_user_DllExport void var_sequence_alias(
            const std::vector<InnerAliasHelper>& _var_sequence_alias)
    {
        m_var_sequence_alias = _var_sequence_alias;
    }

    /*!
     * @brief This function moves the value in member var_sequence_alias
     * @param _var_sequence_alias New value to be moved in member var_sequence_alias
     */
    eProsima_user_DllExport void var_sequence_alias(
            std::vector<InnerAliasHelper>&& _var_sequence_alias)
    {
        m_var_sequence_alias = std::move(_var_sequence_alias);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_alias
     * @return Constant reference to member var_sequence_alias
     */
    eProsima_user_DllExport const std::vector<InnerAliasHelper>& var_sequence_alias() const
    {
        return m_var_sequence_alias;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_alias
     * @return Reference to member var_sequence_alias
     */
    eProsima_user_DllExport std::vector<InnerAliasHelper>& var_sequence_alias()
    {
        return m_var_sequence_alias;
    }



private:

    std::vector<InnerAliasHelper> m_var_sequence_alias;

};
/*!
 * @brief This class represents the structure SequenceShortArray defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceShortArray
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceShortArray()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceShortArray()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceShortArray that will be copied.
     */
    eProsima_user_DllExport SequenceShortArray(
            const SequenceShortArray& x)
    {
                    m_var_sequence_short_array = x.m_var_sequence_short_array;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceShortArray that will be copied.
     */
    eProsima_user_DllExport SequenceShortArray(
            SequenceShortArray&& x) noexcept
    {
        m_var_sequence_short_array = std::move(x.m_var_sequence_short_array);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceShortArray that will be copied.
     */
    eProsima_user_DllExport SequenceShortArray& operator =(
            const SequenceShortArray& x)
    {

                    m_var_sequence_short_array = x.m_var_sequence_short_array;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceShortArray that will be copied.
     */
    eProsima_user_DllExport SequenceShortArray& operator =(
            SequenceShortArray&& x) noexcept
    {

        m_var_sequence_short_array = std::move(x.m_var_sequence_short_array);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceShortArray object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceShortArray& x) const
    {
        return (m_var_sequence_short_array == x.m_var_sequence_short_array);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceShortArray object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceShortArray& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_short_array
     * @param _var_sequence_short_array New value to be copied in member var_sequence_short_array
     */
    eProsima_user_DllExport void var_sequence_short_array(
            const std::vector<Inner_alias_array_helper>& _var_sequence_short_array)
    {
        m_var_sequence_short_array = _var_sequence_short_array;
    }

    /*!
     * @brief This function moves the value in member var_sequence_short_array
     * @param _var_sequence_short_array New value to be moved in member var_sequence_short_array
     */
    eProsima_user_DllExport void var_sequence_short_array(
            std::vector<Inner_alias_array_helper>&& _var_sequence_short_array)
    {
        m_var_sequence_short_array = std::move(_var_sequence_short_array);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_short_array
     * @return Constant reference to member var_sequence_short_array
     */
    eProsima_user_DllExport const std::vector<Inner_alias_array_helper>& var_sequence_short_array() const
    {
        return m_var_sequence_short_array;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_short_array
     * @return Reference to member var_sequence_short_array
     */
    eProsima_user_DllExport std::vector<Inner_alias_array_helper>& var_sequence_short_array()
    {
        return m_var_sequence_short_array;
    }



private:

    std::vector<Inner_alias_array_helper> m_var_sequence_short_array;

};
/*!
 * @brief This class represents the structure SequenceSequence defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceSequence
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceSequence()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceSequence()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceSequence that will be copied.
     */
    eProsima_user_DllExport SequenceSequence(
            const SequenceSequence& x)
    {
                    m_var_sequence_sequence = x.m_var_sequence_sequence;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceSequence that will be copied.
     */
    eProsima_user_DllExport SequenceSequence(
            SequenceSequence&& x) noexcept
    {
        m_var_sequence_sequence = std::move(x.m_var_sequence_sequence);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceSequence that will be copied.
     */
    eProsima_user_DllExport SequenceSequence& operator =(
            const SequenceSequence& x)
    {

                    m_var_sequence_sequence = x.m_var_sequence_sequence;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceSequence that will be copied.
     */
    eProsima_user_DllExport SequenceSequence& operator =(
            SequenceSequence&& x) noexcept
    {

        m_var_sequence_sequence = std::move(x.m_var_sequence_sequence);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceSequence object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceSequence& x) const
    {
        return (m_var_sequence_sequence == x.m_var_sequence_sequence);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceSequence object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceSequence& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_sequence
     * @param _var_sequence_sequence New value to be copied in member var_sequence_sequence
     */
    eProsima_user_DllExport void var_sequence_sequence(
            const std::vector<Inner_alias_sequence_helper>& _var_sequence_sequence)
    {
        m_var_sequence_sequence = _var_sequence_sequence;
    }

    /*!
     * @brief This function moves the value in member var_sequence_sequence
     * @param _var_sequence_sequence New value to be moved in member var_sequence_sequence
     */
    eProsima_user_DllExport void var_sequence_sequence(
            std::vector<Inner_alias_sequence_helper>&& _var_sequence_sequence)
    {
        m_var_sequence_sequence = std::move(_var_sequence_sequence);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_sequence
     * @return Constant reference to member var_sequence_sequence
     */
    eProsima_user_DllExport const std::vector<Inner_alias_sequence_helper>& var_sequence_sequence() const
    {
        return m_var_sequence_sequence;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_sequence
     * @return Reference to member var_sequence_sequence
     */
    eProsima_user_DllExport std::vector<Inner_alias_sequence_helper>& var_sequence_sequence()
    {
        return m_var_sequence_sequence;
    }



private:

    std::vector<Inner_alias_sequence_helper> m_var_sequence_sequence;

};
/*!
 * @brief This class represents the structure SequenceMap defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceMap
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceMap()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceMap()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceMap that will be copied.
     */
    eProsima_user_DllExport SequenceMap(
            const SequenceMap& x)
    {
                    m_var_sequence_map = x.m_var_sequence_map;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceMap that will be copied.
     */
    eProsima_user_DllExport SequenceMap(
            SequenceMap&& x) noexcept
    {
        m_var_sequence_map = std::move(x.m_var_sequence_map);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceMap that will be copied.
     */
    eProsima_user_DllExport SequenceMap& operator =(
            const SequenceMap& x)
    {

                    m_var_sequence_map = x.m_var_sequence_map;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceMap that will be copied.
     */
    eProsima_user_DllExport SequenceMap& operator =(
            SequenceMap&& x) noexcept
    {

        m_var_sequence_map = std::move(x.m_var_sequence_map);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceMap object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceMap& x) const
    {
        return (m_var_sequence_map == x.m_var_sequence_map);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceMap object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceMap& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_map
     * @param _var_sequence_map New value to be copied in member var_sequence_map
     */
    eProsima_user_DllExport void var_sequence_map(
            const std::vector<Inner_alias_map_helper>& _var_sequence_map)
    {
        m_var_sequence_map = _var_sequence_map;
    }

    /*!
     * @brief This function moves the value in member var_sequence_map
     * @param _var_sequence_map New value to be moved in member var_sequence_map
     */
    eProsima_user_DllExport void var_sequence_map(
            std::vector<Inner_alias_map_helper>&& _var_sequence_map)
    {
        m_var_sequence_map = std::move(_var_sequence_map);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_map
     * @return Constant reference to member var_sequence_map
     */
    eProsima_user_DllExport const std::vector<Inner_alias_map_helper>& var_sequence_map() const
    {
        return m_var_sequence_map;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_map
     * @return Reference to member var_sequence_map
     */
    eProsima_user_DllExport std::vector<Inner_alias_map_helper>& var_sequence_map()
    {
        return m_var_sequence_map;
    }



private:

    std::vector<Inner_alias_map_helper> m_var_sequence_map;

};
/*!
 * @brief This class represents the structure SequenceUnion defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceUnion
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceUnion()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceUnion()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceUnion that will be copied.
     */
    eProsima_user_DllExport SequenceUnion(
            const SequenceUnion& x)
    {
                    m_var_sequence_union = x.m_var_sequence_union;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceUnion that will be copied.
     */
    eProsima_user_DllExport SequenceUnion(
            SequenceUnion&& x) noexcept
    {
        m_var_sequence_union = std::move(x.m_var_sequence_union);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceUnion that will be copied.
     */
    eProsima_user_DllExport SequenceUnion& operator =(
            const SequenceUnion& x)
    {

                    m_var_sequence_union = x.m_var_sequence_union;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceUnion that will be copied.
     */
    eProsima_user_DllExport SequenceUnion& operator =(
            SequenceUnion&& x) noexcept
    {

        m_var_sequence_union = std::move(x.m_var_sequence_union);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceUnion object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceUnion& x) const
    {
        return (m_var_sequence_union == x.m_var_sequence_union);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceUnion object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceUnion& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_union
     * @param _var_sequence_union New value to be copied in member var_sequence_union
     */
    eProsima_user_DllExport void var_sequence_union(
            const std::vector<InnerUnionHelper>& _var_sequence_union)
    {
        m_var_sequence_union = _var_sequence_union;
    }

    /*!
     * @brief This function moves the value in member var_sequence_union
     * @param _var_sequence_union New value to be moved in member var_sequence_union
     */
    eProsima_user_DllExport void var_sequence_union(
            std::vector<InnerUnionHelper>&& _var_sequence_union)
    {
        m_var_sequence_union = std::move(_var_sequence_union);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_union
     * @return Constant reference to member var_sequence_union
     */
    eProsima_user_DllExport const std::vector<InnerUnionHelper>& var_sequence_union() const
    {
        return m_var_sequence_union;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_union
     * @return Reference to member var_sequence_union
     */
    eProsima_user_DllExport std::vector<InnerUnionHelper>& var_sequence_union()
    {
        return m_var_sequence_union;
    }



private:

    std::vector<InnerUnionHelper> m_var_sequence_union;

};
/*!
 * @brief This class represents the structure SequenceStructure defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceStructure
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceStructure()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceStructure()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceStructure that will be copied.
     */
    eProsima_user_DllExport SequenceStructure(
            const SequenceStructure& x)
    {
                    m_var_sequence_structure = x.m_var_sequence_structure;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceStructure that will be copied.
     */
    eProsima_user_DllExport SequenceStructure(
            SequenceStructure&& x) noexcept
    {
        m_var_sequence_structure = std::move(x.m_var_sequence_structure);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceStructure that will be copied.
     */
    eProsima_user_DllExport SequenceStructure& operator =(
            const SequenceStructure& x)
    {

                    m_var_sequence_structure = x.m_var_sequence_structure;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceStructure that will be copied.
     */
    eProsima_user_DllExport SequenceStructure& operator =(
            SequenceStructure&& x) noexcept
    {

        m_var_sequence_structure = std::move(x.m_var_sequence_structure);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceStructure object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceStructure& x) const
    {
        return (m_var_sequence_structure == x.m_var_sequence_structure);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceStructure object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceStructure& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_structure
     * @param _var_sequence_structure New value to be copied in member var_sequence_structure
     */
    eProsima_user_DllExport void var_sequence_structure(
            const std::vector<InnerStructureHelper>& _var_sequence_structure)
    {
        m_var_sequence_structure = _var_sequence_structure;
    }

    /*!
     * @brief This function moves the value in member var_sequence_structure
     * @param _var_sequence_structure New value to be moved in member var_sequence_structure
     */
    eProsima_user_DllExport void var_sequence_structure(
            std::vector<InnerStructureHelper>&& _var_sequence_structure)
    {
        m_var_sequence_structure = std::move(_var_sequence_structure);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_structure
     * @return Constant reference to member var_sequence_structure
     */
    eProsima_user_DllExport const std::vector<InnerStructureHelper>& var_sequence_structure() const
    {
        return m_var_sequence_structure;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_structure
     * @return Reference to member var_sequence_structure
     */
    eProsima_user_DllExport std::vector<InnerStructureHelper>& var_sequence_structure()
    {
        return m_var_sequence_structure;
    }



private:

    std::vector<InnerStructureHelper> m_var_sequence_structure;

};
/*!
 * @brief This class represents the structure SequenceBitset defined by the user in the IDL file.
 * @ingroup sequences
 */
class SequenceBitset
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceBitset()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceBitset()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceBitset that will be copied.
     */
    eProsima_user_DllExport SequenceBitset(
            const SequenceBitset& x)
    {
                    m_var_sequence_bitset = x.m_var_sequence_bitset;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceBitset that will be copied.
     */
    eProsima_user_DllExport SequenceBitset(
            SequenceBitset&& x) noexcept
    {
        m_var_sequence_bitset = std::move(x.m_var_sequence_bitset);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceBitset that will be copied.
     */
    eProsima_user_DllExport SequenceBitset& operator =(
            const SequenceBitset& x)
    {

                    m_var_sequence_bitset = x.m_var_sequence_bitset;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceBitset that will be copied.
     */
    eProsima_user_DllExport SequenceBitset& operator =(
            SequenceBitset&& x) noexcept
    {

        m_var_sequence_bitset = std::move(x.m_var_sequence_bitset);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceBitset object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceBitset& x) const
    {
        return (m_var_sequence_bitset == x.m_var_sequence_bitset);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceBitset object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceBitset& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_bitset
     * @param _var_sequence_bitset New value to be copied in member var_sequence_bitset
     */
    eProsima_user_DllExport void var_sequence_bitset(
            const std::vector<InnerBitsetHelper>& _var_sequence_bitset)
    {
        m_var_sequence_bitset = _var_sequence_bitset;
    }

    /*!
     * @brief This function moves the value in member var_sequence_bitset
     * @param _var_sequence_bitset New value to be moved in member var_sequence_bitset
     */
    eProsima_user_DllExport void var_sequence_bitset(
            std::vector<InnerBitsetHelper>&& _var_sequence_bitset)
    {
        m_var_sequence_bitset = std::move(_var_sequence_bitset);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_bitset
     * @return Constant reference to member var_sequence_bitset
     */
    eProsima_user_DllExport const std::vector<InnerBitsetHelper>& var_sequence_bitset() const
    {
        return m_var_sequence_bitset;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_bitset
     * @return Reference to member var_sequence_bitset
     */
    eProsima_user_DllExport std::vector<InnerBitsetHelper>& var_sequence_bitset()
    {
        return m_var_sequence_bitset;
    }



private:

    std::vector<InnerBitsetHelper> m_var_sequence_bitset;

};
/*!
 * @brief This class represents the structure BoundedSmallSequences defined by the user in the IDL file.
 * @ingroup sequences
 */
class BoundedSmallSequences
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport BoundedSmallSequences()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~BoundedSmallSequences()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object BoundedSmallSequences that will be copied.
     */
    eProsima_user_DllExport BoundedSmallSequences(
            const BoundedSmallSequences& x)
    {
                    m_var_sequence_small = x.m_var_sequence_small;

                    m_var_unbounded_string_small_bounded_sequence = x.m_var_unbounded_string_small_bounded_sequence;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object BoundedSmallSequences that will be copied.
     */
    eProsima_user_DllExport BoundedSmallSequences(
            BoundedSmallSequences&& x) noexcept
    {
        m_var_sequence_small = std::move(x.m_var_sequence_small);
        m_var_unbounded_string_small_bounded_sequence = std::move(x.m_var_unbounded_string_small_bounded_sequence);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object BoundedSmallSequences that will be copied.
     */
    eProsima_user_DllExport BoundedSmallSequences& operator =(
            const BoundedSmallSequences& x)
    {

                    m_var_sequence_small = x.m_var_sequence_small;

                    m_var_unbounded_string_small_bounded_sequence = x.m_var_unbounded_string_small_bounded_sequence;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object BoundedSmallSequences that will be copied.
     */
    eProsima_user_DllExport BoundedSmallSequences& operator =(
            BoundedSmallSequences&& x) noexcept
    {

        m_var_sequence_small = std::move(x.m_var_sequence_small);
        m_var_unbounded_string_small_bounded_sequence = std::move(x.m_var_unbounded_string_small_bounded_sequence);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x BoundedSmallSequences object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const BoundedSmallSequences& x) const
    {
        return (m_var_sequence_small == x.m_var_sequence_small &&
           m_var_unbounded_string_small_bounded_sequence == x.m_var_unbounded_string_small_bounded_sequence);
    }

    /*!
     * @brief Comparison operator.
     * @param x BoundedSmallSequences object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const BoundedSmallSequences& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_small
     * @param _var_sequence_small New value to be copied in member var_sequence_small
     */
    eProsima_user_DllExport void var_sequence_small(
            const std::vector<int16_t>& _var_sequence_small)
    {
        m_var_sequence_small = _var_sequence_small;
    }

    /*!
     * @brief This function moves the value in member var_sequence_small
     * @param _var_sequence_small New value to be moved in member var_sequence_small
     */
    eProsima_user_DllExport void var_sequence_small(
            std::vector<int16_t>&& _var_sequence_small)
    {
        m_var_sequence_small = std::move(_var_sequence_small);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_small
     * @return Constant reference to member var_sequence_small
     */
    eProsima_user_DllExport const std::vector<int16_t>& var_sequence_small() const
    {
        return m_var_sequence_small;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_small
     * @return Reference to member var_sequence_small
     */
    eProsima_user_DllExport std::vector<int16_t>& var_sequence_small()
    {
        return m_var_sequence_small;
    }


    /*!
     * @brief This function copies the value in member var_unbounded_string_small_bounded_sequence
     * @param _var_unbounded_string_small_bounded_sequence New value to be copied in member var_unbounded_string_small_bounded_sequence
     */
    eProsima_user_DllExport void var_unbounded_string_small_bounded_sequence(
            const std::vector<std::string>& _var_unbounded_string_small_bounded_sequence)
    {
        m_var_unbounded_string_small_bounded_sequence = _var_unbounded_string_small_bounded_sequence;
    }

    /*!
     * @brief This function moves the value in member var_unbounded_string_small_bounded_sequence
     * @param _var_unbounded_string_small_bounded_sequence New value to be moved in member var_unbounded_string_small_bounded_sequence
     */
    eProsima_user_DllExport void var_unbounded_string_small_bounded_sequence(
            std::vector<std::string>&& _var_unbounded_string_small_bounded_sequence)
    {
        m_var_unbounded_string_small_bounded_sequence = std::move(_var_unbounded_string_small_bounded_sequence);
    }

    /*!
     * @brief This function returns a constant reference to member var_unbounded_string_small_bounded_sequence
     * @return Constant reference to member var_unbounded_string_small_bounded_sequence
     */
    eProsima_user_DllExport const std::vector<std::string>& var_unbounded_string_small_bounded_sequence() const
    {
        return m_var_unbounded_string_small_bounded_sequence;
    }

    /*!
     * @brief This function returns a reference to member var_unbounded_string_small_bounded_sequence
     * @return Reference to member var_unbounded_string_small_bounded_sequence
     */
    eProsima_user_DllExport std::vector<std::string>& var_unbounded_string_small_bounded_sequence()
    {
        return m_var_unbounded_string_small_bounded_sequence;
    }



private:

    std::vector<int16_t> m_var_sequence_small;
    std::vector<std::string> m_var_unbounded_string_small_bounded_sequence;

};
/*!
 * @brief This class represents the structure BoundedBigSequences defined by the user in the IDL file.
 * @ingroup sequences
 */
class BoundedBigSequences
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport BoundedBigSequences()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~BoundedBigSequences()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object BoundedBigSequences that will be copied.
     */
    eProsima_user_DllExport BoundedBigSequences(
            const BoundedBigSequences& x)
    {
                    m_var_sequence_big = x.m_var_sequence_big;

                    m_var_unbounded_string_large_bounded_sequence = x.m_var_unbounded_string_large_bounded_sequence;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object BoundedBigSequences that will be copied.
     */
    eProsima_user_DllExport BoundedBigSequences(
            BoundedBigSequences&& x) noexcept
    {
        m_var_sequence_big = std::move(x.m_var_sequence_big);
        m_var_unbounded_string_large_bounded_sequence = std::move(x.m_var_unbounded_string_large_bounded_sequence);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object BoundedBigSequences that will be copied.
     */
    eProsima_user_DllExport BoundedBigSequences& operator =(
            const BoundedBigSequences& x)
    {

                    m_var_sequence_big = x.m_var_sequence_big;

                    m_var_unbounded_string_large_bounded_sequence = x.m_var_unbounded_string_large_bounded_sequence;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object BoundedBigSequences that will be copied.
     */
    eProsima_user_DllExport BoundedBigSequences& operator =(
            BoundedBigSequences&& x) noexcept
    {

        m_var_sequence_big = std::move(x.m_var_sequence_big);
        m_var_unbounded_string_large_bounded_sequence = std::move(x.m_var_unbounded_string_large_bounded_sequence);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x BoundedBigSequences object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const BoundedBigSequences& x) const
    {
        return (m_var_sequence_big == x.m_var_sequence_big &&
           m_var_unbounded_string_large_bounded_sequence == x.m_var_unbounded_string_large_bounded_sequence);
    }

    /*!
     * @brief Comparison operator.
     * @param x BoundedBigSequences object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const BoundedBigSequences& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence_big
     * @param _var_sequence_big New value to be copied in member var_sequence_big
     */
    eProsima_user_DllExport void var_sequence_big(
            const std::vector<int16_t>& _var_sequence_big)
    {
        m_var_sequence_big = _var_sequence_big;
    }

    /*!
     * @brief This function moves the value in member var_sequence_big
     * @param _var_sequence_big New value to be moved in member var_sequence_big
     */
    eProsima_user_DllExport void var_sequence_big(
            std::vector<int16_t>&& _var_sequence_big)
    {
        m_var_sequence_big = std::move(_var_sequence_big);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence_big
     * @return Constant reference to member var_sequence_big
     */
    eProsima_user_DllExport const std::vector<int16_t>& var_sequence_big() const
    {
        return m_var_sequence_big;
    }

    /*!
     * @brief This function returns a reference to member var_sequence_big
     * @return Reference to member var_sequence_big
     */
    eProsima_user_DllExport std::vector<int16_t>& var_sequence_big()
    {
        return m_var_sequence_big;
    }


    /*!
     * @brief This function copies the value in member var_unbounded_string_large_bounded_sequence
     * @param _var_unbounded_string_large_bounded_sequence New value to be copied in member var_unbounded_string_large_bounded_sequence
     */
    eProsima_user_DllExport void var_unbounded_string_large_bounded_sequence(
            const std::vector<std::string>& _var_unbounded_string_large_bounded_sequence)
    {
        m_var_unbounded_string_large_bounded_sequence = _var_unbounded_string_large_bounded_sequence;
    }

    /*!
     * @brief This function moves the value in member var_unbounded_string_large_bounded_sequence
     * @param _var_unbounded_string_large_bounded_sequence New value to be moved in member var_unbounded_string_large_bounded_sequence
     */
    eProsima_user_DllExport void var_unbounded_string_large_bounded_sequence(
            std::vector<std::string>&& _var_unbounded_string_large_bounded_sequence)
    {
        m_var_unbounded_string_large_bounded_sequence = std::move(_var_unbounded_string_large_bounded_sequence);
    }

    /*!
     * @brief This function returns a constant reference to member var_unbounded_string_large_bounded_sequence
     * @return Constant reference to member var_unbounded_string_large_bounded_sequence
     */
    eProsima_user_DllExport const std::vector<std::string>& var_unbounded_string_large_bounded_sequence() const
    {
        return m_var_unbounded_string_large_bounded_sequence;
    }

    /*!
     * @brief This function returns a reference to member var_unbounded_string_large_bounded_sequence
     * @return Reference to member var_unbounded_string_large_bounded_sequence
     */
    eProsima_user_DllExport std::vector<std::string>& var_unbounded_string_large_bounded_sequence()
    {
        return m_var_unbounded_string_large_bounded_sequence;
    }



private:

    std::vector<int16_t> m_var_sequence_big;
    std::vector<std::string> m_var_unbounded_string_large_bounded_sequence;

};
namespace Common_Module {

typedef char My_Char;

typedef std::vector<My_Char> My_String;


} // namespace Common_Module
namespace NoCommon_Module {

typedef Common_Module::My_String My_AliasString;

typedef std::vector<My_AliasString> My_SequenceString;

/*!
 * @brief This class represents the structure My_Structure defined by the user in the IDL file.
 * @ingroup sequences
 */
class My_Structure
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport My_Structure()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~My_Structure()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object My_Structure that will be copied.
     */
    eProsima_user_DllExport My_Structure(
            const My_Structure& x)
    {
                    m_list = x.m_list;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object My_Structure that will be copied.
     */
    eProsima_user_DllExport My_Structure(
            My_Structure&& x) noexcept
    {
        m_list = std::move(x.m_list);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object My_Structure that will be copied.
     */
    eProsima_user_DllExport My_Structure& operator =(
            const My_Structure& x)
    {

                    m_list = x.m_list;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object My_Structure that will be copied.
     */
    eProsima_user_DllExport My_Structure& operator =(
            My_Structure&& x) noexcept
    {

        m_list = std::move(x.m_list);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x My_Structure object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const My_Structure& x) const
    {
        return (m_list == x.m_list);
    }

    /*!
     * @brief Comparison operator.
     * @param x My_Structure object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const My_Structure& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member list
     * @param _list New value to be copied in member list
     */
    eProsima_user_DllExport void list(
            const My_SequenceString& _list)
    {
        m_list = _list;
    }

    /*!
     * @brief This function moves the value in member list
     * @param _list New value to be moved in member list
     */
    eProsima_user_DllExport void list(
            My_SequenceString&& _list)
    {
        m_list = std::move(_list);
    }

    /*!
     * @brief This function returns a constant reference to member list
     * @return Constant reference to member list
     */
    eProsima_user_DllExport const My_SequenceString& list() const
    {
        return m_list;
    }

    /*!
     * @brief This function returns a reference to member list
     * @return Reference to member list
     */
    eProsima_user_DllExport My_SequenceString& list()
    {
        return m_list;
    }



private:

    My_SequenceString m_list;

};

} // namespace NoCommon_Module

#endif // _FAST_DDS_GENERATED_NOCOMMON_MODULE_SEQUENCES_HPP_


