// Copyright 2019 The go-github AUTHORS. All rights reserved.
//
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated by gen-stringify-tests; DO NOT EDIT.
// Instead, please run "go generate ./..." as described here:
// https://github.com/google/go-github/blob/master/CONTRIBUTING.md#submitting-a-patch

package github

import (
	"testing"
)

func Float64(v float64) *float64 { return &v }

func TestActionsAllowed_String(t *testing.T) {
	v := ActionsAllowed{
		GithubOwnedAllowed: Bool(false),
		VerifiedAllowed:    Bool(false),
		PatternsAllowed:    []string{""},
	}
	want := `github.ActionsAllowed{GithubOwnedAllowed:false, VerifiedAllowed:false, PatternsAllowed:[""]}`
	if got := v.String(); got != want {
		t.Errorf("ActionsAllowed.String = %v, want %v", got, want)
	}
}

func TestActionsPermissions_String(t *testing.T) {
	v := ActionsPermissions{
		EnabledRepositories: String(""),
		AllowedActions:      String(""),
		SelectedActionsURL:  String(""),
	}
	want := `github.ActionsPermissions{EnabledRepositories:"", AllowedActions:"", SelectedActionsURL:""}`
	if got := v.String(); got != want {
		t.Errorf("ActionsPermissions.String = %v, want %v", got, want)
	}
}

func TestActionsPermissionsRepository_String(t *testing.T) {
	v := ActionsPermissionsRepository{
		Enabled:            Bool(false),
		AllowedActions:     String(""),
		SelectedActionsURL: String(""),
	}
	want := `github.ActionsPermissionsRepository{Enabled:false, AllowedActions:"", SelectedActionsURL:""}`
	if got := v.String(); got != want {
		t.Errorf("ActionsPermissionsRepository.String = %v, want %v", got, want)
	}
}

func TestAdminStats_String(t *testing.T) {
	v := AdminStats{
		Issues:     &IssueStats{},
		Hooks:      &HookStats{},
		Milestones: &MilestoneStats{},
		Orgs:       &OrgStats{},
		Comments:   &CommentStats{},
		Pages:      &PageStats{},
		Users:      &UserStats{},
		Gists:      &GistStats{},
		Pulls:      &PullStats{},
		Repos:      &RepoStats{},
	}
	want := `github.AdminStats{Issues:github.IssueStats{}, Hooks:github.HookStats{}, Milestones:github.MilestoneStats{}, Orgs:github.OrgStats{}, Comments:github.CommentStats{}, Pages:github.PageStats{}, Users:github.UserStats{}, Gists:github.GistStats{}, Pulls:github.PullStats{}, Repos:github.RepoStats{}}`
	if got := v.String(); got != want {
		t.Errorf("AdminStats.String = %v, want %v", got, want)
	}
}

func TestAdvancedSecurity_String(t *testing.T) {
	v := AdvancedSecurity{
		Status: String(""),
	}
	want := `github.AdvancedSecurity{Status:""}`
	if got := v.String(); got != want {
		t.Errorf("AdvancedSecurity.String = %v, want %v", got, want)
	}
}

func TestAuthorization_String(t *testing.T) {
	v := Authorization{
		ID:             Int64(0),
		URL:            String(""),
		Scopes:         []Scope{ScopeNone},
		Token:          String(""),
		TokenLastEight: String(""),
		HashedToken:    String(""),
		App:            &AuthorizationApp{},
		Note:           String(""),
		NoteURL:        String(""),
		UpdatedAt:      &Timestamp{},
		CreatedAt:      &Timestamp{},
		Fingerprint:    String(""),
		User:           &User{},
	}
	want := `github.Authorization{ID:0, URL:"", Scopes:["(no scope)"], Token:"", TokenLastEight:"", HashedToken:"", App:github.AuthorizationApp{}, Note:"", NoteURL:"", UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, Fingerprint:"", User:github.User{}}`
	if got := v.String(); got != want {
		t.Errorf("Authorization.String = %v, want %v", got, want)
	}
}

func TestAuthorizationApp_String(t *testing.T) {
	v := AuthorizationApp{
		URL:      String(""),
		Name:     String(""),
		ClientID: String(""),
	}
	want := `github.AuthorizationApp{URL:"", Name:"", ClientID:""}`
	if got := v.String(); got != want {
		t.Errorf("AuthorizationApp.String = %v, want %v", got, want)
	}
}

func TestAuthorizationRequest_String(t *testing.T) {
	v := AuthorizationRequest{
		Scopes:       []Scope{ScopeNone},
		Note:         String(""),
		NoteURL:      String(""),
		ClientID:     String(""),
		ClientSecret: String(""),
		Fingerprint:  String(""),
	}
	want := `github.AuthorizationRequest{Scopes:["(no scope)"], Note:"", NoteURL:"", ClientID:"", ClientSecret:"", Fingerprint:""}`
	if got := v.String(); got != want {
		t.Errorf("AuthorizationRequest.String = %v, want %v", got, want)
	}
}

func TestAuthorizationUpdateRequest_String(t *testing.T) {
	v := AuthorizationUpdateRequest{
		Scopes:       []string{""},
		AddScopes:    []string{""},
		RemoveScopes: []string{""},
		Note:         String(""),
		NoteURL:      String(""),
		Fingerprint:  String(""),
	}
	want := `github.AuthorizationUpdateRequest{Scopes:[""], AddScopes:[""], RemoveScopes:[""], Note:"", NoteURL:"", Fingerprint:""}`
	if got := v.String(); got != want {
		t.Errorf("AuthorizationUpdateRequest.String = %v, want %v", got, want)
	}
}

func TestCheckRun_String(t *testing.T) {
	v := CheckRun{
		ID:          Int64(0),
		NodeID:      String(""),
		HeadSHA:     String(""),
		ExternalID:  String(""),
		URL:         String(""),
		HTMLURL:     String(""),
		DetailsURL:  String(""),
		Status:      String(""),
		Conclusion:  String(""),
		StartedAt:   &Timestamp{},
		CompletedAt: &Timestamp{},
		Output:      &CheckRunOutput{},
		Name:        String(""),
		CheckSuite:  &CheckSuite{},
		App:         &App{},
	}
	want := `github.CheckRun{ID:0, NodeID:"", HeadSHA:"", ExternalID:"", URL:"", HTMLURL:"", DetailsURL:"", Status:"", Conclusion:"", StartedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, CompletedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, Output:github.CheckRunOutput{}, Name:"", CheckSuite:github.CheckSuite{}, App:github.App{}}`
	if got := v.String(); got != want {
		t.Errorf("CheckRun.String = %v, want %v", got, want)
	}
}

func TestCheckSuite_String(t *testing.T) {
	v := CheckSuite{
		ID:         Int64(0),
		NodeID:     String(""),
		HeadBranch: String(""),
		HeadSHA:    String(""),
		URL:        String(""),
		BeforeSHA:  String(""),
		AfterSHA:   String(""),
		Status:     String(""),
		Conclusion: String(""),
		CreatedAt:  &Timestamp{},
		UpdatedAt:  &Timestamp{},
		App:        &App{},
		Repository: &Repository{},
		HeadCommit: &Commit{},
	}
	want := `github.CheckSuite{ID:0, NodeID:"", HeadBranch:"", HeadSHA:"", URL:"", BeforeSHA:"", AfterSHA:"", Status:"", Conclusion:"", CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, App:github.App{}, Repository:github.Repository{}, HeadCommit:github.Commit{}}`
	if got := v.String(); got != want {
		t.Errorf("CheckSuite.String = %v, want %v", got, want)
	}
}

func TestCodeOfConduct_String(t *testing.T) {
	v := CodeOfConduct{
		Name: String(""),
		Key:  String(""),
		URL:  String(""),
		Body: String(""),
	}
	want := `github.CodeOfConduct{Name:"", Key:"", URL:"", Body:""}`
	if got := v.String(); got != want {
		t.Errorf("CodeOfConduct.String = %v, want %v", got, want)
	}
}

func TestCodeResult_String(t *testing.T) {
	v := CodeResult{
		Name:       String(""),
		Path:       String(""),
		SHA:        String(""),
		HTMLURL:    String(""),
		Repository: &Repository{},
	}
	want := `github.CodeResult{Name:"", Path:"", SHA:"", HTMLURL:"", Repository:github.Repository{}}`
	if got := v.String(); got != want {
		t.Errorf("CodeResult.String = %v, want %v", got, want)
	}
}

func TestCombinedStatus_String(t *testing.T) {
	v := CombinedStatus{
		State:         String(""),
		Name:          String(""),
		SHA:           String(""),
		TotalCount:    Int(0),
		CommitURL:     String(""),
		RepositoryURL: String(""),
	}
	want := `github.CombinedStatus{State:"", Name:"", SHA:"", TotalCount:0, CommitURL:"", RepositoryURL:""}`
	if got := v.String(); got != want {
		t.Errorf("CombinedStatus.String = %v, want %v", got, want)
	}
}

func TestCommentStats_String(t *testing.T) {
	v := CommentStats{
		TotalCommitComments:      Int(0),
		TotalGistComments:        Int(0),
		TotalIssueComments:       Int(0),
		TotalPullRequestComments: Int(0),
	}
	want := `github.CommentStats{TotalCommitComments:0, TotalGistComments:0, TotalIssueComments:0, TotalPullRequestComments:0}`
	if got := v.String(); got != want {
		t.Errorf("CommentStats.String = %v, want %v", got, want)
	}
}

func TestCommit_String(t *testing.T) {
	v := Commit{
		SHA:          String(""),
		Author:       &CommitAuthor{},
		Committer:    &CommitAuthor{},
		Message:      String(""),
		Tree:         &Tree{},
		Stats:        &CommitStats{},
		HTMLURL:      String(""),
		URL:          String(""),
		Verification: &SignatureVerification{},
		NodeID:       String(""),
		CommentCount: Int(0),
	}
	want := `github.Commit{SHA:"", Author:github.CommitAuthor{}, Committer:github.CommitAuthor{}, Message:"", Tree:github.Tree{}, Stats:github.CommitStats{}, HTMLURL:"", URL:"", Verification:github.SignatureVerification{}, NodeID:"", CommentCount:0}`
	if got := v.String(); got != want {
		t.Errorf("Commit.String = %v, want %v", got, want)
	}
}

func TestCommitAuthor_String(t *testing.T) {
	v := CommitAuthor{
		Name:  String(""),
		Email: String(""),
		Login: String(""),
	}
	want := `github.CommitAuthor{Name:"", Email:"", Login:""}`
	if got := v.String(); got != want {
		t.Errorf("CommitAuthor.String = %v, want %v", got, want)
	}
}

func TestCommitFile_String(t *testing.T) {
	v := CommitFile{
		SHA:              String(""),
		Filename:         String(""),
		Additions:        Int(0),
		Deletions:        Int(0),
		Changes:          Int(0),
		Status:           String(""),
		Patch:            String(""),
		BlobURL:          String(""),
		RawURL:           String(""),
		ContentsURL:      String(""),
		PreviousFilename: String(""),
	}
	want := `github.CommitFile{SHA:"", Filename:"", Additions:0, Deletions:0, Changes:0, Status:"", Patch:"", BlobURL:"", RawURL:"", ContentsURL:"", PreviousFilename:""}`
	if got := v.String(); got != want {
		t.Errorf("CommitFile.String = %v, want %v", got, want)
	}
}

func TestCommitStats_String(t *testing.T) {
	v := CommitStats{
		Additions: Int(0),
		Deletions: Int(0),
		Total:     Int(0),
	}
	want := `github.CommitStats{Additions:0, Deletions:0, Total:0}`
	if got := v.String(); got != want {
		t.Errorf("CommitStats.String = %v, want %v", got, want)
	}
}

func TestCommitsComparison_String(t *testing.T) {
	v := CommitsComparison{
		BaseCommit:      &RepositoryCommit{},
		MergeBaseCommit: &RepositoryCommit{},
		Status:          String(""),
		AheadBy:         Int(0),
		BehindBy:        Int(0),
		TotalCommits:    Int(0),
		HTMLURL:         String(""),
		PermalinkURL:    String(""),
		DiffURL:         String(""),
		PatchURL:        String(""),
		URL:             String(""),
	}
	want := `github.CommitsComparison{BaseCommit:github.RepositoryCommit{}, MergeBaseCommit:github.RepositoryCommit{}, Status:"", AheadBy:0, BehindBy:0, TotalCommits:0, HTMLURL:"", PermalinkURL:"", DiffURL:"", PatchURL:"", URL:""}`
	if got := v.String(); got != want {
		t.Errorf("CommitsComparison.String = %v, want %v", got, want)
	}
}

func TestContributorStats_String(t *testing.T) {
	v := ContributorStats{
		Author: &Contributor{},
		Total:  Int(0),
	}
	want := `github.ContributorStats{Author:github.Contributor{}, Total:0}`
	if got := v.String(); got != want {
		t.Errorf("ContributorStats.String = %v, want %v", got, want)
	}
}

func TestDiscussionComment_String(t *testing.T) {
	v := DiscussionComment{
		Author:        &User{},
		Body:          String(""),
		BodyHTML:      String(""),
		BodyVersion:   String(""),
		CreatedAt:     &Timestamp{},
		LastEditedAt:  &Timestamp{},
		DiscussionURL: String(""),
		HTMLURL:       String(""),
		NodeID:        String(""),
		Number:        Int(0),
		UpdatedAt:     &Timestamp{},
		URL:           String(""),
		Reactions:     &Reactions{},
	}
	want := `github.DiscussionComment{Author:github.User{}, Body:"", BodyHTML:"", BodyVersion:"", CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, LastEditedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, DiscussionURL:"", HTMLURL:"", NodeID:"", Number:0, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, URL:"", Reactions:github.Reactions{}}`
	if got := v.String(); got != want {
		t.Errorf("DiscussionComment.String = %v, want %v", got, want)
	}
}

func TestDraftReviewComment_String(t *testing.T) {
	v := DraftReviewComment{
		Path:      String(""),
		Position:  Int(0),
		Body:      String(""),
		StartSide: String(""),
		Side:      String(""),
		StartLine: Int(0),
		Line:      Int(0),
	}
	want := `github.DraftReviewComment{Path:"", Position:0, Body:"", StartSide:"", Side:"", StartLine:0, Line:0}`
	if got := v.String(); got != want {
		t.Errorf("DraftReviewComment.String = %v, want %v", got, want)
	}
}

func TestEnterprise_String(t *testing.T) {
	v := Enterprise{
		ID:          Int(0),
		Slug:        String(""),
		Name:        String(""),
		NodeID:      String(""),
		AvatarURL:   String(""),
		Description: String(""),
		WebsiteURL:  String(""),
		HTMLURL:     String(""),
		CreatedAt:   &Timestamp{},
		UpdatedAt:   &Timestamp{},
	}
	want := `github.Enterprise{ID:0, Slug:"", Name:"", NodeID:"", AvatarURL:"", Description:"", WebsiteURL:"", HTMLURL:"", CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}}`
	if got := v.String(); got != want {
		t.Errorf("Enterprise.String = %v, want %v", got, want)
	}
}

func TestEvent_String(t *testing.T) {
	v := Event{
		Type:   String(""),
		Public: Bool(false),
		Repo:   &Repository{},
		Actor:  &User{},
		Org:    &Organization{},
		ID:     String(""),
	}
	want := `github.Event{Type:"", Public:false, Repo:github.Repository{}, Actor:github.User{}, Org:github.Organization{}, ID:""}`
	if got := v.String(); got != want {
		t.Errorf("Event.String = %v, want %v", got, want)
	}
}

func TestGPGKey_String(t *testing.T) {
	v := GPGKey{
		ID:                Int64(0),
		PrimaryKeyID:      Int64(0),
		KeyID:             String(""),
		RawKey:            String(""),
		PublicKey:         String(""),
		CanSign:           Bool(false),
		CanEncryptComms:   Bool(false),
		CanEncryptStorage: Bool(false),
		CanCertify:        Bool(false),
	}
	want := `github.GPGKey{ID:0, PrimaryKeyID:0, KeyID:"", RawKey:"", PublicKey:"", CanSign:false, CanEncryptComms:false, CanEncryptStorage:false, CanCertify:false}`
	if got := v.String(); got != want {
		t.Errorf("GPGKey.String = %v, want %v", got, want)
	}
}

func TestGist_String(t *testing.T) {
	v := Gist{
		ID:          String(""),
		Description: String(""),
		Public:      Bool(false),
		Owner:       &User{},
		Comments:    Int(0),
		HTMLURL:     String(""),
		GitPullURL:  String(""),
		GitPushURL:  String(""),
		NodeID:      String(""),
	}
	want := `github.Gist{ID:"", Description:"", Public:false, Owner:github.User{}, Comments:0, HTMLURL:"", GitPullURL:"", GitPushURL:"", NodeID:""}`
	if got := v.String(); got != want {
		t.Errorf("Gist.String = %v, want %v", got, want)
	}
}

func TestGistComment_String(t *testing.T) {
	v := GistComment{
		ID:   Int64(0),
		URL:  String(""),
		Body: String(""),
		User: &User{},
	}
	want := `github.GistComment{ID:0, URL:"", Body:"", User:github.User{}}`
	if got := v.String(); got != want {
		t.Errorf("GistComment.String = %v, want %v", got, want)
	}
}

func TestGistCommit_String(t *testing.T) {
	v := GistCommit{
		URL:          String(""),
		Version:      String(""),
		User:         &User{},
		ChangeStatus: &CommitStats{},
		CommittedAt:  &Timestamp{},
		NodeID:       String(""),
	}
	want := `github.GistCommit{URL:"", Version:"", User:github.User{}, ChangeStatus:github.CommitStats{}, CommittedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, NodeID:""}`
	if got := v.String(); got != want {
		t.Errorf("GistCommit.String = %v, want %v", got, want)
	}
}

func TestGistFile_String(t *testing.T) {
	v := GistFile{
		Size:     Int(0),
		Filename: String(""),
		Language: String(""),
		Type:     String(""),
		RawURL:   String(""),
		Content:  String(""),
	}
	want := `github.GistFile{Size:0, Filename:"", Language:"", Type:"", RawURL:"", Content:""}`
	if got := v.String(); got != want {
		t.Errorf("GistFile.String = %v, want %v", got, want)
	}
}

func TestGistFork_String(t *testing.T) {
	v := GistFork{
		URL:       String(""),
		User:      &User{},
		ID:        String(""),
		CreatedAt: &Timestamp{},
		UpdatedAt: &Timestamp{},
		NodeID:    String(""),
	}
	want := `github.GistFork{URL:"", User:github.User{}, ID:"", CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, NodeID:""}`
	if got := v.String(); got != want {
		t.Errorf("GistFork.String = %v, want %v", got, want)
	}
}

func TestGistStats_String(t *testing.T) {
	v := GistStats{
		TotalGists:   Int(0),
		PrivateGists: Int(0),
		PublicGists:  Int(0),
	}
	want := `github.GistStats{TotalGists:0, PrivateGists:0, PublicGists:0}`
	if got := v.String(); got != want {
		t.Errorf("GistStats.String = %v, want %v", got, want)
	}
}

func TestGitObject_String(t *testing.T) {
	v := GitObject{
		Type: String(""),
		SHA:  String(""),
		URL:  String(""),
	}
	want := `github.GitObject{Type:"", SHA:"", URL:""}`
	if got := v.String(); got != want {
		t.Errorf("GitObject.String = %v, want %v", got, want)
	}
}

func TestGitignore_String(t *testing.T) {
	v := Gitignore{
		Name:   String(""),
		Source: String(""),
	}
	want := `github.Gitignore{Name:"", Source:""}`
	if got := v.String(); got != want {
		t.Errorf("Gitignore.String = %v, want %v", got, want)
	}
}

func TestGrant_String(t *testing.T) {
	v := Grant{
		ID:        Int64(0),
		URL:       String(""),
		App:       &AuthorizationApp{},
		CreatedAt: &Timestamp{},
		UpdatedAt: &Timestamp{},
		Scopes:    []string{""},
	}
	want := `github.Grant{ID:0, URL:"", App:github.AuthorizationApp{}, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, Scopes:[""]}`
	if got := v.String(); got != want {
		t.Errorf("Grant.String = %v, want %v", got, want)
	}
}

func TestHeadCommit_String(t *testing.T) {
	v := HeadCommit{
		Message:   String(""),
		Author:    &CommitAuthor{},
		URL:       String(""),
		Distinct:  Bool(false),
		SHA:       String(""),
		ID:        String(""),
		TreeID:    String(""),
		Timestamp: &Timestamp{},
		Committer: &CommitAuthor{},
		Added:     []string{""},
		Removed:   []string{""},
		Modified:  []string{""},
	}
	want := `github.HeadCommit{Message:"", Author:github.CommitAuthor{}, URL:"", Distinct:false, SHA:"", ID:"", TreeID:"", Timestamp:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, Committer:github.CommitAuthor{}, Added:[""], Removed:[""], Modified:[""]}`
	if got := v.String(); got != want {
		t.Errorf("HeadCommit.String = %v, want %v", got, want)
	}
}

func TestHook_String(t *testing.T) {
	v := Hook{
		URL:     String(""),
		ID:      Int64(0),
		Type:    String(""),
		Name:    String(""),
		TestURL: String(""),
		PingURL: String(""),
		Events:  []string{""},
		Active:  Bool(false),
	}
	want := `github.Hook{URL:"", ID:0, Type:"", Name:"", TestURL:"", PingURL:"", Events:[""], Active:false}`
	if got := v.String(); got != want {
		t.Errorf("Hook.String = %v, want %v", got, want)
	}
}

func TestHookDelivery_String(t *testing.T) {
	v := HookDelivery{
		ID:             Int64(0),
		GUID:           String(""),
		DeliveredAt:    &Timestamp{},
		Redelivery:     Bool(false),
		Duration:       Float64(0.0),
		Status:         String(""),
		StatusCode:     Int(0),
		Event:          String(""),
		Action:         String(""),
		InstallationID: Int64(0),
		RepositoryID:   Int64(0),
		Request:        &HookRequest{},
		Response:       &HookResponse{},
	}
	want := `github.HookDelivery{ID:0, GUID:"", DeliveredAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, Redelivery:false, Duration:0, Status:"", StatusCode:0, Event:"", Action:"", InstallationID:0, RepositoryID:0, Request:github.HookRequest{}, Response:github.HookResponse{}}`
	if got := v.String(); got != want {
		t.Errorf("HookDelivery.String = %v, want %v", got, want)
	}
}

func TestHookStats_String(t *testing.T) {
	v := HookStats{
		TotalHooks:    Int(0),
		ActiveHooks:   Int(0),
		InactiveHooks: Int(0),
	}
	want := `github.HookStats{TotalHooks:0, ActiveHooks:0, InactiveHooks:0}`
	if got := v.String(); got != want {
		t.Errorf("HookStats.String = %v, want %v", got, want)
	}
}

func TestImport_String(t *testing.T) {
	v := Import{
		VCSURL:          String(""),
		VCS:             String(""),
		VCSUsername:     String(""),
		VCSPassword:     String(""),
		TFVCProject:     String(""),
		UseLFS:          String(""),
		HasLargeFiles:   Bool(false),
		LargeFilesSize:  Int(0),
		LargeFilesCount: Int(0),
		Status:          String(""),
		CommitCount:     Int(0),
		StatusText:      String(""),
		AuthorsCount:    Int(0),
		Percent:         Int(0),
		PushPercent:     Int(0),
		URL:             String(""),
		HTMLURL:         String(""),
		AuthorsURL:      String(""),
		RepositoryURL:   String(""),
		Message:         String(""),
		FailedStep:      String(""),
		HumanName:       String(""),
	}
	want := `github.Import{VCSURL:"", VCS:"", VCSUsername:"", VCSPassword:"", TFVCProject:"", UseLFS:"", HasLargeFiles:false, LargeFilesSize:0, LargeFilesCount:0, Status:"", CommitCount:0, StatusText:"", AuthorsCount:0, Percent:0, PushPercent:0, URL:"", HTMLURL:"", AuthorsURL:"", RepositoryURL:"", Message:"", FailedStep:"", HumanName:""}`
	if got := v.String(); got != want {
		t.Errorf("Import.String = %v, want %v", got, want)
	}
}

func TestInstallation_String(t *testing.T) {
	v := Installation{
		ID:                     Int64(0),
		NodeID:                 String(""),
		AppID:                  Int64(0),
		AppSlug:                String(""),
		TargetID:               Int64(0),
		Account:                &User{},
		AccessTokensURL:        String(""),
		RepositoriesURL:        String(""),
		HTMLURL:                String(""),
		TargetType:             String(""),
		SingleFileName:         String(""),
		RepositorySelection:    String(""),
		Events:                 []string{""},
		SingleFilePaths:        []string{""},
		Permissions:            &InstallationPermissions{},
		CreatedAt:              &Timestamp{},
		UpdatedAt:              &Timestamp{},
		HasMultipleSingleFiles: Bool(false),
		SuspendedBy:            &User{},
		SuspendedAt:            &Timestamp{},
	}
	want := `github.Installation{ID:0, NodeID:"", AppID:0, AppSlug:"", TargetID:0, Account:github.User{}, AccessTokensURL:"", RepositoriesURL:"", HTMLURL:"", TargetType:"", SingleFileName:"", RepositorySelection:"", Events:[""], SingleFilePaths:[""], Permissions:github.InstallationPermissions{}, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, HasMultipleSingleFiles:false, SuspendedBy:github.User{}, SuspendedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}}`
	if got := v.String(); got != want {
		t.Errorf("Installation.String = %v, want %v", got, want)
	}
}

func TestInvitation_String(t *testing.T) {
	v := Invitation{
		ID:                Int64(0),
		NodeID:            String(""),
		Login:             String(""),
		Email:             String(""),
		Role:              String(""),
		Inviter:           &User{},
		TeamCount:         Int(0),
		InvitationTeamURL: String(""),
		FailedAt:          &Timestamp{},
		FailedReason:      String(""),
	}
	want := `github.Invitation{ID:0, NodeID:"", Login:"", Email:"", Role:"", Inviter:github.User{}, TeamCount:0, InvitationTeamURL:"", FailedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, FailedReason:""}`
	if got := v.String(); got != want {
		t.Errorf("Invitation.String = %v, want %v", got, want)
	}
}

func TestIssue_String(t *testing.T) {
	v := Issue{
		ID:                Int64(0),
		Number:            Int(0),
		State:             String(""),
		Locked:            Bool(false),
		Title:             String(""),
		Body:              String(""),
		AuthorAssociation: String(""),
		User:              &User{},
		Assignee:          &User{},
		Comments:          Int(0),
		ClosedBy:          &User{},
		URL:               String(""),
		HTMLURL:           String(""),
		CommentsURL:       String(""),
		EventsURL:         String(""),
		LabelsURL:         String(""),
		RepositoryURL:     String(""),
		Milestone:         &Milestone{},
		PullRequestLinks:  &PullRequestLinks{},
		Repository:        &Repository{},
		Reactions:         &Reactions{},
		NodeID:            String(""),
		ActiveLockReason:  String(""),
	}
	want := `github.Issue{ID:0, Number:0, State:"", Locked:false, Title:"", Body:"", AuthorAssociation:"", User:github.User{}, Assignee:github.User{}, Comments:0, ClosedBy:github.User{}, URL:"", HTMLURL:"", CommentsURL:"", EventsURL:"", LabelsURL:"", RepositoryURL:"", Milestone:github.Milestone{}, PullRequestLinks:github.PullRequestLinks{}, Repository:github.Repository{}, Reactions:github.Reactions{}, NodeID:"", ActiveLockReason:""}`
	if got := v.String(); got != want {
		t.Errorf("Issue.String = %v, want %v", got, want)
	}
}

func TestIssueComment_String(t *testing.T) {
	v := IssueComment{
		ID:                Int64(0),
		NodeID:            String(""),
		Body:              String(""),
		User:              &User{},
		Reactions:         &Reactions{},
		AuthorAssociation: String(""),
		URL:               String(""),
		HTMLURL:           String(""),
		IssueURL:          String(""),
	}
	want := `github.IssueComment{ID:0, NodeID:"", Body:"", User:github.User{}, Reactions:github.Reactions{}, AuthorAssociation:"", URL:"", HTMLURL:"", IssueURL:""}`
	if got := v.String(); got != want {
		t.Errorf("IssueComment.String = %v, want %v", got, want)
	}
}

func TestIssueStats_String(t *testing.T) {
	v := IssueStats{
		TotalIssues:  Int(0),
		OpenIssues:   Int(0),
		ClosedIssues: Int(0),
	}
	want := `github.IssueStats{TotalIssues:0, OpenIssues:0, ClosedIssues:0}`
	if got := v.String(); got != want {
		t.Errorf("IssueStats.String = %v, want %v", got, want)
	}
}

func TestKey_String(t *testing.T) {
	v := Key{
		ID:        Int64(0),
		Key:       String(""),
		URL:       String(""),
		Title:     String(""),
		ReadOnly:  Bool(false),
		Verified:  Bool(false),
		CreatedAt: &Timestamp{},
	}
	want := `github.Key{ID:0, Key:"", URL:"", Title:"", ReadOnly:false, Verified:false, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}}`
	if got := v.String(); got != want {
		t.Errorf("Key.String = %v, want %v", got, want)
	}
}

func TestLabel_String(t *testing.T) {
	v := Label{
		ID:          Int64(0),
		URL:         String(""),
		Name:        String(""),
		Color:       String(""),
		Description: String(""),
		Default:     Bool(false),
		NodeID:      String(""),
	}
	want := `github.Label{ID:0, URL:"", Name:"", Color:"", Description:"", Default:false, NodeID:""}`
	if got := v.String(); got != want {
		t.Errorf("Label.String = %v, want %v", got, want)
	}
}

func TestLabelResult_String(t *testing.T) {
	v := LabelResult{
		ID:          Int64(0),
		URL:         String(""),
		Name:        String(""),
		Color:       String(""),
		Default:     Bool(false),
		Description: String(""),
		Score:       Float64(0.0),
	}
	want := `github.LabelResult{ID:0, URL:"", Name:"", Color:"", Default:false, Description:"", Score:0}`
	if got := v.String(); got != want {
		t.Errorf("LabelResult.String = %v, want %v", got, want)
	}
}

func TestLargeFile_String(t *testing.T) {
	v := LargeFile{
		RefName: String(""),
		Path:    String(""),
		OID:     String(""),
		Size:    Int(0),
	}
	want := `github.LargeFile{RefName:"", Path:"", OID:"", Size:0}`
	if got := v.String(); got != want {
		t.Errorf("LargeFile.String = %v, want %v", got, want)
	}
}

func TestLicense_String(t *testing.T) {
	v := License{
		Key:            String(""),
		Name:           String(""),
		URL:            String(""),
		SPDXID:         String(""),
		HTMLURL:        String(""),
		Featured:       Bool(false),
		Description:    String(""),
		Implementation: String(""),
		Body:           String(""),
	}
	want := `github.License{Key:"", Name:"", URL:"", SPDXID:"", HTMLURL:"", Featured:false, Description:"", Implementation:"", Body:""}`
	if got := v.String(); got != want {
		t.Errorf("License.String = %v, want %v", got, want)
	}
}

func TestMembership_String(t *testing.T) {
	v := Membership{
		URL:             String(""),
		State:           String(""),
		Role:            String(""),
		OrganizationURL: String(""),
		Organization:    &Organization{},
		User:            &User{},
	}
	want := `github.Membership{URL:"", State:"", Role:"", OrganizationURL:"", Organization:github.Organization{}, User:github.User{}}`
	if got := v.String(); got != want {
		t.Errorf("Membership.String = %v, want %v", got, want)
	}
}

func TestMigration_String(t *testing.T) {
	v := Migration{
		ID:                 Int64(0),
		GUID:               String(""),
		State:              String(""),
		LockRepositories:   Bool(false),
		ExcludeAttachments: Bool(false),
		URL:                String(""),
		CreatedAt:          String(""),
		UpdatedAt:          String(""),
	}
	want := `github.Migration{ID:0, GUID:"", State:"", LockRepositories:false, ExcludeAttachments:false, URL:"", CreatedAt:"", UpdatedAt:""}`
	if got := v.String(); got != want {
		t.Errorf("Migration.String = %v, want %v", got, want)
	}
}

func TestMilestone_String(t *testing.T) {
	v := Milestone{
		URL:          String(""),
		HTMLURL:      String(""),
		LabelsURL:    String(""),
		ID:           Int64(0),
		Number:       Int(0),
		State:        String(""),
		Title:        String(""),
		Description:  String(""),
		Creator:      &User{},
		OpenIssues:   Int(0),
		ClosedIssues: Int(0),
		NodeID:       String(""),
	}
	want := `github.Milestone{URL:"", HTMLURL:"", LabelsURL:"", ID:0, Number:0, State:"", Title:"", Description:"", Creator:github.User{}, OpenIssues:0, ClosedIssues:0, NodeID:""}`
	if got := v.String(); got != want {
		t.Errorf("Milestone.String = %v, want %v", got, want)
	}
}

func TestMilestoneStats_String(t *testing.T) {
	v := MilestoneStats{
		TotalMilestones:  Int(0),
		OpenMilestones:   Int(0),
		ClosedMilestones: Int(0),
	}
	want := `github.MilestoneStats{TotalMilestones:0, OpenMilestones:0, ClosedMilestones:0}`
	if got := v.String(); got != want {
		t.Errorf("MilestoneStats.String = %v, want %v", got, want)
	}
}

func TestNewTeam_String(t *testing.T) {
	v := NewTeam{
		Name:         "",
		Description:  String(""),
		Maintainers:  []string{""},
		RepoNames:    []string{""},
		ParentTeamID: Int64(0),
		Permission:   String(""),
		Privacy:      String(""),
		LDAPDN:       String(""),
	}
	want := `github.NewTeam{Name:"", Description:"", Maintainers:[""], RepoNames:[""], ParentTeamID:0, Permission:"", Privacy:"", LDAPDN:""}`
	if got := v.String(); got != want {
		t.Errorf("NewTeam.String = %v, want %v", got, want)
	}
}

func TestOAuthAPP_String(t *testing.T) {
	v := OAuthAPP{
		URL:      String(""),
		Name:     String(""),
		ClientID: String(""),
	}
	want := `github.OAuthAPP{URL:"", Name:"", ClientID:""}`
	if got := v.String(); got != want {
		t.Errorf("OAuthAPP.String = %v, want %v", got, want)
	}
}

func TestOrgStats_String(t *testing.T) {
	v := OrgStats{
		TotalOrgs:        Int(0),
		DisabledOrgs:     Int(0),
		TotalTeams:       Int(0),
		TotalTeamMembers: Int(0),
	}
	want := `github.OrgStats{TotalOrgs:0, DisabledOrgs:0, TotalTeams:0, TotalTeamMembers:0}`
	if got := v.String(); got != want {
		t.Errorf("OrgStats.String = %v, want %v", got, want)
	}
}

func TestOrganization_String(t *testing.T) {
	v := Organization{
		Login:                                String(""),
		ID:                                   Int64(0),
		NodeID:                               String(""),
		AvatarURL:                            String(""),
		HTMLURL:                              String(""),
		Name:                                 String(""),
		Company:                              String(""),
		Blog:                                 String(""),
		Location:                             String(""),
		Email:                                String(""),
		TwitterUsername:                      String(""),
		Description:                          String(""),
		PublicRepos:                          Int(0),
		PublicGists:                          Int(0),
		Followers:                            Int(0),
		Following:                            Int(0),
		TotalPrivateRepos:                    Int(0),
		OwnedPrivateRepos:                    Int(0),
		PrivateGists:                         Int(0),
		DiskUsage:                            Int(0),
		Collaborators:                        Int(0),
		BillingEmail:                         String(""),
		Type:                                 String(""),
		Plan:                                 &Plan{},
		TwoFactorRequirementEnabled:          Bool(false),
		IsVerified:                           Bool(false),
		HasOrganizationProjects:              Bool(false),
		HasRepositoryProjects:                Bool(false),
		DefaultRepoPermission:                String(""),
		DefaultRepoSettings:                  String(""),
		MembersCanCreateRepos:                Bool(false),
		MembersCanCreatePublicRepos:          Bool(false),
		MembersCanCreatePrivateRepos:         Bool(false),
		MembersCanCreateInternalRepos:        Bool(false),
		MembersCanForkPrivateRepos:           Bool(false),
		MembersAllowedRepositoryCreationType: String(""),
		MembersCanCreatePages:                Bool(false),
		MembersCanCreatePublicPages:          Bool(false),
		MembersCanCreatePrivatePages:         Bool(false),
		WebCommitSignoffRequired:             Bool(false),
		AdvancedSecurityEnabledForNewRepos:   Bool(false),
		DependabotAlertsEnabledForNewRepos:   Bool(false),
		DependabotSecurityUpdatesEnabledForNewRepos:    Bool(false),
		DependencyGraphEnabledForNewRepos:              Bool(false),
		SecretScanningEnabledForNewRepos:               Bool(false),
		SecretScanningPushProtectionEnabledForNewRepos: Bool(false),
		URL:              String(""),
		EventsURL:        String(""),
		HooksURL:         String(""),
		IssuesURL:        String(""),
		MembersURL:       String(""),
		PublicMembersURL: String(""),
		ReposURL:         String(""),
	}
	want := `github.Organization{Login:"", ID:0, NodeID:"", AvatarURL:"", HTMLURL:"", Name:"", Company:"", Blog:"", Location:"", Email:"", TwitterUsername:"", Description:"", PublicRepos:0, PublicGists:0, Followers:0, Following:0, TotalPrivateRepos:0, OwnedPrivateRepos:0, PrivateGists:0, DiskUsage:0, Collaborators:0, BillingEmail:"", Type:"", Plan:github.Plan{}, TwoFactorRequirementEnabled:false, IsVerified:false, HasOrganizationProjects:false, HasRepositoryProjects:false, DefaultRepoPermission:"", DefaultRepoSettings:"", MembersCanCreateRepos:false, MembersCanCreatePublicRepos:false, MembersCanCreatePrivateRepos:false, MembersCanCreateInternalRepos:false, MembersCanForkPrivateRepos:false, MembersAllowedRepositoryCreationType:"", MembersCanCreatePages:false, MembersCanCreatePublicPages:false, MembersCanCreatePrivatePages:false, WebCommitSignoffRequired:false, AdvancedSecurityEnabledForNewRepos:false, DependabotAlertsEnabledForNewRepos:false, DependabotSecurityUpdatesEnabledForNewRepos:false, DependencyGraphEnabledForNewRepos:false, SecretScanningEnabledForNewRepos:false, SecretScanningPushProtectionEnabledForNewRepos:false, URL:"", EventsURL:"", HooksURL:"", IssuesURL:"", MembersURL:"", PublicMembersURL:"", ReposURL:""}`
	if got := v.String(); got != want {
		t.Errorf("Organization.String = %v, want %v", got, want)
	}
}

func TestPackage_String(t *testing.T) {
	v := Package{
		ID:             Int64(0),
		Name:           String(""),
		PackageType:    String(""),
		HTMLURL:        String(""),
		CreatedAt:      &Timestamp{},
		UpdatedAt:      &Timestamp{},
		Owner:          &User{},
		PackageVersion: &PackageVersion{},
		Registry:       &PackageRegistry{},
		URL:            String(""),
		VersionCount:   Int64(0),
		Visibility:     String(""),
		Repository:     &Repository{},
	}
	want := `github.Package{ID:0, Name:"", PackageType:"", HTMLURL:"", CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, Owner:github.User{}, PackageVersion:github.PackageVersion{}, Registry:github.PackageRegistry{}, URL:"", VersionCount:0, Visibility:"", Repository:github.Repository{}}`
	if got := v.String(); got != want {
		t.Errorf("Package.String = %v, want %v", got, want)
	}
}

func TestPackageContainerMetadata_String(t *testing.T) {
	v := PackageContainerMetadata{
		Tags: []string{""},
	}
	want := `github.PackageContainerMetadata{Tags:[""]}`
	if got := v.String(); got != want {
		t.Errorf("PackageContainerMetadata.String = %v, want %v", got, want)
	}
}

func TestPackageFile_String(t *testing.T) {
	v := PackageFile{
		DownloadURL: String(""),
		ID:          Int64(0),
		Name:        String(""),
		SHA256:      String(""),
		SHA1:        String(""),
		MD5:         String(""),
		ContentType: String(""),
		State:       String(""),
		Author:      &User{},
		Size:        Int64(0),
		CreatedAt:   &Timestamp{},
		UpdatedAt:   &Timestamp{},
	}
	want := `github.PackageFile{DownloadURL:"", ID:0, Name:"", SHA256:"", SHA1:"", MD5:"", ContentType:"", State:"", Author:github.User{}, Size:0, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}}`
	if got := v.String(); got != want {
		t.Errorf("PackageFile.String = %v, want %v", got, want)
	}
}

func TestPackageMetadata_String(t *testing.T) {
	v := PackageMetadata{
		PackageType: String(""),
		Container:   &PackageContainerMetadata{},
	}
	want := `github.PackageMetadata{PackageType:"", Container:github.PackageContainerMetadata{}}`
	if got := v.String(); got != want {
		t.Errorf("PackageMetadata.String = %v, want %v", got, want)
	}
}

func TestPackageRegistry_String(t *testing.T) {
	v := PackageRegistry{
		AboutURL: String(""),
		Name:     String(""),
		Type:     String(""),
		URL:      String(""),
		Vendor:   String(""),
	}
	want := `github.PackageRegistry{AboutURL:"", Name:"", Type:"", URL:"", Vendor:""}`
	if got := v.String(); got != want {
		t.Errorf("PackageRegistry.String = %v, want %v", got, want)
	}
}

func TestPackageRelease_String(t *testing.T) {
	v := PackageRelease{
		URL:             String(""),
		HTMLURL:         String(""),
		ID:              Int64(0),
		TagName:         String(""),
		TargetCommitish: String(""),
		Name:            String(""),
		Draft:           Bool(false),
		Author:          &User{},
		Prerelease:      Bool(false),
		CreatedAt:       &Timestamp{},
		PublishedAt:     &Timestamp{},
	}
	want := `github.PackageRelease{URL:"", HTMLURL:"", ID:0, TagName:"", TargetCommitish:"", Name:"", Draft:false, Author:github.User{}, Prerelease:false, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, PublishedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}}`
	if got := v.String(); got != want {
		t.Errorf("PackageRelease.String = %v, want %v", got, want)
	}
}

func TestPackageVersion_String(t *testing.T) {
	v := PackageVersion{
		ID:                  Int64(0),
		Version:             String(""),
		Summary:             String(""),
		Body:                String(""),
		BodyHTML:            String(""),
		Release:             &PackageRelease{},
		Manifest:            String(""),
		HTMLURL:             String(""),
		TagName:             String(""),
		TargetCommitish:     String(""),
		TargetOID:           String(""),
		Draft:               Bool(false),
		Prerelease:          Bool(false),
		CreatedAt:           &Timestamp{},
		UpdatedAt:           &Timestamp{},
		Author:              &User{},
		InstallationCommand: String(""),
		Metadata:            &PackageMetadata{},
		PackageHTMLURL:      String(""),
		Name:                String(""),
		URL:                 String(""),
	}
	want := `github.PackageVersion{ID:0, Version:"", Summary:"", Body:"", BodyHTML:"", Release:github.PackageRelease{}, Manifest:"", HTMLURL:"", TagName:"", TargetCommitish:"", TargetOID:"", Draft:false, Prerelease:false, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, Author:github.User{}, InstallationCommand:"", Metadata:github.PackageMetadata{}, PackageHTMLURL:"", Name:"", URL:""}`
	if got := v.String(); got != want {
		t.Errorf("PackageVersion.String = %v, want %v", got, want)
	}
}

func TestPageStats_String(t *testing.T) {
	v := PageStats{
		TotalPages: Int(0),
	}
	want := `github.PageStats{TotalPages:0}`
	if got := v.String(); got != want {
		t.Errorf("PageStats.String = %v, want %v", got, want)
	}
}

func TestPlan_String(t *testing.T) {
	v := Plan{
		Name:          String(""),
		Space:         Int(0),
		Collaborators: Int(0),
		PrivateRepos:  Int(0),
		FilledSeats:   Int(0),
		Seats:         Int(0),
	}
	want := `github.Plan{Name:"", Space:0, Collaborators:0, PrivateRepos:0, FilledSeats:0, Seats:0}`
	if got := v.String(); got != want {
		t.Errorf("Plan.String = %v, want %v", got, want)
	}
}

func TestPreReceiveHook_String(t *testing.T) {
	v := PreReceiveHook{
		ID:          Int64(0),
		Name:        String(""),
		Enforcement: String(""),
		ConfigURL:   String(""),
	}
	want := `github.PreReceiveHook{ID:0, Name:"", Enforcement:"", ConfigURL:""}`
	if got := v.String(); got != want {
		t.Errorf("PreReceiveHook.String = %v, want %v", got, want)
	}
}

func TestProject_String(t *testing.T) {
	v := Project{
		ID:                     Int64(0),
		URL:                    String(""),
		HTMLURL:                String(""),
		ColumnsURL:             String(""),
		OwnerURL:               String(""),
		Name:                   String(""),
		Body:                   String(""),
		Number:                 Int(0),
		State:                  String(""),
		CreatedAt:              &Timestamp{},
		UpdatedAt:              &Timestamp{},
		NodeID:                 String(""),
		OrganizationPermission: String(""),
		Private:                Bool(false),
		Creator:                &User{},
	}
	want := `github.Project{ID:0, URL:"", HTMLURL:"", ColumnsURL:"", OwnerURL:"", Name:"", Body:"", Number:0, State:"", CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, NodeID:"", OrganizationPermission:"", Private:false, Creator:github.User{}}`
	if got := v.String(); got != want {
		t.Errorf("Project.String = %v, want %v", got, want)
	}
}

func TestPullRequest_String(t *testing.T) {
	v := PullRequest{
		ID:                  Int64(0),
		Number:              Int(0),
		State:               String(""),
		Locked:              Bool(false),
		Title:               String(""),
		Body:                String(""),
		User:                &User{},
		Draft:               Bool(false),
		Merged:              Bool(false),
		Mergeable:           Bool(false),
		MergeableState:      String(""),
		MergedBy:            &User{},
		MergeCommitSHA:      String(""),
		Rebaseable:          Bool(false),
		Comments:            Int(0),
		Commits:             Int(0),
		Additions:           Int(0),
		Deletions:           Int(0),
		ChangedFiles:        Int(0),
		URL:                 String(""),
		HTMLURL:             String(""),
		IssueURL:            String(""),
		StatusesURL:         String(""),
		DiffURL:             String(""),
		PatchURL:            String(""),
		CommitsURL:          String(""),
		CommentsURL:         String(""),
		ReviewCommentsURL:   String(""),
		ReviewCommentURL:    String(""),
		ReviewComments:      Int(0),
		Assignee:            &User{},
		Milestone:           &Milestone{},
		MaintainerCanModify: Bool(false),
		AuthorAssociation:   String(""),
		NodeID:              String(""),
		AutoMerge:           &PullRequestAutoMerge{},
		Links:               &PRLinks{},
		Head:                &PullRequestBranch{},
		Base:                &PullRequestBranch{},
		ActiveLockReason:    String(""),
	}
	want := `github.PullRequest{ID:0, Number:0, State:"", Locked:false, Title:"", Body:"", User:github.User{}, Draft:false, Merged:false, Mergeable:false, MergeableState:"", MergedBy:github.User{}, MergeCommitSHA:"", Rebaseable:false, Comments:0, Commits:0, Additions:0, Deletions:0, ChangedFiles:0, URL:"", HTMLURL:"", IssueURL:"", StatusesURL:"", DiffURL:"", PatchURL:"", CommitsURL:"", CommentsURL:"", ReviewCommentsURL:"", ReviewCommentURL:"", ReviewComments:0, Assignee:github.User{}, Milestone:github.Milestone{}, MaintainerCanModify:false, AuthorAssociation:"", NodeID:"", AutoMerge:github.PullRequestAutoMerge{}, Links:github.PRLinks{}, Head:github.PullRequestBranch{}, Base:github.PullRequestBranch{}, ActiveLockReason:""}`
	if got := v.String(); got != want {
		t.Errorf("PullRequest.String = %v, want %v", got, want)
	}
}

func TestPullRequestComment_String(t *testing.T) {
	v := PullRequestComment{
		ID:                  Int64(0),
		NodeID:              String(""),
		InReplyTo:           Int64(0),
		Body:                String(""),
		Path:                String(""),
		DiffHunk:            String(""),
		PullRequestReviewID: Int64(0),
		Position:            Int(0),
		OriginalPosition:    Int(0),
		StartLine:           Int(0),
		Line:                Int(0),
		OriginalLine:        Int(0),
		OriginalStartLine:   Int(0),
		Side:                String(""),
		StartSide:           String(""),
		CommitID:            String(""),
		OriginalCommitID:    String(""),
		User:                &User{},
		Reactions:           &Reactions{},
		AuthorAssociation:   String(""),
		URL:                 String(""),
		HTMLURL:             String(""),
		PullRequestURL:      String(""),
	}
	want := `github.PullRequestComment{ID:0, NodeID:"", InReplyTo:0, Body:"", Path:"", DiffHunk:"", PullRequestReviewID:0, Position:0, OriginalPosition:0, StartLine:0, Line:0, OriginalLine:0, OriginalStartLine:0, Side:"", StartSide:"", CommitID:"", OriginalCommitID:"", User:github.User{}, Reactions:github.Reactions{}, AuthorAssociation:"", URL:"", HTMLURL:"", PullRequestURL:""}`
	if got := v.String(); got != want {
		t.Errorf("PullRequestComment.String = %v, want %v", got, want)
	}
}

func TestPullRequestReview_String(t *testing.T) {
	v := PullRequestReview{
		ID:                Int64(0),
		NodeID:            String(""),
		User:              &User{},
		Body:              String(""),
		CommitID:          String(""),
		HTMLURL:           String(""),
		PullRequestURL:    String(""),
		State:             String(""),
		AuthorAssociation: String(""),
	}
	want := `github.PullRequestReview{ID:0, NodeID:"", User:github.User{}, Body:"", CommitID:"", HTMLURL:"", PullRequestURL:"", State:"", AuthorAssociation:""}`
	if got := v.String(); got != want {
		t.Errorf("PullRequestReview.String = %v, want %v", got, want)
	}
}

func TestPullRequestReviewDismissalRequest_String(t *testing.T) {
	v := PullRequestReviewDismissalRequest{
		Message: String(""),
	}
	want := `github.PullRequestReviewDismissalRequest{Message:""}`
	if got := v.String(); got != want {
		t.Errorf("PullRequestReviewDismissalRequest.String = %v, want %v", got, want)
	}
}

func TestPullRequestReviewRequest_String(t *testing.T) {
	v := PullRequestReviewRequest{
		NodeID:   String(""),
		CommitID: String(""),
		Body:     String(""),
		Event:    String(""),
	}
	want := `github.PullRequestReviewRequest{NodeID:"", CommitID:"", Body:"", Event:""}`
	if got := v.String(); got != want {
		t.Errorf("PullRequestReviewRequest.String = %v, want %v", got, want)
	}
}

func TestPullRequestThread_String(t *testing.T) {
	v := PullRequestThread{
		ID:     Int64(0),
		NodeID: String(""),
	}
	want := `github.PullRequestThread{ID:0, NodeID:""}`
	if got := v.String(); got != want {
		t.Errorf("PullRequestThread.String = %v, want %v", got, want)
	}
}

func TestPullStats_String(t *testing.T) {
	v := PullStats{
		TotalPulls:      Int(0),
		MergedPulls:     Int(0),
		MergablePulls:   Int(0),
		UnmergablePulls: Int(0),
	}
	want := `github.PullStats{TotalPulls:0, MergedPulls:0, MergablePulls:0, UnmergablePulls:0}`
	if got := v.String(); got != want {
		t.Errorf("PullStats.String = %v, want %v", got, want)
	}
}

func TestPushEvent_String(t *testing.T) {
	v := PushEvent{
		PushID:       Int64(0),
		Head:         String(""),
		Ref:          String(""),
		Size:         Int(0),
		Before:       String(""),
		DistinctSize: Int(0),
		Action:       String(""),
		After:        String(""),
		Created:      Bool(false),
		Deleted:      Bool(false),
		Forced:       Bool(false),
		BaseRef:      String(""),
		Compare:      String(""),
		Repo:         &PushEventRepository{},
		HeadCommit:   &HeadCommit{},
		Pusher:       &User{},
		Sender:       &User{},
		Installation: &Installation{},
		Organization: &Organization{},
	}
	want := `github.PushEvent{PushID:0, Head:"", Ref:"", Size:0, Before:"", DistinctSize:0, Action:"", After:"", Created:false, Deleted:false, Forced:false, BaseRef:"", Compare:"", Repo:github.PushEventRepository{}, HeadCommit:github.HeadCommit{}, Pusher:github.User{}, Sender:github.User{}, Installation:github.Installation{}, Organization:github.Organization{}}`
	if got := v.String(); got != want {
		t.Errorf("PushEvent.String = %v, want %v", got, want)
	}
}

func TestRate_String(t *testing.T) {
	v := Rate{
		Limit:     0,
		Remaining: 0,
		Reset:     Timestamp{},
	}
	want := `github.Rate{Limit:0, Remaining:0, Reset:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}}`
	if got := v.String(); got != want {
		t.Errorf("Rate.String = %v, want %v", got, want)
	}
}

func TestReaction_String(t *testing.T) {
	v := Reaction{
		ID:      Int64(0),
		User:    &User{},
		NodeID:  String(""),
		Content: String(""),
	}
	want := `github.Reaction{ID:0, User:github.User{}, NodeID:"", Content:""}`
	if got := v.String(); got != want {
		t.Errorf("Reaction.String = %v, want %v", got, want)
	}
}

func TestReference_String(t *testing.T) {
	v := Reference{
		Ref:    String(""),
		URL:    String(""),
		Object: &GitObject{},
		NodeID: String(""),
	}
	want := `github.Reference{Ref:"", URL:"", Object:github.GitObject{}, NodeID:""}`
	if got := v.String(); got != want {
		t.Errorf("Reference.String = %v, want %v", got, want)
	}
}

func TestReleaseAsset_String(t *testing.T) {
	v := ReleaseAsset{
		ID:                 Int64(0),
		URL:                String(""),
		Name:               String(""),
		Label:              String(""),
		State:              String(""),
		ContentType:        String(""),
		Size:               Int(0),
		DownloadCount:      Int(0),
		CreatedAt:          &Timestamp{},
		UpdatedAt:          &Timestamp{},
		BrowserDownloadURL: String(""),
		Uploader:           &User{},
		NodeID:             String(""),
	}
	want := `github.ReleaseAsset{ID:0, URL:"", Name:"", Label:"", State:"", ContentType:"", Size:0, DownloadCount:0, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, BrowserDownloadURL:"", Uploader:github.User{}, NodeID:""}`
	if got := v.String(); got != want {
		t.Errorf("ReleaseAsset.String = %v, want %v", got, want)
	}
}

func TestRename_String(t *testing.T) {
	v := Rename{
		From: String(""),
		To:   String(""),
	}
	want := `github.Rename{From:"", To:""}`
	if got := v.String(); got != want {
		t.Errorf("Rename.String = %v, want %v", got, want)
	}
}

func TestRepoStats_String(t *testing.T) {
	v := RepoStats{
		TotalRepos:  Int(0),
		RootRepos:   Int(0),
		ForkRepos:   Int(0),
		OrgRepos:    Int(0),
		TotalPushes: Int(0),
		TotalWikis:  Int(0),
	}
	want := `github.RepoStats{TotalRepos:0, RootRepos:0, ForkRepos:0, OrgRepos:0, TotalPushes:0, TotalWikis:0}`
	if got := v.String(); got != want {
		t.Errorf("RepoStats.String = %v, want %v", got, want)
	}
}

func TestRepoStatus_String(t *testing.T) {
	v := RepoStatus{
		ID:          Int64(0),
		NodeID:      String(""),
		URL:         String(""),
		State:       String(""),
		TargetURL:   String(""),
		Description: String(""),
		Context:     String(""),
		AvatarURL:   String(""),
		Creator:     &User{},
	}
	want := `github.RepoStatus{ID:0, NodeID:"", URL:"", State:"", TargetURL:"", Description:"", Context:"", AvatarURL:"", Creator:github.User{}}`
	if got := v.String(); got != want {
		t.Errorf("RepoStatus.String = %v, want %v", got, want)
	}
}

func TestRepository_String(t *testing.T) {
	v := Repository{
		ID:                        Int64(0),
		NodeID:                    String(""),
		Owner:                     &User{},
		Name:                      String(""),
		FullName:                  String(""),
		Description:               String(""),
		Homepage:                  String(""),
		CodeOfConduct:             &CodeOfConduct{},
		DefaultBranch:             String(""),
		MasterBranch:              String(""),
		CreatedAt:                 &Timestamp{},
		PushedAt:                  &Timestamp{},
		UpdatedAt:                 &Timestamp{},
		HTMLURL:                   String(""),
		CloneURL:                  String(""),
		GitURL:                    String(""),
		MirrorURL:                 String(""),
		SSHURL:                    String(""),
		SVNURL:                    String(""),
		Language:                  String(""),
		Fork:                      Bool(false),
		ForksCount:                Int(0),
		NetworkCount:              Int(0),
		OpenIssuesCount:           Int(0),
		OpenIssues:                Int(0),
		StargazersCount:           Int(0),
		SubscribersCount:          Int(0),
		WatchersCount:             Int(0),
		Watchers:                  Int(0),
		Size:                      Int(0),
		AutoInit:                  Bool(false),
		Parent:                    &Repository{},
		Source:                    &Repository{},
		TemplateRepository:        &Repository{},
		Organization:              &Organization{},
		AllowRebaseMerge:          Bool(false),
		AllowUpdateBranch:         Bool(false),
		AllowSquashMerge:          Bool(false),
		AllowMergeCommit:          Bool(false),
		AllowAutoMerge:            Bool(false),
		AllowForking:              Bool(false),
		DeleteBranchOnMerge:       Bool(false),
		UseSquashPRTitleAsDefault: Bool(false),
		SquashMergeCommitTitle:    String(""),
		SquashMergeCommitMessage:  String(""),
		MergeCommitTitle:          String(""),
		MergeCommitMessage:        String(""),
		Topics:                    []string{""},
		Archived:                  Bool(false),
		Disabled:                  Bool(false),
		License:                   &License{},
		Private:                   Bool(false),
		HasIssues:                 Bool(false),
		HasWiki:                   Bool(false),
		HasPages:                  Bool(false),
		HasProjects:               Bool(false),
		HasDownloads:              Bool(false),
		IsTemplate:                Bool(false),
		LicenseTemplate:           String(""),
		GitignoreTemplate:         String(""),
		SecurityAndAnalysis:       &SecurityAndAnalysis{},
		TeamID:                    Int64(0),
		URL:                       String(""),
		ArchiveURL:                String(""),
		AssigneesURL:              String(""),
		BlobsURL:                  String(""),
		BranchesURL:               String(""),
		CollaboratorsURL:          String(""),
		CommentsURL:               String(""),
		CommitsURL:                String(""),
		CompareURL:                String(""),
		ContentsURL:               String(""),
		ContributorsURL:           String(""),
		DeploymentsURL:            String(""),
		DownloadsURL:              String(""),
		EventsURL:                 String(""),
		ForksURL:                  String(""),
		GitCommitsURL:             String(""),
		GitRefsURL:                String(""),
		GitTagsURL:                String(""),
		HooksURL:                  String(""),
		IssueCommentURL:           String(""),
		IssueEventsURL:            String(""),
		IssuesURL:                 String(""),
		KeysURL:                   String(""),
		LabelsURL:                 String(""),
		LanguagesURL:              String(""),
		MergesURL:                 String(""),
		MilestonesURL:             String(""),
		NotificationsURL:          String(""),
		PullsURL:                  String(""),
		ReleasesURL:               String(""),
		StargazersURL:             String(""),
		StatusesURL:               String(""),
		SubscribersURL:            String(""),
		SubscriptionURL:           String(""),
		TagsURL:                   String(""),
		TreesURL:                  String(""),
		TeamsURL:                  String(""),
		Visibility:                String(""),
		RoleName:                  String(""),
	}
	want := `github.Repository{ID:0, NodeID:"", Owner:github.User{}, Name:"", FullName:"", Description:"", Homepage:"", CodeOfConduct:github.CodeOfConduct{}, DefaultBranch:"", MasterBranch:"", CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, PushedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, HTMLURL:"", CloneURL:"", GitURL:"", MirrorURL:"", SSHURL:"", SVNURL:"", Language:"", Fork:false, ForksCount:0, NetworkCount:0, OpenIssuesCount:0, OpenIssues:0, StargazersCount:0, SubscribersCount:0, WatchersCount:0, Watchers:0, Size:0, AutoInit:false, Parent:github.Repository{}, Source:github.Repository{}, TemplateRepository:github.Repository{}, Organization:github.Organization{}, AllowRebaseMerge:false, AllowUpdateBranch:false, AllowSquashMerge:false, AllowMergeCommit:false, AllowAutoMerge:false, AllowForking:false, DeleteBranchOnMerge:false, UseSquashPRTitleAsDefault:false, SquashMergeCommitTitle:"", SquashMergeCommitMessage:"", MergeCommitTitle:"", MergeCommitMessage:"", Topics:[""], Archived:false, Disabled:false, License:github.License{}, Private:false, HasIssues:false, HasWiki:false, HasPages:false, HasProjects:false, HasDownloads:false, IsTemplate:false, LicenseTemplate:"", GitignoreTemplate:"", SecurityAndAnalysis:github.SecurityAndAnalysis{}, TeamID:0, URL:"", ArchiveURL:"", AssigneesURL:"", BlobsURL:"", BranchesURL:"", CollaboratorsURL:"", CommentsURL:"", CommitsURL:"", CompareURL:"", ContentsURL:"", ContributorsURL:"", DeploymentsURL:"", DownloadsURL:"", EventsURL:"", ForksURL:"", GitCommitsURL:"", GitRefsURL:"", GitTagsURL:"", HooksURL:"", IssueCommentURL:"", IssueEventsURL:"", IssuesURL:"", KeysURL:"", LabelsURL:"", LanguagesURL:"", MergesURL:"", MilestonesURL:"", NotificationsURL:"", PullsURL:"", ReleasesURL:"", StargazersURL:"", StatusesURL:"", SubscribersURL:"", SubscriptionURL:"", TagsURL:"", TreesURL:"", TeamsURL:"", Visibility:"", RoleName:""}`
	if got := v.String(); got != want {
		t.Errorf("Repository.String = %v, want %v", got, want)
	}
}

func TestRepositoryComment_String(t *testing.T) {
	v := RepositoryComment{
		HTMLURL:   String(""),
		URL:       String(""),
		ID:        Int64(0),
		NodeID:    String(""),
		CommitID:  String(""),
		User:      &User{},
		Reactions: &Reactions{},
		Body:      String(""),
		Path:      String(""),
		Position:  Int(0),
	}
	want := `github.RepositoryComment{HTMLURL:"", URL:"", ID:0, NodeID:"", CommitID:"", User:github.User{}, Reactions:github.Reactions{}, Body:"", Path:"", Position:0}`
	if got := v.String(); got != want {
		t.Errorf("RepositoryComment.String = %v, want %v", got, want)
	}
}

func TestRepositoryCommit_String(t *testing.T) {
	v := RepositoryCommit{
		NodeID:      String(""),
		SHA:         String(""),
		Commit:      &Commit{},
		Author:      &User{},
		Committer:   &User{},
		HTMLURL:     String(""),
		URL:         String(""),
		CommentsURL: String(""),
		Stats:       &CommitStats{},
	}
	want := `github.RepositoryCommit{NodeID:"", SHA:"", Commit:github.Commit{}, Author:github.User{}, Committer:github.User{}, HTMLURL:"", URL:"", CommentsURL:"", Stats:github.CommitStats{}}`
	if got := v.String(); got != want {
		t.Errorf("RepositoryCommit.String = %v, want %v", got, want)
	}
}

func TestRepositoryContent_String(t *testing.T) {
	v := RepositoryContent{
		Type:        String(""),
		Target:      String(""),
		Encoding:    String(""),
		Size:        Int(0),
		Name:        String(""),
		Path:        String(""),
		Content:     String(""),
		SHA:         String(""),
		URL:         String(""),
		GitURL:      String(""),
		HTMLURL:     String(""),
		DownloadURL: String(""),
	}
	want := `github.RepositoryContent{Type:"", Target:"", Encoding:"", Size:0, Name:"", Path:"", Content:"", SHA:"", URL:"", GitURL:"", HTMLURL:"", DownloadURL:""}`
	if got := v.String(); got != want {
		t.Errorf("RepositoryContent.String = %v, want %v", got, want)
	}
}

func TestRepositoryLicense_String(t *testing.T) {
	v := RepositoryLicense{
		Name:        String(""),
		Path:        String(""),
		SHA:         String(""),
		Size:        Int(0),
		URL:         String(""),
		HTMLURL:     String(""),
		GitURL:      String(""),
		DownloadURL: String(""),
		Type:        String(""),
		Content:     String(""),
		Encoding:    String(""),
		License:     &License{},
	}
	want := `github.RepositoryLicense{Name:"", Path:"", SHA:"", Size:0, URL:"", HTMLURL:"", GitURL:"", DownloadURL:"", Type:"", Content:"", Encoding:"", License:github.License{}}`
	if got := v.String(); got != want {
		t.Errorf("RepositoryLicense.String = %v, want %v", got, want)
	}
}

func TestRepositoryParticipation_String(t *testing.T) {
	v := RepositoryParticipation{
		All:   []int{0},
		Owner: []int{0},
	}
	want := `github.RepositoryParticipation{All:[0], Owner:[0]}`
	if got := v.String(); got != want {
		t.Errorf("RepositoryParticipation.String = %v, want %v", got, want)
	}
}

func TestRepositoryRelease_String(t *testing.T) {
	v := RepositoryRelease{
		TagName:                String(""),
		TargetCommitish:        String(""),
		Name:                   String(""),
		Body:                   String(""),
		Draft:                  Bool(false),
		Prerelease:             Bool(false),
		DiscussionCategoryName: String(""),
		GenerateReleaseNotes:   Bool(false),
		ID:                     Int64(0),
		CreatedAt:              &Timestamp{},
		PublishedAt:            &Timestamp{},
		URL:                    String(""),
		HTMLURL:                String(""),
		AssetsURL:              String(""),
		UploadURL:              String(""),
		ZipballURL:             String(""),
		TarballURL:             String(""),
		Author:                 &User{},
		NodeID:                 String(""),
	}
	want := `github.RepositoryRelease{TagName:"", TargetCommitish:"", Name:"", Body:"", Draft:false, Prerelease:false, DiscussionCategoryName:"", GenerateReleaseNotes:false, ID:0, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, PublishedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, URL:"", HTMLURL:"", AssetsURL:"", UploadURL:"", ZipballURL:"", TarballURL:"", Author:github.User{}, NodeID:""}`
	if got := v.String(); got != want {
		t.Errorf("RepositoryRelease.String = %v, want %v", got, want)
	}
}

func TestSSHSigningKey_String(t *testing.T) {
	v := SSHSigningKey{
		ID:        Int64(0),
		Key:       String(""),
		Title:     String(""),
		CreatedAt: &Timestamp{},
	}
	want := `github.SSHSigningKey{ID:0, Key:"", Title:"", CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}}`
	if got := v.String(); got != want {
		t.Errorf("SSHSigningKey.String = %v, want %v", got, want)
	}
}

func TestSecretScanning_String(t *testing.T) {
	v := SecretScanning{
		Status: String(""),
	}
	want := `github.SecretScanning{Status:""}`
	if got := v.String(); got != want {
		t.Errorf("SecretScanning.String = %v, want %v", got, want)
	}
}

func TestSecurityAndAnalysis_String(t *testing.T) {
	v := SecurityAndAnalysis{
		AdvancedSecurity:             &AdvancedSecurity{},
		SecretScanning:               &SecretScanning{},
		SecretScanningPushProtection: &SecretScanningPushProtection{},
	}
	want := `github.SecurityAndAnalysis{AdvancedSecurity:github.AdvancedSecurity{}, SecretScanning:github.SecretScanning{}, SecretScanningPushProtection:github.SecretScanningPushProtection{}}`
	if got := v.String(); got != want {
		t.Errorf("SecurityAndAnalysis.String = %v, want %v", got, want)
	}
}

func TestServiceHook_String(t *testing.T) {
	v := ServiceHook{
		Name:            String(""),
		Events:          []string{""},
		SupportedEvents: []string{""},
	}
	want := `github.ServiceHook{Name:"", Events:[""], SupportedEvents:[""]}`
	if got := v.String(); got != want {
		t.Errorf("ServiceHook.String = %v, want %v", got, want)
	}
}

func TestSourceImportAuthor_String(t *testing.T) {
	v := SourceImportAuthor{
		ID:         Int64(0),
		RemoteID:   String(""),
		RemoteName: String(""),
		Email:      String(""),
		Name:       String(""),
		URL:        String(""),
		ImportURL:  String(""),
	}
	want := `github.SourceImportAuthor{ID:0, RemoteID:"", RemoteName:"", Email:"", Name:"", URL:"", ImportURL:""}`
	if got := v.String(); got != want {
		t.Errorf("SourceImportAuthor.String = %v, want %v", got, want)
	}
}

func TestTeam_String(t *testing.T) {
	v := Team{
		ID:              Int64(0),
		NodeID:          String(""),
		Name:            String(""),
		Description:     String(""),
		URL:             String(""),
		Slug:            String(""),
		Permission:      String(""),
		Privacy:         String(""),
		MembersCount:    Int(0),
		ReposCount:      Int(0),
		Organization:    &Organization{},
		HTMLURL:         String(""),
		MembersURL:      String(""),
		RepositoriesURL: String(""),
		Parent:          &Team{},
		LDAPDN:          String(""),
	}
	want := `github.Team{ID:0, NodeID:"", Name:"", Description:"", URL:"", Slug:"", Permission:"", Privacy:"", MembersCount:0, ReposCount:0, Organization:github.Organization{}, HTMLURL:"", MembersURL:"", RepositoriesURL:"", Parent:github.Team{}, LDAPDN:""}`
	if got := v.String(); got != want {
		t.Errorf("Team.String = %v, want %v", got, want)
	}
}

func TestTeamDiscussion_String(t *testing.T) {
	v := TeamDiscussion{
		Author:        &User{},
		Body:          String(""),
		BodyHTML:      String(""),
		BodyVersion:   String(""),
		CommentsCount: Int(0),
		CommentsURL:   String(""),
		CreatedAt:     &Timestamp{},
		LastEditedAt:  &Timestamp{},
		HTMLURL:       String(""),
		NodeID:        String(""),
		Number:        Int(0),
		Pinned:        Bool(false),
		Private:       Bool(false),
		TeamURL:       String(""),
		Title:         String(""),
		UpdatedAt:     &Timestamp{},
		URL:           String(""),
		Reactions:     &Reactions{},
	}
	want := `github.TeamDiscussion{Author:github.User{}, Body:"", BodyHTML:"", BodyVersion:"", CommentsCount:0, CommentsURL:"", CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, LastEditedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, HTMLURL:"", NodeID:"", Number:0, Pinned:false, Private:false, TeamURL:"", Title:"", UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, URL:"", Reactions:github.Reactions{}}`
	if got := v.String(); got != want {
		t.Errorf("TeamDiscussion.String = %v, want %v", got, want)
	}
}

func TestTeamLDAPMapping_String(t *testing.T) {
	v := TeamLDAPMapping{
		ID:              Int64(0),
		LDAPDN:          String(""),
		URL:             String(""),
		Name:            String(""),
		Slug:            String(""),
		Description:     String(""),
		Privacy:         String(""),
		Permission:      String(""),
		MembersURL:      String(""),
		RepositoriesURL: String(""),
	}
	want := `github.TeamLDAPMapping{ID:0, LDAPDN:"", URL:"", Name:"", Slug:"", Description:"", Privacy:"", Permission:"", MembersURL:"", RepositoriesURL:""}`
	if got := v.String(); got != want {
		t.Errorf("TeamLDAPMapping.String = %v, want %v", got, want)
	}
}

func TestTextMatch_String(t *testing.T) {
	v := TextMatch{
		ObjectURL:  String(""),
		ObjectType: String(""),
		Property:   String(""),
		Fragment:   String(""),
	}
	want := `github.TextMatch{ObjectURL:"", ObjectType:"", Property:"", Fragment:""}`
	if got := v.String(); got != want {
		t.Errorf("TextMatch.String = %v, want %v", got, want)
	}
}

func TestTree_String(t *testing.T) {
	v := Tree{
		SHA:       String(""),
		Truncated: Bool(false),
	}
	want := `github.Tree{SHA:"", Truncated:false}`
	if got := v.String(); got != want {
		t.Errorf("Tree.String = %v, want %v", got, want)
	}
}

func TestTreeEntry_String(t *testing.T) {
	v := TreeEntry{
		SHA:     String(""),
		Path:    String(""),
		Mode:    String(""),
		Type:    String(""),
		Size:    Int(0),
		Content: String(""),
		URL:     String(""),
	}
	want := `github.TreeEntry{SHA:"", Path:"", Mode:"", Type:"", Size:0, Content:"", URL:""}`
	if got := v.String(); got != want {
		t.Errorf("TreeEntry.String = %v, want %v", got, want)
	}
}

func TestUser_String(t *testing.T) {
	v := User{
		Login:                   String(""),
		ID:                      Int64(0),
		NodeID:                  String(""),
		AvatarURL:               String(""),
		HTMLURL:                 String(""),
		GravatarID:              String(""),
		Name:                    String(""),
		Company:                 String(""),
		Blog:                    String(""),
		Location:                String(""),
		Email:                   String(""),
		Hireable:                Bool(false),
		Bio:                     String(""),
		TwitterUsername:         String(""),
		PublicRepos:             Int(0),
		PublicGists:             Int(0),
		Followers:               Int(0),
		Following:               Int(0),
		CreatedAt:               &Timestamp{},
		UpdatedAt:               &Timestamp{},
		SuspendedAt:             &Timestamp{},
		Type:                    String(""),
		SiteAdmin:               Bool(false),
		TotalPrivateRepos:       Int(0),
		OwnedPrivateRepos:       Int(0),
		PrivateGists:            Int(0),
		DiskUsage:               Int(0),
		Collaborators:           Int(0),
		TwoFactorAuthentication: Bool(false),
		Plan:                    &Plan{},
		LdapDn:                  String(""),
		URL:                     String(""),
		EventsURL:               String(""),
		FollowingURL:            String(""),
		FollowersURL:            String(""),
		GistsURL:                String(""),
		OrganizationsURL:        String(""),
		ReceivedEventsURL:       String(""),
		ReposURL:                String(""),
		StarredURL:              String(""),
		SubscriptionsURL:        String(""),
		RoleName:                String(""),
	}
	want := `github.User{Login:"", ID:0, NodeID:"", AvatarURL:"", HTMLURL:"", GravatarID:"", Name:"", Company:"", Blog:"", Location:"", Email:"", Hireable:false, Bio:"", TwitterUsername:"", PublicRepos:0, PublicGists:0, Followers:0, Following:0, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, SuspendedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, Type:"", SiteAdmin:false, TotalPrivateRepos:0, OwnedPrivateRepos:0, PrivateGists:0, DiskUsage:0, Collaborators:0, TwoFactorAuthentication:false, Plan:github.Plan{}, LdapDn:"", URL:"", EventsURL:"", FollowingURL:"", FollowersURL:"", GistsURL:"", OrganizationsURL:"", ReceivedEventsURL:"", ReposURL:"", StarredURL:"", SubscriptionsURL:"", RoleName:""}`
	if got := v.String(); got != want {
		t.Errorf("User.String = %v, want %v", got, want)
	}
}

func TestUserLDAPMapping_String(t *testing.T) {
	v := UserLDAPMapping{
		ID:                Int64(0),
		LDAPDN:            String(""),
		Login:             String(""),
		AvatarURL:         String(""),
		GravatarID:        String(""),
		Type:              String(""),
		SiteAdmin:         Bool(false),
		URL:               String(""),
		EventsURL:         String(""),
		FollowingURL:      String(""),
		FollowersURL:      String(""),
		GistsURL:          String(""),
		OrganizationsURL:  String(""),
		ReceivedEventsURL: String(""),
		ReposURL:          String(""),
		StarredURL:        String(""),
		SubscriptionsURL:  String(""),
	}
	want := `github.UserLDAPMapping{ID:0, LDAPDN:"", Login:"", AvatarURL:"", GravatarID:"", Type:"", SiteAdmin:false, URL:"", EventsURL:"", FollowingURL:"", FollowersURL:"", GistsURL:"", OrganizationsURL:"", ReceivedEventsURL:"", ReposURL:"", StarredURL:"", SubscriptionsURL:""}`
	if got := v.String(); got != want {
		t.Errorf("UserLDAPMapping.String = %v, want %v", got, want)
	}
}

func TestUserMigration_String(t *testing.T) {
	v := UserMigration{
		ID:                 Int64(0),
		GUID:               String(""),
		State:              String(""),
		LockRepositories:   Bool(false),
		ExcludeAttachments: Bool(false),
		URL:                String(""),
		CreatedAt:          String(""),
		UpdatedAt:          String(""),
	}
	want := `github.UserMigration{ID:0, GUID:"", State:"", LockRepositories:false, ExcludeAttachments:false, URL:"", CreatedAt:"", UpdatedAt:""}`
	if got := v.String(); got != want {
		t.Errorf("UserMigration.String = %v, want %v", got, want)
	}
}

func TestUserStats_String(t *testing.T) {
	v := UserStats{
		TotalUsers:     Int(0),
		AdminUsers:     Int(0),
		SuspendedUsers: Int(0),
	}
	want := `github.UserStats{TotalUsers:0, AdminUsers:0, SuspendedUsers:0}`
	if got := v.String(); got != want {
		t.Errorf("UserStats.String = %v, want %v", got, want)
	}
}

func TestWeeklyCommitActivity_String(t *testing.T) {
	v := WeeklyCommitActivity{
		Days:  []int{0},
		Total: Int(0),
		Week:  &Timestamp{},
	}
	want := `github.WeeklyCommitActivity{Days:[0], Total:0, Week:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}}`
	if got := v.String(); got != want {
		t.Errorf("WeeklyCommitActivity.String = %v, want %v", got, want)
	}
}

func TestWeeklyStats_String(t *testing.T) {
	v := WeeklyStats{
		Week:      &Timestamp{},
		Additions: Int(0),
		Deletions: Int(0),
		Commits:   Int(0),
	}
	want := `github.WeeklyStats{Week:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, Additions:0, Deletions:0, Commits:0}`
	if got := v.String(); got != want {
		t.Errorf("WeeklyStats.String = %v, want %v", got, want)
	}
}
