% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordGroupBoot.r
\name{ordGroupBoot}
\alias{ordGroupBoot}
\title{Minimally Group an Ordinal Variable So Bootstrap Samples Will Contain All Distinct Values}
\usage{
ordGroupBoot(
  y,
  B = 0,
  m = 7:min(15, floor(n/3)),
  what = c("mean", "factor", "m"),
  aprob = 0.9999,
  pr = TRUE
)
}
\arguments{
\item{y}{a numeric vector}

\item{B}{number of bootstrap samples to test, or zero to use a coverage probability approximation}

\item{m}{range of minimum group sizes to test; the default range is usually adequate}

\item{what}{specifies that either the mean \code{y} in each group should be returned, a \code{factor} version of this with interval endpoints in the levels, or the computed value of \code{m} should be returned}

\item{aprob}{minimum coverage probability sought}

\item{pr}{set to \code{FALSE} to not print the computed value of the minimum \code{m} satisfying the needed condition}
}
\value{
a numeric vector corresponding to \code{y} but grouped, containing eithr the mean of \code{y} in each group or a factor variable representing grouped \code{y}, either with the minimum \code{m} that satisfied the required sample covrage
}
\description{
When bootstrapping models for ordinal Y when Y is fairly continuous, it is frequently the case that one or more bootstrap samples will not include one or more of the distinct original Y values.  When fitting an ordinal model (including a Cox PH model), this means that an intercept cannot be estimated, and the parameter vectors will not align over bootstrap samples.  To prevent this from happening, some grouping of Y may be necessary.  The \code{ordGroupBoot} function uses \code{\link[=cutGn]{cutGn()}} to group Y so that the minimum number in any group is guaranteed to not exceed a certain integer \code{m}.  \code{ordGroupBoot} tries a range of \code{m} and stops at the lowest \code{m} such that either all \code{B} tested bootstrap samples contain all the original distinct values of Y (if \code{B}>0), or that the probability that a given sample of size \code{n} with replacement will contain all the distinct original values exceeds \code{aprob} (\code{B}=0).  This probability is computed approximately using an approximation to the probability of complete sample coverage from the \emph{coupon collector's problem} and is quite accurate for our purposes.
}
\examples{
set.seed(1)
x <- c(1:6, NA, 7:22)
ordGroupBoot(x, m=5:10)
ordGroupBoot(x, m=5:10, B=5000, what='factor')
}
\seealso{
\code{\link[=cutGn]{cutGn()}}
}
\author{
Frank Harrell
}
