/**
 * \file pappsomspp/processing/cbor/mzcbor/converttomzml.h
 * \date 30/11/2025
 * \author Olivier Langella
 * \brief convert mzcbor to mzML
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/


#pragma once

#include "pappsomspp/core/processing/uimonitor/uimonitorinterface.h"
#include "pappsomspp/core/processing/cbor/cborstreamreaderinterface.h"
#include <QXmlStreamWriter>


#include "pappsomspp/export-import-config.h"

namespace pappso
{
namespace cbor
{
namespace mzcbor
{
/**
 * @todo write docs
 */
class PMSPP_LIB_DECL ConvertToMzml : public CborStreamReaderInterface
{
  public:
  /**
   * Default constructor
   */
  ConvertToMzml(QXmlStreamWriter *p_writer);
  /**
   * Destructor
   */
  virtual ~ConvertToMzml();


  virtual void readCbor(QFile *cborp, pappso::UiMonitorInterface &monitor);
  virtual void readCbor(QIODevice *cborp, pappso::UiMonitorInterface &monitor);

  virtual void close();

  protected:
  void readRoot(pappso::UiMonitorInterface &monitor);

  void writeElementInMzml(const QString & name,pappso::UiMonitorInterface &monitor);


  private:
  QXmlStreamWriter *mp_writer;
  bool m_isMzcbor = false;
};
} // namespace mzcbor
} // namespace cbor
} // namespace pappso
