.\" Automatically generated from an mdoc input file.  Do not edit.
.\" zip_file_extra_fields_count.mdoc -- count extra field for file in zip
.\" Copyright (C) 2012-2017 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP files.
.\" The authors can be contacted at <info@libzip.org>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "ZIP_FILE_EXTRA_FIELDS_COUNT" "3" "December 18, 2017" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_file_extra_fields_count\fR,
\fBzip_file_extra_fields_count_by_id\fR
\- count extra fields for file in zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIzip_int16_t\fR
.br
.PD 0
.HP 4n
\fBzip_file_extra_fields_count\fR(\fIzip_t\ *archive\fR, \fIzip_uint64_t\ index\fR, \fIzip_flags_t\ flags\fR);
.PD
.PP
\fIzip_int16_t\fR
.br
.PD 0
.HP 4n
\fBzip_file_extra_fields_count_by_id\fR(\fIzip_t\ *archive\fR, \fIzip_uint64_t\ index\fR, \fIzip_uint16_t\ extra_field_id\fR, \fIzip_flags_t\ flags\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_file_extra_fields_count\fR()
function counts the extra fields for the file at position
\fIindex\fR
in the zip archive.
.PP
The following
\fIflags\fR
are supported:
.RS 6n
.TP 18n
\fRZIP_FL_CENTRAL\fR
Count extra fields from the archive's central directory.
.TP 18n
\fRZIP_FL_LOCAL\fR
Count extra fields from the local file headers.
.TP 18n
\fRZIP_FL_UNCHANGED\fR
Count the original unchanged extra fields, ignoring any changes made.
.RE
.PP
The
\fBzip_file_extra_fields_count_by_id\fR()
function counts the extra fields with ID (two-byte signature)
\fIextra_field_id\fR.
The other arguments are the same as for
\fBzip_file_extra_fields_count\fR().
.PP
Extra fields that are the same in the central directory and the local file
header are merged into one.
Therefore, the counts with
\fRZIP_FL_CENTRAL\fR
and
\fRZIP_FL_LOCAL\fR
do not need to add up to the same value as when given
\fRZIP_FL_CENTRAL|ZIP_FL_LOCAL\fR
at the same time.
.SH "RETURN VALUES"
Upon successful completion, the requested number of extra fields is returned.
Otherwise, \-1 is returned and the error code in
\fIarchive\fR
is set to indicate the error.
.SH "ERRORS"
\fBzip_file_extra_fields_count\fR()
and
\fBzip_file_extra_fields_count_by_id\fR()
fail if:
.TP 19n
[\fRZIP_ER_NOENT\fR]
\fIindex\fR
is not a valid file index in
\fIarchive\fR.
.SH "SEE ALSO"
libzip(3),
zip_file_extra_field_delete(3),
zip_file_extra_field_get(3),
zip_file_extra_field_set(3)
.SH "HISTORY"
\fBzip_file_extra_fields_count\fR()
and
\fBzip_file_extra_fields_count_by_id\fR()
were added in libzip 0.11.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fIwiz@gatalith.at\fR>
