This is Info file dvips.info, produced by Makeinfo version 1.67 from
the input file dvips.texinfo.

INFO-DIR-SECTION TeX
START-INFO-DIR-ENTRY
* DVI-to-Postscript: (dvips).        Translating TeX DVI files to PostScript.
* afm2tfm: (dvips)Invoking afm2tfm.  Making Type 1 fonts available to TeX.
* dvips: (dvips)Invoking Dvips.      DVI-to-PostScript translator.
END-INFO-DIR-ENTRY


File: dvips.info,  Node: Metric files,  Next: Glyph files,  Up: Font concepts

Metric files
------------

  A "metric file" describes properties of the font that are independent
of what the characters actually look like.  Aside from general
information about the font itself, a metric file has two kinds of
information: information about individual characters, organized by
character code, and information about sequences of characters.

  The per-character information specifies the width, height, depth, and
italic correction of each character in the font.  Any might be zero.

  In addition to information on individual characters, the metric file
specifies "kerning", i.e., adding or removing space between particular
character pairs.  It further specifies "ligature" information: when a
sequence of input characters should be typeset as a single (presumably
different) "ligature" character.  For example, it's traditional for the
input `fi' to be typeset as `fi', not as `fi' (with the dot of the `i'
colliding with `f').  (In English, the only common ligatures are fi,
fl, ff, ffi, and ffl.)

  Different typesetting systems use different metric file formats:

   * Each Postscript font has an "Adobe font metrics" (`.afm') file.
     These files are plain text, so you can inspect them easily.  You
     can get AFM files for Adobe's fonts from
     `ftp://ftp.adobe.com/pub/adobe/Fonts/AFMs'.

   * TeX uses "TeX font metrics" (`.tfm') files. When you say `\font =
     FONT' in your TeX document, TeX reads a file named `FONT.tfm'.
     (Well, except for the `texfonts.map' feature; *note Fontmap:
     (kpathsea)Fontmap.).  TeX can then calculate the space occupied by
     characters from the font when typesetting. In addition, the DVI
     drivers you use to print or view the DVI file produced by TeX may
     need to look at the TFM file.

     TFM files are binary (and hence are typically much smaller than AFM
     files). You can use the `tftopl' program (*note tftopl invocation:
     (web2c)tftopl invocation.) that comes with TeX to transform a TFM
     file into a human-readable "property list" (`.pl') file.  You can
     also edit a PL file and transform it back to a TeX-readable TFM
     with the companion program `pltotf' (*note pltotf invocation:
     (web2c)pltotf invocation.).  Editing metrics by hand is not
     something you're likely to want to do often, but the capability is
     there.

   * ATM and other typesetting systems use "printer font metric"
     (`.pfm') files. These are binary files. They are irrelevant in the
     TeX world, and not freely available, so we will not discuss them
     further.

  The Afm2tfm program distributed with Dvips converts an AFM file to a
TFM file and performs other useful transformations as well.  *Note
Invoking afm2tfm::.


File: dvips.info,  Node: Glyph files,  Next: Virtual fonts,  Prev: Metric files,  Up: Font concepts

Glyph files
-----------

  Although a metric file (see the previous section) contains information
about the spatial and other properties of the character at position 75,
say, it contains nothing about what the character at position 75
actually looks like. The glyphs--the actual shapes of the letterforms
in a font--are defined by other files, which we call glyph files.  TeX
itself only reads the TFM file for a font; it does not need to know
character shapes.

  A "glyph file" is a file that defines the shapes of the characters in
a font.  The shapes can be defined either by outlines or by bitmaps.

  PostScript fonts are defined as "outline fonts": Each character in
the font is defined by giving the mathematical curves (lines, arcs, and
splines) that define its contours.  Different sizes of a character are
generated by linearly scaling a single shape. For example, a 10-point
`A' is simply half the size of a 20-point `A'.  Nowadays, outline fonts
usually also contain "hints"--additional information to improve the
appearance of the font at small sizes or low resolutions.

  Although various kinds of PostScript outline fonts exist, by far the
most common, and the only one we will consider, is called "Type 1".
The glyph files for Postscript Type 1 fonts typically have names ending
in `.pfa' ("printer font ASCII") or `.pfb' ("printer font binary").

  In contrast, glyph files for Computer Modern and the other standard
TeX fonts are "bitmap fonts", generated from Metafont (`.mf')
descriptions.  The Metafont program distributed with TeX generates
bitmaps from these descriptions.

  The glyph files for TeX bitmap fonts are usually stored in "packed
font" (PK) files.  The names of these files end in `.NNNpk', where NNN
is the resolution of the font in dots per inch.  For example,
`cmr10.600pk' contains the bitmaps for the `cmr10' font at a resolution
of 600dpi.  (On DOS filesystems, it's more likely `dpi600\cmr10.pk'.)

  Metafont actually outputs "generic font" (GF) files, e.g.,
`cmr10.600gf', but the GF files are usually converted immediately to PK
format (using the `gftopk' utility that comes with TeX) since PK files
are smaller and contain the same information. (The GF format is a
historical artifact.)


File: dvips.info,  Node: Virtual fonts,  Next: Encodings,  Prev: Glyph files,  Up: Font concepts

Virtual fonts
-------------

  A "virtual font" is constructed by extracting characters from one or
more existing fonts and rearranging them, or synthesizing new characters
in various ways.  The explanation in this manual is intended to suffice
for understanding enough about virtual fonts to use them with Dvips. It
isn't a reference manual on virtual fonts.  For more information: The
primary document on virtual fonts is Donald E. Knuth, `TUGboat' 11(1),
Apr. 1990, pp. 13-23, "Virtual Fonts: More Fun for Grand Wizards"
(`CTAN:/info/virtual-fonts.knuth'; for CTAN info, *note unixtex.ftp:
(kpathsea)unixtex.ftp.).  (Don't be intimidated by the subtitle.)

  A virtual font (`.vf') file specifies, for each character in the
virtual font, a recipe for typesetting that character.  A VF file, like
a TFM file, is in a compressed binary format.  The `vftovp' and
`vptovf' programs convert a VF file to a human-readable VPL (virtual
property list) format and back again.  *Note vftovp invocation:
(web2c)vftovp invocation, and *Note vptovf invocation: (web2c)vptovf
invocation.

  In the case of a PostScript font F being used in a straightforward
way, the recipe says: character I in the VF font is character J in font
F.  The font F is called a "base font".  For example, the VF file could
remap the characters of the PostScript font to the positions where TeX
expects to find them.  *Note Encodings::.

  Since TeX reads only TFM files, not VF's, each VF must have a
corresponding TFM for use with TeX.  This corresponding TFM is created
when you run `vptovf'.

  You can "expand" virtual fonts into their base fonts with DVIcopy
(*note dvicopy invocation: (web2c)dvicopy invocation.).  This is useful
if you are using a DVI translator that doesn't understand vf's itself.


File: dvips.info,  Node: Encodings,  Next: PostScript typesetting,  Prev: Virtual fonts,  Up: Font concepts

Encodings
---------

  Every font, whatever its type, has an "encoding", that specifies the
correspondence between "logical" characters and character codes.  For
example, the ASCII encoding specifies that the character numbered 65
(decimal) is an uppercase `A'.  The encoding does not specify what the
character at that position looks like; there are lots of ways to draw an
`A', and a glyph file (*note Glyph files::.) tells how.  Nor does it
specify how much space that character occupies; that information is in a
metric file (*note Metric files::.).

  TeX implicitly assumes a particular encoding for the fonts you use
with it.  For example, the plain TeX macro `\'', which typesets an
acute accent over the following letter, assumes the acute accent is at
position 19 (decimal). This happens to be true of standard TeX fonts
such as Computer Modern, as you might expect, but it is not true of
normal PostScript fonts.

  It's possible but painful to change all the macros that assume
particular character positions.  A better solution is to create a new
font with the information for the acute accent at position 19, where
TeX expects it to be.  *Note Making a font available::.

  PostScript represents encodings as a sequence of 256 character names
called an "encoding vector".  An "encoding file" (`.enc') gives such a
vector, together with ligature and kerning information (with which we
are not concerned at the moment).  These encoding files are used by the
Afm2tfm program.  Encoding files are also downloaded to the PostScript
interpreter in your printer if you use one of them in place of the
default encoding vector for a particular PostScript font.

  Examples of encodings: the `dvips.enc' encoding file that comes with
Dvips in the `reencode' directory is a good (but not perfect)
approximation to the TeX encoding for TeX's Computer Modern text fonts.
This is the encoding of the fonts that originated with Dvips, such as
`ptmr.tfm'.  The distribution includes many other encoding files; for
example, `8r.enc', which is the base font for the current PostScript
font distribution, and three corresponding to the TeX mathematics
fonts: `texmext.enc' for math extensions, `texmital.enc' for math
italics, and `texmsym.enc' for math symbols.


File: dvips.info,  Node: PostScript typesetting,  Prev: Encodings,  Up: Font concepts

How PostScript typesets a character
-----------------------------------

  The output of Dvips is a program in the PostScript language that
instructs your (presumably PostScript-capable) printer how to typeset
your document by transforming it into toner on paper.  Your printer, in
turn, contains a PostScript interpreter that carries out the
instructions in this typesetting program.

  The program must include the definition of any PostScript fonts that
you use in your document.  Fonts built into your printer (probably the
standard 35: `Times-Roman', `ZapfDingbats', ...) are defined within the
interpreter itself.  Other fonts must be downloaded as pfa or pfb files
(*note Glyph files::.) from your host (the computer on which you're
running Dvips).

  You may be wondering exactly how a PostScript interpreter figures out
what character to typeset, with this mass of metrics, glyphs, encodings,
and other information.  (If you're not wondering, skip this section ...)

  The basic PostScript operator for imaging characters is `show'.
Suppose you've asked TeX to typeset an `S'. This will eventually wind
up in the Dvips output as the equivalent of this PostScript operation:

     (S) show

Here is how PostScript typesets the `S':

  1. PostScript interpreters use ASCII; therefore `S' is represented as
     the integer 83. (Any of the 256 possible characters representable
     in a standard 8-bit byte can be typeset.)

  2. A PostScript "dictionary" is a mapping of names to arbitrary
     values.  A font, to the interpreter, is a dictionary which
     contains entries for certain names.  (If these entries are
     missing, the interpreter refuses to do anything with that font.)

     PostScript has a notion of "the current font"--whatever font is
     currently being typeset in.

  3. One of the mandatory entries in a font dictionary is `Encoding',
     which defines the encoding vector (*note Encodings::.) for that
     font.  This vector of 256 names maps each possible input character
     to a name.

  4. The interpreter retrieves the entry at position 83 of the encoding
     vector. This value is a PostScript name: `/S'.

  5. For Type 1 fonts (we're not going to discuss anything else), the
     interpreter now looks up `/S' as a key in a dictionary named
     `CharStrings', another mandatory entry in a font dictionary.

  6. The value of `S' in `CharStrings' is the equivalent of a series of
     standard PostScript commands like `curveto', `lineto', `fill', and
     so on. These commands are executed to draw the character. There
     can also be "hint information" that helps adapt the character to
     low-resolution rasters.  (*Note Glyph files::.) The commands are
     actually represented in a more compact way than standard
     PostScript source; see the Type 1 book for details.


  This method for typesetting characters is used in both Level 1 and
Level 2 PostScript.  See the PostScript reference manuals for more
information.


File: dvips.info,  Node: Making a font available,  Next: Invoking afm2tfm,  Prev: Font concepts,  Up: PostScript fonts

Making a PostScript font available
==================================

  To make a PostScript font available in a TeX document, you need to
install the font on your system and then define it within the document.
Once you have installed the font, of course, it is available for any
document thereafter and you don't need to reinstall it.  You must have
an AFM file for any font you install. Unless the font is built into your
printer, you must also have a PFA or PFB file.

  In the following examples, we use the font `Times-Roman' to
illustrate the process.  But you should use the prebuilt fonts for Times
and the other standard fonts, rather than rebuilding them.  The prebuilt
fonts are made using a more complicated process than that described
here, to make them work as well as possible with TeX.  So following the
steps in this manual will not generate files identical to the
distributed ones.  *Note PostScript font installation::, for pointers to
the prebuilt fonts.

  Installation of a PostScript font proceeds in three steps.  *Note
Font concepts::, for descriptions of the various files involved.

  1. Run `afm2tfm' to create a TFM file for the original font, and the
     VPL form of the virtual font:
          afm2tfm Times-Roman -v ptmr rptmr

  2. Run `vptovf' to generate a VF and TFM file for the virtual font
     from the VPL file:
          vptovf ptmr.vpl ptmr.vf ptmr.tfm

  3. Insert an entry for the font in `psfonts.map' (*Note
     psfonts.map::):
          rptmr      Times-Roman                 <ptmr8a.pfa

  4. Install the files in the standard locations, as in:
          cp ptmr.vf FONTDIR/vf/...
          cp *ptmr.tfm FONTDIR/tfm/...
          cp ptmr.afm FONTDIR/afm/...
          cp ptmr.pf? FONTDIR/type1/...

  The simplest invocation of Afm2tfm to make virtual fonts goes
something like this:

     afm2tfm Times-Roman -v ptmr rptmr

This reads the file `Times-Roman.afm', and produces two files as
output, namely the virtual property list'file `ptmr.vpl', and the "raw"
font metric file `rptmr.tfm'. To use the font in TeX, you first run

     vptovf ptmr.vpl ptmr.vf ptmr.tfm

You should then install the virtual font file `ptmr.vf' where Dvips
will see it and install `ptmr.tfm' and `rptmr.tfm' where TeX and Dvips
will see them.

  Using these raw fonts is not recommended; there are no raw fonts in
the prebuilt PostScript fonts distributed along with Dvips.  But
nevertheless, that's how Afm2tfm presently operates, so that's what we
document here.  The `r' prefix convention is likewise historical
accident.

  You can also make more complex virtual fonts by editing `ptmr.vpl'
before running `vptovf'; such editing might add the uppercase Greek
characters in the standard TeX positions, for instance.  (This has
already been done for the prebuilt fonts.)

  Once the files have been installed, you're all set. You can now do
things like this in TeX:
     \font\myfont = ptmr at 12pt
     \myfont Hello, I am being typeset in 12-point Times-Roman.

  Thus, we have two fonts, one actual (`rptmr', which is analogous to
the font in the printer) and one virtual (`ptmr', which has been
remapped to the standard TeX encoding (almost)), and has typesetting
know-how added. You could also say

     \font\raw = rptmr at 10pt

and typeset directly with that, but then you would have no ligatures or
kerning, and you would have to use Adobe character positions for special
letters like the ligature `AE'.  The virtual font `ptmr' not only has
ligatures and kerning, and most of the standard accent conventions of
TeX, it also has a few additional features not present in the Computer
Modern fonts. For example, it includes all the Adobe characters (such
as the Polish ogonek and the French guillemots).  The only things you
lose from ordinary TeX text fonts are the dotless `j' (which can be
hacked into the VPL file with literal PostScript specials if you have
the patience) and uppercase Greek letters (which just don't exist
unless you buy them separately).  *Note Reencoding with Afm2tfm::.

  As a final step you need to record information about both the virtual
font and the original font (if you ever might want to use it) in the
`psfonts.map' file (*note psfonts.map::.).  For our example, you'd
insert the following into `psfonts.map':
     rptmr      Times-Roman                 <ptmr8a.pfa

Of course, `Times-Roman' is already built in to most every printer, so
there's no need to download any Type 1 file for it.  But if you are
actually following these instructions for new fonts, most likely they
are not built in to the printer.

  These PostScript fonts can be scaled to any size.  Go wild!  Using
PostScript fonts, however, does use up a great deal of the printer's
memory and it does take time.  You may find downloading bitmap fonts
(possibly compressed, with the `Z' option) to be faster than using the
built-in PostScript fonts.


File: dvips.info,  Node: Invoking afm2tfm,  Next: psfonts.map,  Prev: Making a font available,  Up: PostScript fonts

Invoking Afm2tfm
================

  The Afm2tfm program converts an AFM file for a PostScript font to a
TFM file and a VPL file for a corresponding virtual font (or, in its
simplest form, to a TFM file for the PostScript font itself).  The
results of the conversion are affected by the command-line options and
especially by the reencodings you can specify with those options.  You
can also obtain special effects such as an oblique font.

  An alternative to Afm2tfm for creating virtual fonts is Alan Jeffrey's
`fontinst' program, available from `CTAN:fonts/utilities/fontinst' (for
CTAN info, *note unixtex.ftp: (kpathsea)unixtex.ftp.).

* Menu:

* Changing font encodings::     Reencoding with -t, -p, -T.
* Special font effects::        Oblique fonts, small caps, and such.
* Afm2tfm options::             afm2tfm command-line options.


File: dvips.info,  Node: Changing font encodings,  Next: Special font effects,  Up: Invoking afm2tfm

Changing font encodings
-----------------------

  Afm2tfm allows you to specify a different encoding for a PostScript
font (for a general introduction to encodings, *note Encodings::.). The
`-t' options changes the TeX encoding, `-p' changes the PostScript
encoding, and `-T' changes both simultaneously, as detailed in the
sections below.

* Menu:

* Changing TeX encodings::      Where TeX finds a character.
* Changing PostScript encodings::  Where PostScript finds a character.
* Changing both encodings::     One and the same, simultaneously.
* Reencoding with Afm2tfm::     Problems with the default encoding.
* Encoding file format::        Syntax of an encoding file.


File: dvips.info,  Node: Changing TeX encodings,  Next: Changing PostScript encodings,  Up: Changing font encodings

`-t': Changing TeX encodings
............................

  To build a virtual font with Afm2tfm, you specify the `-v' or `-V'
option. You can then specify an encoding for that virtual font with `-t
TEX-ENC'.  (`-t' is ignored if neither `-v' nor `-V' is present.)  Any
ligature and kerning information you specify in TEX-ENC will be used in
the VPL, in addition to the ligature and kerning information from the
AFM file.

  If the AFM file has no entry for a character specified in TEX-ENC,
that character will be omitted from the output VPL.

  The `-t' option is likely to be needed when you have a PostScript
font corresponding to a TeX font other than a normal text font such as
Computer Modern.  For instance, if you have a PostScript font that
contains math symbols, you'd probably want to use the encoding in the
`texmsym.enc' file supplied with Dvips. (For a start; to actually get
usable math fonts, you have to define much more than just an encoding.)


File: dvips.info,  Node: Changing PostScript encodings,  Next: Changing both encodings,  Prev: Changing TeX encodings,  Up: Changing font encodings

`-p': Changing PostScript encodings
...................................

  By default, Afm2tfm uses the encoding it finds in the AFM file.  You
can specify a different PostScript encoding with `-p PS-ENC'.  This
makes the raw TFM file (the one output by Afm2tfm) have the encoding
specified in the encoding file PS-ENC.  Any ligature or kern
information specified in PS-ENC is ignored by Afm2tfm, since ligkern
info is always omitted from the raw TFM.

  If you use this option, you must also arrange to download PS-ENC as
part of any document that uses this font.  You do this by adding a line
like the following one to `psfonts.map' (*note psfonts.map::.):
     zpopr Optima "MyEncoding ReEncodeFont" <myenc.enc

  Using `-p' is the only way to access characters in a PostScript font
that are neither encoded in the AFM file nor constructed from other
characters.  For instance, Adobe's `Times-Roman' font contains the
extra characters `trademark' and `registered' (among others); these can
only be accessed through such a PostScript reencoding.

  In fact, the `8r' base encoding used for the current PostScript font
distribution (available at `ftp://ftp.tug.org/tex/psfonts.tar.gz') does
do this reencoding, for precisely this reason.


File: dvips.info,  Node: Changing both encodings,  Next: Reencoding with Afm2tfm,  Prev: Changing PostScript encodings,  Up: Changing font encodings

`-T': Changing both TeX and PostScript encodings
................................................

  The option `-T ENC-FILE' is equivalent to `-p ENC-FILE -t ENC-FILE'.
If you make regular use of a private non-standard reencoding `-T' is
usually a better idea than the individual options, to avoid unexpected
inconsistencies in mapping otherwise.  An example of when you might use
this option is a dingbats font: when you have a TeX encoding that is
designed to be used with a particular PostScript font.


File: dvips.info,  Node: Reencoding with Afm2tfm,  Next: Encoding file format,  Prev: Changing both encodings,  Up: Changing font encodings

Reencoding with Afm2tfm
.......................

  The Afm2tfm program creates the TFM and VF files for the virtual font
corresponding to a PostScript font by "reencoding" the PostScript font.
Afm2tfm generates these files from two encodings: one for TeX and one
for PostScript.  The TeX encoding is used to map character numbers to
character names while the PostScript encoding is used to map each
character name to a possibly different number.  In combination, you can
get access to any character of a PostScript font at any position for
TeX typesetting.

  In the default case, when you specify none of the `-t', `-p', or `-T'
options, Afm2tfm uses a default TeX encoding (which mostly corresponds
to the Computer Modern text fonts) and the PostScript encoding found in
the AFM file being read.  The reencoding is also sometimes called a
"remapping".

  For example, the default encodings reencode the acute accent in two
steps: first the default TeX encoding maps the number 19 to the
character name `acute'; then the default PostScript encoding, as found
in the AFM file for an ordinary PostScript font, maps the character
name `acute' to the number 194.  (The PostScript encoding works in
reverse, by looking in the encoding vector for the name and then
yielding the corresponding number.)  The combined mapping of 19 to 194
shows up explicitly in the VF file and also implicitly in the fact that
the properties of PostScript character 194 appear in position 19 of the
TFM file for the virtual font.

  The default encoding of the distributed fonts (e.g., `ptmr.tfm')
mostly follows plain TeX conventions for accents.  The exceptions: the
Hungarian umlaut (which is at position `0x7D' in `cmr10', but position
`0xCD' in `ptmr'); the dot accent (at positions `0x5F' and `0xC7',
respectively); and the Scandinavian A ring `\AA', whose definition
needs different tweaking.  In order to use these accents with
PostScript fonts or in math mode when `\textfont0' is a PostScript
font, you will need to use the following definitions.  These
definitions will not work with the Computer Modern fonts for the
relevant accents.  They are already part of the distributed
`psfonts.sty' for use with LaTeX.

     \def\H#1{{\accent"CD #1}}
     \def\.#1{{\accent"C7 #1}}
     \def\dot{\mathaccent"70C7 }
     \newdimen\aadimen
     \def\AA{\leavevmode\setbox0\hbox{h}\aadimen\ht0
       \advance\aadimen-1ex\setbox0\hbox{A}\rlap{\raise.67\aadimen
       \hbox to \wd0{\hss\char'27\hss}}A}

  As a kind of summary, here are the `CODINGSCHEME's that result from
the various possible choices for reencoding.

default encoding
          (CODINGSCHEME TeX text + AdobeStandardEncoding)

`-p dc.enc'
          (CODINGSCHEME TeX text + DCEncoding)

`-t dc.enc'
          (CODINGSCHEME DCEncoding + AdobeStandardEncoding)

`-T dc.enc'
          (CODINGSCHEME DCEncoding + DCEncoding)

The `CODINGSCHEME' line appears in the VPL file but is ignored by Dvips.


File: dvips.info,  Node: Encoding file format,  Prev: Reencoding with Afm2tfm,  Up: Changing font encodings

Encoding file format
....................

  Afm2tfm's encoding files have the same format as an encoding vector
in a PostScript font.  Here is a skeletal example:

     % Comments are ignored, unless the first word after the percent sign
     % is `LIGKERN'; see below.
     /MyEncoding [ % exactly 256 entries follow, each with a leading `/'
       /Alpha /Beta /Gamma /Delta ...
       /A /B ... /Z
       ...  /.notdef /xfooaccent /yfooaccent /zfooaccent
     ] def

  These encoding files are downloaded as part of changing the encoding
at the PostScript level (see the previous section).

  Comments, which start with a percent sign and continue until the end
of the line, are ignored unless they start with `LIGKERN' (see below).

  The first non-comment word of the file must start with a forward slash
`/' (i.e., a PostScript literal name) and defines the name of the
encoding.  The next word must be an left bracket `['.  Following that
must be precisely 256 character names; use `/.notdef' for any that you
want to leave undefined.  Then there must be a matching right bracket
`]'.  A final `def' token is optional.  All names are case-sensitive.

  Any ligature or kern information is given as a comment.  If the first
word after the `%' is `LIGKERN', then the entire rest of the line is
parsed for ligature and kern information.  This ligature and kern
information is given in groups of words: each group is terminated by a
space and a semicolon and (unless the semicolon is at the end of a
line) another space.

  In these `LIGKERN' statements, three types of information may be
specified.  These three types are ligature pairs, kerns to ignore, and
the character value of this font's boundary character.

  Throughout a `LIGKERN' statement, the boundary character is specified
as `||'. To set the font's boundary character value for TeX:

     % LIGKERN || = 39 ;

  To indicate a kern to remove, give the names of the two characters
(without the leading slash) separated by `{}', as in `one {} one ;'.
This is intended to be reminiscent of the way you might use `{}' in a
TeX file to turn off ligatures or kerns at a particular location.
Either or both of the character names can be given as `*', which is a
wild card matching any character; thus, all kerns can be removed with
`* {} * ;'.

  To specify a ligature, specify the names of the pair of characters,
followed by the ligature operation (as in Metafont), followed by the
replacing character name.  Either (but not both) of the first two
characters can be `||' to indicate a word boundary.

  The most common operation is `=:' meaning that both characters are
removed and replaced by the third character, but by adding the `|'
character on either side of the `=:', you can retain either or both of
the two leading characters.  In addition, by suffixing the ligature
operation with one or two `>' signs, you can make the ligature scanning
operation skip that many resulting characters before proceeding.  This
works just like in Metafont.  For example, the `fi' ligature is
specified with `f i =: fi ;'.  A more convoluted ligature is `one one
|=:|>> exclam ;' which separates a pair of adjacent `1''s with an
exclamation point, and then skips over two of the resulting characters
before continuing searching for ligatures and kerns.  You cannot give
more >'s than |'s in an ligature operation, so there are a total of
eight possibilities:

     =: |=: |=:> =:| =:|> |=:| |=:|> |=:|>>

  The default set of ligatures and kerns built in to Afm2tfm is:

     % LIGKERN question quoteleft =: questiondown ;
     % LIGKERN exclam quoteleft =: exclamdown ;
     % LIGKERN hyphen hyphen =: endash ; endash hyphen =: emdash ;
     % LIGKERN quoteleft quoteleft =: quotedblleft ;
     % LIGKERN quoteright quoteright =: quotedblright ;
     % LIGKERN space {} * ; * {} space ; 0 {} * ; * {} 0 ;
     % LIGKERN 1 {} * ; * {} 1 ; 2 {} * ; * {} 2 ; 3 {} * ; * {} 3 ;
     % LIGKERN 4 {} * ; * {} 4 ; 5 {} * ; * {} 5 ; 6 {} * ; * {} 6 ;
     % LIGKERN 7 {} * ; * {} 7 ; 8 {} * ; * {} 8 ; 9 {} * ; * {} 9 ;


File: dvips.info,  Node: Special font effects,  Next: Afm2tfm options,  Prev: Changing font encodings,  Up: Invoking afm2tfm

Special font effects
--------------------

  Besides the reencodings described in the previous section, Afm2tfm can
do other manipulations.  (Again, it's best to use the prebuilt fonts
rather than attempting to remake them.)

  `-s SLANT' makes an obliqued variant, as in:

     afm2tfm Times-Roman -s .167 -v ptmro rptmro

This creates `ptmro.vpl' and `rptmro.tfm'.  To use this font, put the
line

     rptmro Times-Roman ".167 SlantFont"

into `psfonts.map'.  Then `rptmro' (our name for the obliqued Times)
will act as if it were a resident font, although it is actually
constructed from Times-Roman via the PostScript routine `SlantFont'
(which will slant everything 1/6 to the right, in this case).

  Similarly, you can get an expanded font with

     afm2tfm Times-Roman -e 1.2 -v ptmrre rptmrre

and by recording the pseudo-resident font

     rptmrre Times-Roman "1.2 ExtendFont"

in `psfonts.map'.

  You can also create a small caps font with a command such as

     afm2tfm Times-Roman -V ptmrc rptmrc

This will generate a set of pseudo-small caps mapped into the usual
lowercase positions and scaled down to 0.8 of the normal cap
dimensions.  You can also specify the scaling as something other than
the default 0.8:

     afm2tfm Times-Roman -c 0.7 -V ptmrc rptmrc

  It is unfortunately not possible to increase the width of the small
caps independently of the rest of the font.  If you want a really
professional looking set of small caps, you need to acquire a small caps
font.

  To change the `PaintType' in a font from filled (0) to outlined (2),
you can add `"/PaintType 2 store"' to `psfonts.map', as in the
following:

     rphvrl   Helvetica "/PaintType 2 store"

  Afm2tfm writes to standard output the line you need to add to
`psfonts.map' to use that font, assuming the font is resident in the
printer; if the font is not resident, you must add the `<FILENAME'
command to download the font.  Each identical line only needs to be
specified once in the `psfonts.map' file, even though many different
fonts (small caps variants, or ones with different output encodings)
may be based on it.


File: dvips.info,  Node: Afm2tfm options,  Prev: Special font effects,  Up: Invoking afm2tfm

Afm2tfm options
---------------

  Synopsis:
     afm2tfm [OPTION]... AFMFILE[.afm] [TFMFILE[.tfm]]

  Afm2tfm reads AFMFILE and writes a corresponding (but raw) TFM file.
If TFMFILE is not supplied, the base name of the AFM file is extended
with `.tfm' to get the output filename.

  The simplest example:

     afm2tfm Times-Roman rptmr

The TFM file thus created is "raw" because it omits ligature and kern
information, and does no character remapping; it simply contains the
character information in the AFM file in TFM form, which is the form
that TeX understands.  The characters have the same code in the TFM
file as in the AFM file.  For text fonts, this means printable ASCII
characters will work ok, but little else, because standard PostScript
fonts have a different encoding scheme than the one that plain TeX
expects (*note Encodings::.).  Although both schemes agree for the
printable ASCII characters, other characters such as ligatures and
accents vary.  Thus, in practice, it's almost always desirable to create
a virtual font as well with the `-v' or `-V' option.  *Note Making a
font available::.

  The command line options to Afm2tfm:

`-c RATIO'
     See `-V'; overrides the default ratio of 0.8 for the scaling of
     small caps.

`-e RATIO'
     Stretch characters horizontally by RATIO; if less than 1.0, you
     get a condensed font.

`-O'
     Output all character codes in the `vpl' file as octal numbers, not
     names; this is useful for symbol or other special-purpose fonts
     where character names such as `A' have no meaning.

`-p PS-ENC'
     Use PS-ENC for the destination (PostScript) encoding of the font;
     PS-ENC must be mentioned as a header file for the font in
     `psfonts.map'.  *Note Changing PostScript encodings::.

`-s SLANT'
     Slant characters to the right by SLANT.  If SLANT is negative, the
     letters slope to the left (or they might be upright if you start
     with an italic font).

`-t TEX-ENC'
     Use TEX-ENC for the target (TeX) encoding of the font.  Ligature
     and kern information may also be specified in FILE.  FILE is not
     mentioned in `psfonts.map'.

`-T PS-TEX-ENC'
     Use PS-TEX-ENC for both the PostScript and target TeX encodings of
     the font.  Equivalent to `-p FILE -t FILE'.

`-u'
     Use only those characters specified in the TeX encoding, and no
     others.  By default, Afm2tfm tries to include all characters in the
     input font, even those not present in the TeX encoding (it puts
     them into otherwise-unused positions, arbitrarily).

`-v VPL-FILE'
     Output a VPL (virtual property list) file, as well as a TFM file.

`-V VPL-FILE'
     Same as `-v', but the virtual font generated is a pseudo small caps
     font obtained by scaling uppercase letters by 0.8 to typeset
     lowercase. This font handles accented letters and retains proper
     kerning.


File: dvips.info,  Node: psfonts.map,  Prev: Invoking afm2tfm,  Up: PostScript fonts

`psfonts.map': PostScript font catalog
======================================

  The `psfonts.map' file associates a PostScript font with related
files and constructs.  Each line has the format:

     FILENAME POSTSCRIPT-NAME OPTIONS

  For example, the line
     rpstrn StoneInformal <StoneInformal.pfb

causes Dvips to download `StoneInformal.pfb' if your document (just as
if it were a header file, *note Header files::.) uses the font
`StoneInformal'.

  If the `j' config file or command-line option is enabled,
`StoneInformal.pfb' will be "partially downloaded"--only those
characters your document actually uses will be extracted and downloaded,
and the remainder discarded.  *Note Option details::.

  Filenames of fonts that are partially downloaded are surrounded by
curly braces (`{...}') in the progress report Dvips writes to standard
output.  Wholly-downloaded fonts appear inside angle brackets
(`<...>'), like other downloaded files.

  Adobe Multiple Master fonts, such as Minion, cannot be partially
downloaded.  To partially download in general, but avoid partial
downloading for individual fonts, use `<<' instead `<':
     pmnr8r Minion <<Minion.pfb

  You can generate transformed fonts with a line like this:
     rpstrc StoneInformal <StoneInformal.pfb ".8 ExtendFont"

*Note Special font effects::, for a complete list of font effects.

  You can change the encoding of the Type 1 font at the PostScript
level with a `ReEncodeFont' instruction, plus the name of the encoding
file.  This allows you access to characters that may be present in the
Type 1 font file, but not encoded by default--most of the preaccented
characters, for example.  An example:
     pstrn8r StoneInformal "TeXBase1Encoding ReEncodeFont" <8r.enc <pstrn8a.pfb

  The `8r' encoding mentioned here has been designed to serve as a base
for all downloadable fonts; it allows access to all the characters
commonly present in a Type 1 font.  For more details, see the `8r.enc'
source file that comes with (and is installed with) Dvips.

  You may notice that the same syntax is used for downloading encoding
vectors and Type 1 font files. To make your intentions clear, you can
also use `<[' to explicitly indicate you are downloading an encoding
vector, as in:
     pstrn8r StoneInformal "TeXBase1Encoding ReEncodeFont" <[8r.enc <pstrn8a.pfb

  If the filename of your encoding vector does not end in `.enc', and
you are using partial font downloading, you must use the `<[' syntax,
or Dvips will not download the font properly.

  Similarly, the name of the Type 1 font file itself must have extension
`.pfa' or `.pfb' for partial downloading to work properly.

  When using PFB files, Dvips is smart enough to unpack the binary PFB
format into printable ASCII so there is no need to perform this
conversion yourself.  In addition, Dvips scans the font to determine its
memory usage, just as it does for other header files (*note Header
files::.).

  Here is a brief summary of how `psfonts.map' is read:

  1. If a line is empty or begins with a space, percent, asterisk,
     semicolon, or hash mark, it is ignored.

  2. Otherwise, the line is separated into words, where words are
     separated by spaces or tabs, except that if a word begins with a
     double quote, it extends until the next double quote or the end of
     the line.

  3. If a word starts with `<<', it is taken as a font file to be
     wholly downloaded.  Use this to avoid partial downloading, as
     described above.

  4. If a word starts with `<[', it is taken as an encoding file to be
     downloaded.  Use this if the name of the encoding file does end in
     `.enc', also as described above.

  5. If a word starts with a `<' character, it is treated as a header
     file that needs to be downloaded.  If the name ends in `.pfa' or
     `.pfb', it is taken as Type 1 font file that will be partially
     downloaded if the `j' option is in effect.  There can be more than
     one such header for a given font.  If a `<' is a word by itself,
     the next word is taken as the name of the header file.

  6. If a word starts with a `"' character, it is taken as PostScript
     code used in generating that font, and is inserted into the output
     verbatim at the appropriate point.  (And the double quotes
     beginning and ending the word are removed.)

  7. Otherwise the word is a name. The first such name is the TFM file
     that a virtual font file can refer to.  If there is a second name,
     it is used as the PostScript name; if there is only one name, it
     is used for both the TeX name and the PostScript name.



File: dvips.info,  Node: Color,  Next: Index,  Prev: PostScript fonts,  Up: Top

Color
*****

  Dvips supports one-pass multi-color printing of TeX documents on any
color PostScript device.  Initially added by Jim Hafner, IBM Research,
<hafner@almaden.ibm.com>, the color support has gone through many
changes by Tomas Rokicki.  Besides the source code support itself, there
are additional TeX macro files: `colordvi.tex' and `blackdvi.tex', and
corresponding `.sty' versions for use with LaTeX.

  In this section we describe the use of color from the document
preparer's point of view and then add some instructions on installation
for the TeX administrator.

* Menu:

* Color macro files::           TeX macro definitions.
* User-definable colors::       Adding your own colors.
* Color subtleties::            Subtleties in using color.
* Ted Turner::                  Printing in black/white after colorizing.
* Color device configuration::  Configuring Dvips for color devices.
* Color support details::       Color support details


File: dvips.info,  Node: Color macro files,  Next: User-definable colors,  Up: Color

Color macro files
=================

  All the color macro commands are defined in `colordvi.tex' (or
`colordvi.sty').  To access these macros simply add to the top of your
plain TeX file the command:
     \input colordvi

For (the obsolete) LaTeX 2.09, add the `colordvi' style option as in:
     \documentstyle[12pt,colordvi]{article}

For LaTeX 2e, these examples are not applicable.  Instead, please see
the documentation for the graphics package, available from
`CTAN:doc/latex/graphics/'.  See also `CTAN:doc/epslatex.ps'.

  These macros provide two basic kinds of color macros: ones for local
color changes (a few words, a single symbol) and one for global color
changes (the whole document).  All the color names use a mixed case
scheme to avoid conflicts with other macros.  There are 68 predefined
colors, with names taken primarily from the Crayola crayon box of 64
colors, and one pair of macros for the user to set his own color pattern
(*note User-definable colors::.).  You can browse the file
`colordvi.tex' for a list of the predefined colors.  The comments in
this file also show a rough correspondence between the crayon names and
Pantones.

  A local color command has the form

     \COLORNAME{this is the color COLORNAME}

where COLORNAME is the name of a predefined color, e.g., `Blue'.  As
shown, these macros take one argument, the text to print in the
specified color.  This can be used for nested color changes since it
restores the original color state when it completes.  For example:

     This text is normal but here we are \Red{switching to red,
     \Blue{nesting blue}, recovering the red} and back to original.

The color nesting level has no hard limit, but it is not advisable to
nest too deeply lest you and the reader lose track of the color history.

  The global color command has the form

     \textCOLORNAME

These macros take no arguments and changes the default color from that
point on to COLORNAME.  This of course can be overridden globally by
another such command or locally by local color commands. For example,
expanding on the example above, we might have

     \textGreen
     This text is green but here we are \Red{switching to red,
     \Blue{nesting blue}, recovering the red} and back to
     original green.
     \textCyan
     The text from here on will be cyan until
     \Yellow{locally changed to yellow}. Now we are back to cyan.

  The color commands will even work in math mode and across math mode
boundaries.  This means that if you have a color before going into math
mode, the mathematics will be set in that color as well.  In alignment
environments like `\halign', `tabular' or `eqnarray', local color
commands cannot extend beyond the alignment characters.

  Because local color commands respect only some environment and
delimiter changes besides their own, care must be taken in setting
their scope.  It is best not to have them stretch too far.

  At the present time there are no macros for color environments in
LaTeX which might have a larger range.  This is primarily to keep the
TeX and LaTeX use compatible.


File: dvips.info,  Node: User-definable colors,  Next: Color subtleties,  Prev: Color macro files,  Up: Color

User-definable colors
=====================

  There are two ways for the user to specify colors not already defined.
For local changes, there is the command `\Color' which takes two
arguments.  The first argument is four numbers between zero and one and
specifies the intensity of cyan, magenta, yellow and black (CMYK) in
that order.  The second argument is the text that should appear in the
given color.  For example, suppose you want the words "this color is
pretty" to appear in a color which is 50% cyan, 85% magenta, 40% yellow
and 20% black.  You would use the command

     \Color{.5 .85 .4 .2}{this color is pretty}

  For global color changes, there is a command `\textColor' which takes
one argument, the CMYK quadruple of relative color intensities.  For
example, if you want the default color to be as above, then the command

     \textColor{.5 .85 .4 .2}
     The text from now on will be this pretty color

will do the trick.

  Making a global color change in the midst of nested local colors is
highly discouraged.  Consequently, Dvips will give you warning message
and do its best to recover by discarding the current color history.


File: dvips.info,  Node: Color subtleties,  Next: Ted Turner,  Prev: User-definable colors,  Up: Color

Color subtleties
================

  Color macros are defined via `\special' keywords.  As such, they are
put in the `.dvi' file only as explicit message strings to the driver.
The (unpleasant) result is that certain unprotected regions of the text
can have unwanted color side effects.  For example, if a color region
is split by TeX across a page boundary, then the footers of the current
page (e.g., the page number) and the headers of the next page can
inherit that color.  To avoid this effect globally, users should make
sure that these special regions of the text are defined with their own
local color commands.  For example, to protect the header and footer in
plain TeX, use

     \headline{\Black{My Header}}
     \footline{\Black{\hss\tenrm\folio\hss}}

  This warning also applies to figures and other insertions, so be
careful!

  Of course, in LaTeX, this is much more difficult to do because of the
complexity of the macros that control these regions.  This is
unfortunate but inevitable, because TeX and LaTeX were not written with
color in mind.

  Even when writing your own macros, much care must be taken.  The
macros that `colorize' a portion of the text work prefix the text work
by outputting one `\special' command to turn the color on before the
text, and outputting another `\special' command afterwards to restore
the original color.  It is often useful to ensure that TeX is in
horizontal mode before the first special command is issued; this can be
done by prefixing the color command with `\leavevmode'.


File: dvips.info,  Node: Ted Turner,  Next: Color device configuration,  Prev: Color subtleties,  Up: Color

Printing in black/white after colorizing
========================================

  If you have a TeX or LaTeX document written with color macros and you
want to print it in black and white there are two options.  On all
(good) PostScript devices, printing a color file will print in
corresponding gray levels.  This is useful to get a rough idea of the
colors without using expensive color printing devices.  The second
option is to replace the call to input `colordvi.tex' with
`blackdvi.tex' (and similarly for the `.sty' files).  So in the above
example, replacing the word `colordvi' with `blackdvi' suffices.
`blackdvi.tex' defines the color macros as no-ops, and so will produce
normal black/white printing.  By this simple mechanism, the user can
switch to all black/white printing without having to ferret out the
color commands.  Also, some device drivers, particularly non-PostScript
ones like screen previewers, will simply ignore the color commands and
so print in black/white.  Hopefully, in the future screen previewers
for color displays will be compatible with some form of color support.

