/* Portability cruft.  Include after config.h and sys/types.h.
   Copyright 1996, 1998-2000, 2007, 2009-2013 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA
   02110-1301, USA.  */

#ifndef GREP_SYSTEM_H
#define GREP_SYSTEM_H 1

#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

#include "binary-io.h"
#include "configmake.h"
#include "dirname.h"
#include "minmax.h"
#include "same-inode.h"

#if O_BINARY
# define HAVE_DOS_FILE_CONTENTS 1
# if __DJGPP__ == 2
#  if __DJGPP_MINOR__ < 4
/* Has dir eacces bug.  */
#   ifdef EISDIR
#    define is_EISDIR(e, f) \
       ((e) == EISDIR \
        || ((e) == EACCES && isdir(f) && ((e) = EISDIR, 1)))
#   else
#    define is_EISDIR(e, f)  ((e) == EACCES && isdir (f))
#   endif
#  endif  /* __DJGPP_MINOR__ < 4  */

#  include <libc/unconst.h>
#  define IS_DIR_SEPARATOR(c)  ((c) == '/' || (c) == '\\' || (c) == ':')
#  define STRIP_FULL_PATH_AND_EXTENSION(file_name)     \
   (__extension__                                      \
     ({                                                \
        char *_dst, *_src;                             \
        _dst = _src = unconst((file_name), char *);    \
        while (*_src++)                                \
          ;                                            \
        while ((_src - _dst) && (*--_src != '.'))      \
          ;                                            \
        for (*_src = '\0'; (_src - _dst); _src--)      \
          if (IS_DIR_SEPARATOR(*_src))                 \
            break;                                     \
        if (_src - _dst)                               \
          while ((*_dst++ = *++_src))                  \
            ;                                          \
        (file_name);                                   \
     })                                                \
   )
#  define STRIP_EXTENSION(file_name)                   \
   (__extension__                                      \
     ({                                                \
        char *_begin, *_end;                           \
        _begin = _end = unconst((file_name), char *);  \
        while (*_end++)                                \
          ;                                            \
        while ((_end - _begin) && (*--_end != '.'))    \
          ;                                            \
        if (*_end == '.')                              \
          *_end = '\0';                                \
        (file_name);                                   \
     })                                                \
   )
#  define CANONICALIZE_PATH(path)                      \
   (__extension__                                      \
     ({                                                \
        if ((path))                                    \
        {                                              \
          char *_p = unconst((path), char *);          \
          for (; *_p; _p++)                            \
            if (*_p == '\\')                           \
              *_p = '/';                               \
        }                                              \
        (path);                                        \
     })                                                \
   )
# else  /* !__DJGPP__  */
#  define STRIP_FULL_PATH_AND_EXTENSION(file_name)  (file_name)
#  define STRIP_EXTENSION(file_name)                (file_name)
#  define CANONICALIZE_PATH(path)                   (path)
# endif  /* !__DJGPP__  */
#endif

#include <stdlib.h>
#include <stddef.h>
#include <limits.h>
#include <string.h>
#include <ctype.h>

enum { EXIT_TROUBLE = 2 };

#include <gettext.h>
#define N_(String) gettext_noop(String)
#define _(String) gettext(String)

#include <locale.h>

#ifndef initialize_main
# define initialize_main(argcp, argvp)
#endif

#include "unlocked-io.h"

#define STREQ(a, b) (strcmp (a, b) == 0)

#endif
