/* Copyright (C) 2009 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 1998 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 1994 DJ Delorie, see COPYING.DJ for details */
#include <libc/stubs.h>
#include <stdio.h>
#include <unistd.h>

#include "../include/libc/file-2.03.h"
#include "../include/libc/fd_props.h"
#include "libsupp.h"

void  libsupp_rewind_2_03(FILE *_f);
int   libsupp_fflush_2_03(FILE *_f);
off_t libsupp_lseek_2_03(int _handle, off_t _offset, int _whence);


void libsupp_rewind_2_03(FILE *f)
{
  const int fd = fileno(f);

  /* If this is a FILE for a directory, we must maintain its EOF flag.
   * Just return. */
  if (libsupp___get_fd_flags(fd) & FILE_DESC_DIRECTORY)
    return;

  libsupp_fflush_2_03(f);
  libsupp_lseek_2_03(fileno(f), 0L, SEEK_SET);
  f->_fillsize = 512;	/* See comment in filbuf.c */
  f->_cnt = 0;
  f->_ptr = f->_base;
  f->_flag &= ~(_IOERR|_IOEOF);
  if (f->_flag & _IORW)
    f->_flag &= ~(_IOREAD|_IOWRT);
}
