/* Copyright (C) 2008 DJ Delorie, see COPYING.DJ for details */
#include <string.h>

#include "libsupp.h"


error_t
libsupp_argz_add(char **argz, size_t *argz_len, const char *str)
{
  /*
   *  Add STR to the end of the argz vector in ARGZ of length ARGZ_LEN.
   *  If a memory allocation error occurs, ENOMEM is returned,
   *  otherwise 0.
   */

  return libsupp_argz_append(argz, argz_len, str, strlen(str) + 1);
}
