/* Copyright (C) 2009 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 2001 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 1999 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <libc/stubs.h>
#include <sys/types.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <libc/dosio.h>
#include <io.h>

#include "../include/libc/file-2.03.h"
#include "../include/libc/fd_props.h"
#include "libsupp.h"

FILE *libsupp_freopen_2_03(const char *_file, const char *_mode, FILE *_f);
int   libsupp_fclose_2_03(FILE *_f);
int   libsupp__close_2_03(int _handle);
int   libsupp_dup2_2_03(int _fd, int _newfd);
off_t libsupp_lseek_2_03(int _handle, off_t _offset, int _whence);
int   libsupp_open_2_03(const char* _filename, int _oflag, ...);

FILE *
libsupp_freopen_2_03(const char *file, const char *mode, FILE *f)
{
  int fd, fdo, rw, oflags=0;
  char tbchar;

  if (file == 0 || mode == 0 || f == 0)
    return 0;

  rw = (mode[1] == '+') || (mode[1] && (mode[2] == '+'));

  fdo = fileno(f);
  libsupp_fclose_2_03(f);

  switch (*mode) {
  case 'a':
    oflags = O_CREAT | (rw ? O_RDWR : O_WRONLY);
    break;
  case 'r':
    oflags = rw ? O_RDWR : O_RDONLY;
    break;
  case 'w':
    oflags = O_TRUNC | O_CREAT | (rw ? O_RDWR : O_WRONLY);
    break;
  default:
    return NULL;
  }
  if (mode[1] == '+')
    tbchar = mode[2];
  else
    tbchar = mode[1];
  if (tbchar == 't')
    oflags |= O_TEXT;
  else if (tbchar == 'b')
    oflags |= O_BINARY;
  else
    oflags |= (_fmode & (O_TEXT|O_BINARY));

  fd = libsupp_open_2_03(file, oflags, 0666);
  if (fd < 0)
    return NULL;

  if(fd != fdo) {			/* This should rarely happen, but if it does for */
    libsupp_dup2_2_03(fd, fdo);		/* stdin/stdout/stderr handles, we must fix it or */
    libsupp__close_2_03(fd);		/* child processes won't popen properly. */
    fd = fdo;
  }

  if (*mode == 'a')
    libsupp_lseek_2_03(fd, 0L, SEEK_END);

  f->_cnt = 0;
  f->_file = fd;
  f->_bufsiz = 0;
  if (rw)
    f->_flag = _IORW;
  else if (*mode == 'r')
    f->_flag = _IOREAD;
  else
    f->_flag = _IOWRT;

  f->_base = f->_ptr = NULL;

  /* If this is a FILE for a directory, we need to make sure certain
   * flags are clear and certain flags are set. Namely:
   *
   * - The read flag should be clear, since reads aren't allowed.
   * - The write flag should be clear, since writes aren't allowed.
   * - The read-write flag should be clear, because of the above.
   * - The EOF flag should be set, so that certain functions
   *   fail reads and writes. (Easier than modifying the functions).
   */
  if (libsupp___get_fd_flags(fd) & FILE_DESC_DIRECTORY)
  {
    f->_flag &= ~(_IORW|_IOREAD|_IOWRT);
    f->_flag |= _IOEOF;
  }

  return f;
}
