/* Copyright (C) 2008 DJ Delorie, see COPYING.DJ for details */
#include <stdlib.h>
#include <string.h>

#include "libsupp.h"


error_t
libsupp_argz_add_sep(char **argz, size_t *argz_len, const char *str, int sep)
{
  /*
   *  Add SEP separated list in STR to the end of the argz vector
   *  in ARGZ with length ARGZ_LEN adjusted accordingly.
   *  If a memory allocation error occurs, ENOMEM is returned,
   *  otherwise 0.
   */

  char *str_argz = NULL;
  size_t str_argz_len = 0;


  libsupp_argz_create_sep(str, sep, &str_argz, &str_argz_len);

  if (str_argz_len)
  {
    size_t new_argz_len = *argz_len + str_argz_len;

    *argz = realloc(*argz, new_argz_len);
    if (*argz == NULL)
      return ENOMEM;

    memcpy(*argz + *argz_len, str_argz, str_argz_len);
    *argz_len = new_argz_len;
  }

  return 0;
}
