/* Copyright (C) 2008 DJ Delorie, see COPYING.DJ for details */
#include <stdlib.h>
#include <string.h>
#include <stddef.h>

#include "libsupp.h"


error_t
libsupp_argz_replace(char **argz, size_t *argz_len, const char *str, const char *with, unsigned *replace_count)
{
  /*
   *  Replace any occurrences of the string STR in the argz vector ARGZ with string WITH,
   *  reallocating ARGZ as necessary.  If REPLACE_COUNT is non-zero, *REPLACE_COUNT will be
   *  incremented by number of replacements performed.
   *  If a memory allocation error occurs, ENOMEM is returned,
   *  otherwise 0.
   */

  error_t error = 0;


  if (str && *str)
  {
    char *entry, *dst, *src;
    size_t dst_len, src_len;
    size_t str_len, with_len;

    entry = NULL;
    dst = NULL;
    dst_len = 0;
    src = *argz;
    src_len = *argz_len;
    str_len = strlen(str);
    with_len = strlen(with);
    while (!error && (entry = libsupp_argz_next(src, src_len, entry)))
      if (strstr(entry, str))
      {
        dst_len = src_len + with_len - str_len;
        dst =  malloc(dst_len);
        if (dst == NULL)
          error = ENOMEM;
        else
        {
          ptrdiff_t len;

          len = entry - src;
          memcpy(dst, src, len);
          memcpy(dst + len, with, with_len);
          memcpy(dst + len + with_len, entry + str_len, src_len - (len + str_len));

          entry = dst + len + with_len + 1;
          free(src);
          src = dst;
          src_len = dst_len;
          if (replace_count)
            (*replace_count)++;
        }
      }
    *argz = src;
    *argz_len = src_len;
  }

  return error;
}
