/* Copyright (C) 2008 DJ Delorie, see COPYING.DJ for details */
#include <stdlib.h>
#include <conio.h>

#include "libsupp.h"

int
libsupp_cprintf(const char *fmt, ...)
{
  int      cnt;
  char    *buf;
  va_list  ap;
  
  va_start(ap, fmt);
  cnt = libsupp_vasprintf(&buf, fmt, ap);
  va_end(ap);
  
  if (cnt != EOF)
  {
    cputs(buf);
    free(buf);
  }

  return cnt;
}
