/* Copyright (C) 2008 DJ Delorie, see COPYING.DJ for details */
#include <string.h>

#include "../include/libc/unconst.h"
#include "libsupp.h"


void *
libsupp_memmem(const void *haystack, size_t haystack_len, const void *needle, size_t needle_len)
{
  if (haystack == NULL || needle == NULL)
    return NULL;
  else if (needle_len == 0)
    /*  The first occurrence of the empty string is deemed to occur at the beginning of the string.  */
    return unconst(haystack, void *);
  else if (haystack_len < needle_len)
    /*  Sanity check, otherwise the loop might search through the whole memory.  */
    return NULL;
  else
  {
    const unsigned char *begin;
    const unsigned char *const last_possible = (const unsigned char *const) haystack + haystack_len - needle_len + 1;

    for (begin = haystack; begin < last_possible; begin++)
      if (!memcmp(begin, needle, needle_len))
        return (void *)unconst(begin, unsigned char *);
    return NULL;
  }
}
